/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.CmdHistoryIO;
import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mde.cmdhist.HistoryChangedListener;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;

public class CmdHistory {
    private int fMostRecent = -1;
    private Vector fList = new Vector(25, 10);
    private ListIterator fListIterator = null;
    private int fCommandsAddedSinceLastSave = -1;
    private boolean fSavePending = false;
    private String fLastCommand = "";
    private static CmdHistory sHistory;
    private HistoryChangedListener fListener;
    private static boolean sHistoryLoading;
    private static int ERROR;

    public static void load(File file) {
        sHistoryLoading = true;
        CmdHistoryIO.loadHistory(file);
        sHistoryLoading = false;
        sHistory.resetIterator();
    }

    public static void save(File file) {
    }

    private CmdHistory() {
        this.reset();
    }

    Vector getHistoryCommands() {
        return this.fList;
    }

    public synchronized String[] getSessionHistory() {
        String string;
        Vector<String> vector = new Vector<String>();
        for (int i = this.fList.size() - 1; i >= 0 && !(string = (String)this.fList.elementAt(i)).startsWith("%--"); --i) {
            vector.insertElementAt(string, 0);
        }
        String[] stringArray = new String[vector.size()];
        stringArray = vector.toArray(stringArray);
        return stringArray;
    }

    synchronized String[] getAllHistory() {
        String[] stringArray = new String[this.fList.size()];
        stringArray = this.fList.toArray(stringArray);
        return stringArray;
    }

    void save() {
        if (CmdHistoryPrefs.getNumCommandsToSave() != -1) {
            CmdHistoryIO.saveHistory();
            this.fCommandsAddedSinceLastSave = 0;
        }
    }

    void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.fListener = historyChangedListener;
    }

    public synchronized void add(Object object, boolean bl) {
        int n;
        if (!CmdHistoryPrefs.getSaveDuplicates() && this.fLastCommand.equals(object) && !object.toString().trim().equals("end")) {
            return;
        }
        if (!CmdHistoryPrefs.getSaveExitQuit() && (object.equals("exit") || object.equals("quit"))) {
            return;
        }
        this.fList.add(object.toString().trim());
        ++this.fCommandsAddedSinceLastSave;
        this.fLastCommand = (String)object;
        if (!sHistoryLoading && (n = CmdHistoryPrefs.getNumCommandsToSave()) >= 0) {
            if (bl && (this.fCommandsAddedSinceLastSave >= n || this.fSavePending)) {
                this.save();
                this.fSavePending = false;
            } else if (this.fCommandsAddedSinceLastSave >= n && !bl) {
                this.fSavePending = true;
            }
        }
        if (this.fListener != null && !sHistoryLoading) {
            this.fListener.commandAdded(this.fList.size() - 1, bl);
        }
    }

    public void add(Object object) {
        this.add(object, true);
    }

    public static CmdHistory getInstance() {
        return sHistory;
    }

    public boolean hasNext() {
        if (!this.resetIterator()) {
            return false;
        }
        if (this.fMostRecent == this.fList.size() - 1) {
            return false;
        }
        return this.fListIterator.hasNext();
    }

    public boolean hasPrevious() {
        if (!this.resetIterator()) {
            return false;
        }
        return this.fListIterator.hasPrevious();
    }

    public Object next() {
        if (!this.resetIteratorForNext()) {
            return null;
        }
        if (!this.fListIterator.hasNext()) {
            return "";
        }
        int n = this.nextIndex();
        if (n != ERROR) {
            this.fMostRecent = n;
        }
        return this.fListIterator.next();
    }

    public Object next(String string) {
        if (string.equals("")) {
            return this.next();
        }
        if (!this.resetIteratorForNext()) {
            return null;
        }
        boolean bl = false;
        String string2 = "";
        while (!bl && this.fListIterator.hasNext()) {
            string2 = (String)this.fListIterator.next();
            if (!string2.startsWith(string)) continue;
            bl = true;
        }
        if (!bl) {
            string2 = null;
        } else {
            this.fListIterator.previous();
            int n = this.nextIndex();
            if (n != ERROR) {
                this.fMostRecent = n;
            }
        }
        return string2;
    }

    public int nextIndex() {
        if (!this.resetIterator()) {
            return ERROR;
        }
        return this.fListIterator.nextIndex();
    }

    public Object previous() {
        if (!this.resetIteratorForPrevious()) {
            return null;
        }
        if (!this.fListIterator.hasPrevious()) {
            return null;
        }
        int n = this.previousIndex();
        if (n != ERROR) {
            this.fMostRecent = n;
        }
        return this.fListIterator.previous();
    }

    public Object previous(String string) {
        if (string.equals("")) {
            return this.previous();
        }
        if (!this.resetIteratorForPrevious()) {
            return null;
        }
        boolean bl = false;
        String string2 = "";
        while (!bl && this.fListIterator.hasPrevious()) {
            string2 = (String)this.previous();
            if (!string2.startsWith(string)) continue;
            bl = true;
        }
        if (!bl) {
            string2 = null;
            this.fMostRecent = -1;
        }
        return string2;
    }

    public int previousIndex() {
        if (!this.resetIterator()) {
            return ERROR;
        }
        return this.fListIterator.previousIndex();
    }

    public void remove() {
        throw new UnsupportedOperationException("Unsupported");
    }

    public synchronized void remove(int n) {
        if (!this.resetIterator()) {
            return;
        }
        if (n == this.fList.size() - 1) {
            this.fLastCommand = this.fList.size() > 1 ? (String)this.fList.get(this.fList.size() - 2) : "";
        }
        int n2 = this.fListIterator.nextIndex();
        this.fList.removeElementAt(n);
        if (n < n2) {
            --n2;
        }
        this.fListIterator = this.fList.listIterator(n2);
        if (this.fListener != null) {
            this.fListener.commandRemoved(n);
        }
    }

    public synchronized void removeAll() {
        if (!this.resetIterator()) {
            return;
        }
        this.fLastCommand = "";
        this.fList.removeAllElements();
        this.reset();
        if (this.fListener != null) {
            this.fListener.allCommandsRemoved();
        }
    }

    public void reset() {
        this.fMostRecent = -1;
    }

    void resetAtTop() {
        this.fMostRecent = -2;
    }

    public void set(Object object) {
        throw new UnsupportedOperationException("Unsupported");
    }

    private boolean resetIteratorForNext() {
        if (!this.resetIterator()) {
            return false;
        }
        if (this.fMostRecent == this.fListIterator.nextIndex() && this.fListIterator.hasNext()) {
            this.fListIterator.next();
        }
        return true;
    }

    private boolean resetIteratorForPrevious() {
        if (!this.resetIterator()) {
            return false;
        }
        if (this.fMostRecent == this.previousIndex() && this.fMostRecent > 0) {
            this.fListIterator.previous();
        }
        return true;
    }

    private boolean resetIterator() {
        if (sHistoryLoading) {
            return false;
        }
        if (this.fMostRecent == -1) {
            this.fListIterator = this.fList.listIterator(this.fList.size());
        } else if (this.fMostRecent == -2) {
            this.fListIterator = this.fList.listIterator();
        }
        return true;
    }

    static {
        sHistoryLoading = false;
        ERROR = -3;
        sHistory = new CmdHistory();
        CmdHistory.load(CmdHistoryIO.getCurrentSaveFile());
    }
}

