/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.EventRegistration;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.LookupUnmarshalException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerRegistration
implements LookupDiscoveryRegistration,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid registrationID;
    final EventRegistration eventReg;
    static /* synthetic */ Class class$net$jini$discovery$LookupDiscoveryRegistration;
    static /* synthetic */ Class class$com$sun$jini$fiddler$Fiddler;
    static /* synthetic */ Class class$net$jini$id$Uuid;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lnet$jini$core$discovery$LookupLocator;
    static /* synthetic */ Class class$net$jini$core$lookup$ServiceRegistrar;

    public static FiddlerRegistration createRegistration(Fiddler fiddler, Uuid uuid, EventRegistration eventRegistration) {
        if (fiddler instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerRegistration(fiddler, uuid, eventRegistration, null);
        }
        return new FiddlerRegistration(fiddler, uuid, eventRegistration);
    }

    private FiddlerRegistration(Fiddler fiddler, Uuid uuid, EventRegistration eventRegistration) {
        this.server = fiddler;
        this.registrationID = uuid;
        this.eventReg = eventRegistration;
    }

    public EventRegistration getEventRegistration() {
        return this.eventReg;
    }

    public Lease getLease() {
        return this.eventReg.getLease();
    }

    public ServiceRegistrar[] getRegistrars() throws LookupUnmarshalException, RemoteException {
        AbstractCollection abstractCollection;
        MarshalledObject[] marshalledObjectArray = null;
        try {
            marshalledObjectArray = this.server.getRegistrars(this.registrationID);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
        if (marshalledObjectArray == null) {
            return null;
        }
        ServiceRegistrar[] serviceRegistrarArray = new ServiceRegistrar[marshalledObjectArray.length];
        if (serviceRegistrarArray.length > 0) {
            abstractCollection = new ArrayList<MarshalledObject>();
            for (int i = 0; i < marshalledObjectArray.length; ++i) {
                ((ArrayList)abstractCollection).add(marshalledObjectArray[i]);
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = FiddlerRegistration.unmarshalRegistrars(abstractCollection, arrayList);
            FiddlerRegistration.insertRegistrars(serviceRegistrarArray, arrayList);
            if (arrayList2.size() > 0) {
                throw new LookupUnmarshalException(arrayList.toArray(new ServiceRegistrar[arrayList.size()]), ((ArrayList)abstractCollection).toArray(new MarshalledObject[((ArrayList)abstractCollection).size()]), arrayList2.toArray(new Throwable[arrayList2.size()]), "failed to unmarshal at least one ServiceRegistrar");
            }
        } else {
            return serviceRegistrarArray;
        }
        abstractCollection = new HashSet();
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            if (serviceRegistrarArray[i] == null) continue;
            ((HashSet)abstractCollection).add(serviceRegistrarArray[i]);
        }
        return ((HashSet)abstractCollection).toArray(new ServiceRegistrar[((HashSet)abstractCollection).size()]);
    }

    public String[] getGroups() throws RemoteException {
        try {
            return this.server.getGroups(this.registrationID);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return new String[0];
        }
    }

    public LookupLocator[] getLocators() throws RemoteException {
        try {
            return this.server.getLocators(this.registrationID);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
            return null;
        }
    }

    public void addGroups(String[] stringArray) throws RemoteException {
        try {
            this.server.addGroups(this.registrationID, stringArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void setGroups(String[] stringArray) throws RemoteException {
        try {
            this.server.setGroups(this.registrationID, stringArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void removeGroups(String[] stringArray) throws RemoteException {
        try {
            this.server.removeGroups(this.registrationID, stringArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void addLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        try {
            this.server.addLocators(this.registrationID, lookupLocatorArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void setLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        try {
            this.server.setLocators(this.registrationID, lookupLocatorArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void removeLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        try {
            this.server.removeLocators(this.registrationID, lookupLocatorArray);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public void discard(ServiceRegistrar serviceRegistrar) throws RemoteException {
        try {
            this.server.discard(this.registrationID, serviceRegistrar);
        }
        catch (ThrowThis throwThis) {
            throwThis.throwRemoteException();
        }
    }

    public Uuid getReferentUuid() {
        return this.registrationID;
    }

    public int hashCode() {
        return this.registrationID.hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private static ArrayList unmarshalRegistrars(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Exception> arrayList3 = new ArrayList<Exception>();
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            try {
                MarshalledObject marshalledObject = (MarshalledObject)arrayList.get(n);
                ServiceRegistrar serviceRegistrar = (ServiceRegistrar)marshalledObject.get();
                arrayList2.add(serviceRegistrar);
                arrayList.remove(n);
                continue;
            }
            catch (IOException iOException) {
                arrayList3.add(iOException);
                ++n;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList3.add(classNotFoundException);
                ++n;
            }
        }
        return arrayList3;
    }

    private static void insertRegistrars(ServiceRegistrar[] serviceRegistrarArray, ArrayList arrayList) {
        if (serviceRegistrarArray != null && arrayList != null) {
            int n = serviceRegistrarArray.length;
            int n2 = arrayList.size();
            if (n == 0 || n2 == 0) {
                return;
            }
            int n3 = FiddlerRegistration.indexFirstNull(serviceRegistrarArray);
            int n4 = n3 + n2 <= n ? n3 + n2 : n;
            int n5 = n3;
            int n6 = 0;
            while (n5 < n4) {
                serviceRegistrarArray[n5] = (ServiceRegistrar)arrayList.get(n6);
                ++n5;
                ++n6;
            }
        }
    }

    private static int indexFirstNull(Object[] objectArray) {
        int n = -1;
        if (objectArray == null || objectArray.length == 0) {
            return n;
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != null) continue;
            return n;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - server field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - registrationID field is null");
        }
        if (this.eventReg == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg field is null");
        }
        if (!EventRegistration.class.equals(this.eventReg.getClass())) {
            throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg class is not EventRegistration");
        }
        Object object = this.eventReg.getSource();
        if (object == null) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg source is null");
        }
        if (!(object instanceof FiddlerProxy)) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg source is not an instance of FiddlerProxy");
        }
        Lease lease = this.eventReg.getLease();
        if (!(lease instanceof FiddlerLease)) {
            throw new InvalidObjectException("FiddlerRegistration.readObject failure - eventReg lease is not an instance of FiddlerLease");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerRegistration instance");
    }

    static final class ConstrainableFiddlerRegistration
    extends FiddlerRegistration
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method[] methodMapArray = new Method[]{ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "getRegistrars", new Class[0]), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "getRegistrars", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "getGroups", new Class[0]), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "getGroups", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "getLocators", new Class[0]), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "getLocators", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "addGroups", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "addGroups", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "setGroups", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "setGroups", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "removeGroups", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "removeGroups", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerRegistration.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "addLocators", new Class[]{array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "addLocators", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "setLocators", new Class[]{array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "setLocators", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "removeLocators", new Class[]{array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "removeLocators", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerRegistration.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator}), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryRegistration == null ? (class$net$jini$discovery$LookupDiscoveryRegistration = FiddlerRegistration.class$("net.jini.discovery.LookupDiscoveryRegistration")) : class$net$jini$discovery$LookupDiscoveryRegistration, "discard", new Class[]{class$net$jini$core$lookup$ServiceRegistrar == null ? (class$net$jini$core$lookup$ServiceRegistrar = FiddlerRegistration.class$("net.jini.core.lookup.ServiceRegistrar")) : class$net$jini$core$lookup$ServiceRegistrar}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerRegistration.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "discard", new Class[]{class$net$jini$id$Uuid == null ? (class$net$jini$id$Uuid = FiddlerRegistration.class$("net.jini.id.Uuid")) : class$net$jini$id$Uuid, class$net$jini$core$lookup$ServiceRegistrar == null ? (class$net$jini$core$lookup$ServiceRegistrar = FiddlerRegistration.class$("net.jini.core.lookup.ServiceRegistrar")) : class$net$jini$core$lookup$ServiceRegistrar})};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerRegistration(Fiddler fiddler, Uuid uuid, EventRegistration eventRegistration, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerRegistration.constrainServer(fiddler, methodConstraints), uuid, eventRegistration);
            this.methodConstraints = methodConstraints;
        }

        private static Fiddler constrainServer(Fiddler fiddler, MethodConstraints methodConstraints) {
            MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMapArray);
            RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)fiddler).setConstraints(methodConstraints2);
            return (Fiddler)remoteMethodControl;
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            return new ConstrainableFiddlerRegistration(this.server, this.registrationID, this.eventReg, methodConstraints);
        }

        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
            Object object = this.eventReg.getSource();
            if (!(object instanceof FiddlerProxy.ConstrainableFiddlerProxy)) {
                throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg source is not an instance  of ConstrainableFiddlerProxy");
            }
            Lease lease = this.eventReg.getLease();
            if (!(lease instanceof FiddlerLease.ConstrainableFiddlerLease)) {
                throw new InvalidObjectException("ConstrainableFiddlerRegistration.readObject failure - eventReg lease is not an instance  of ConstrainableFiddlerLease");
            }
        }
    }
}

