/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.xml;

import com.mathworks.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.xml.resources.RES_XMLValidator");

    private XMLValidator() {
    }

    public static ValidationResults validateFile(String string, String string2) throws ParserConfigurationException, SAXException, IOException {
        Vector<String> vector = null;
        if (string2 != null) {
            vector = new Vector<String>();
            vector.add(string2);
        }
        return XMLValidator.validateFile(string, vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationResults validateFile(String string, Vector<String> vector) throws ParserConfigurationException, SAXException, IOException {
        ValidationResults validationResults;
        FileInputStream fileInputStream = null;
        Vector<InputStream> vector2 = null;
        try {
            fileInputStream = new FileInputStream(string);
            vector2 = new Vector<InputStream>();
            for (String object2 : vector) {
                FileInputStream fileInputStream2 = new FileInputStream(object2);
                vector2.add(fileInputStream2);
            }
            ValidationResults validationResults2 = XMLValidator.validate((InputStream)fileInputStream, vector2);
            validationResults2.setFilenames(string, vector);
            validationResults = validationResults2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            for (InputStream inputStream : vector2) {
                IOUtils.closeQuietly((InputStream)((FileInputStream)inputStream));
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        for (InputStream inputStream : vector2) {
            IOUtils.closeQuietly((InputStream)((FileInputStream)inputStream));
        }
        return validationResults;
    }

    private static DocumentBuilder setupBuilder(Object[] objectArray, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        for (Object object : objectArray) {
            assert (object instanceof File || object instanceof InputStream) : "schemaSource not a File or InputStream: " + object;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, objectArray);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder;
    }

    public static ValidationResults validate(InputStream inputStream, InputStream inputStream2) throws ParserConfigurationException, SAXException, IOException {
        Vector<InputStream> vector = null;
        if (inputStream2 != null) {
            vector = new Vector<InputStream>();
            vector.add(inputStream2);
        }
        return XMLValidator.validate(inputStream, vector);
    }

    public static ValidationResults validate(InputStream inputStream, Vector<InputStream> vector) throws ParserConfigurationException, SAXException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("XML stream cannot be null.");
        }
        if (vector == null || vector.isEmpty()) {
            throw new IllegalArgumentException("Schema stream cannot be null.");
        }
        SimpleHandler simpleHandler = new SimpleHandler();
        DocumentBuilder documentBuilder = XMLValidator.setupBuilder(vector.toArray(), simpleHandler);
        documentBuilder.parse(inputStream);
        return simpleHandler.getResults();
    }

    public static class ValidationResults {
        private Vector<SAXParseException> fErrors = new Vector();
        private Vector<String> fSchemas;
        private String fFilename;

        public boolean hasErrors() {
            return !this.fErrors.isEmpty();
        }

        public Vector<SAXParseException> getErrors() {
            return new Vector<SAXParseException>(this.fErrors);
        }

        void addError(SAXParseException sAXParseException) {
            this.fErrors.add(sAXParseException);
        }

        public String getErrorMessage() {
            String string = this.fFilename == null ? null : StringUtils.replaceAllStrings((String)FilenameUtils.separatorsToSystem((String)this.fFilename), (String)"\\", (String)"\\\\");
            Vector<String> vector = null;
            if (this.fSchemas != null && !this.fSchemas.isEmpty()) {
                vector = new Vector<String>();
                for (String string2 : this.fSchemas) {
                    vector.add(StringUtils.replaceAllStrings((String)FilenameUtils.separatorsToSystem((String)string2), (String)"\\", (String)"\\\\"));
                }
            }
            return StringUtils.quoteSingleQuotes((String)this.constructString(string, vector, true));
        }

        private String constructString(String string, Vector<String> vector, boolean bl) {
            String string2 = bl ? "\\n" : "\n";
            String string3 = vector != null && !vector.isEmpty() && string != null ? MessageFormat.format(sRes.getString("msg.Failed"), string, vector.toArray()) : sRes.getString("msg.FailedInputStreams");
            string3 = string3.concat(string2 + string2);
            for (SAXParseException sAXParseException : this.getErrors()) {
                string3 = string3.concat(((Object)sAXParseException).toString() + string2);
            }
            return string3;
        }

        public String getSimpleStringMessage() {
            return this.constructString(this.fFilename, this.fSchemas, false);
        }

        private void setFilenames(String string, Vector<String> vector) {
            this.fFilename = string;
            this.fSchemas = vector;
        }
    }

    private static class SimpleHandler
    extends DefaultHandler {
        private ValidationResults fResults = new ValidationResults();

        private SimpleHandler() {
        }

        private ValidationResults getResults() {
            return this.fResults;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.fResults.addError(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.fResults.addError(sAXParseException);
        }
    }
}

