/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

class InstalledDocProduct {
    private static final String SHORTNAME_PROP = "shortname";
    private static final String DISPLAYNAME_PROP = "displayname";
    private static final String STATUS_PROP = "status";
    private final String shortName;
    private final String displayName;
    private final String helpLoc;
    private final Set<DocDestination> destinations;

    private InstalledDocProduct(String string, String string2, String string3, String string4) {
        this.helpLoc = string;
        this.displayName = string2;
        this.shortName = string3;
        this.destinations = InstalledDocProduct.resolveDestinations(string4);
    }

    static InstalledDocProduct buildProduct(String string, String string2, String string3, String string4) {
        return new InstalledDocProduct(string, string2, string3, string4);
    }

    static InstalledDocProduct buildProduct(String string, Properties properties) {
        String string2 = properties.getProperty(DISPLAYNAME_PROP);
        String string3 = properties.containsKey(SHORTNAME_PROP) ? properties.getProperty(SHORTNAME_PROP) : string.replaceFirst(".*/", "");
        String string4 = properties.containsKey(STATUS_PROP) ? properties.getProperty(STATUS_PROP) : null;
        return InstalledDocProduct.buildProduct(string, string2, string3, string4);
    }

    private static Set<DocDestination> resolveDestinations(String string) {
        if (string == null || string.trim().length() == 0) {
            return EnumSet.allOf(DocDestination.class);
        }
        if (string.equalsIgnoreCase("web_only")) {
            return EnumSet.of(DocDestination.WEB);
        }
        if (string.equalsIgnoreCase("install_only")) {
            return EnumSet.of(DocDestination.INSTALL);
        }
        return EnumSet.noneOf(DocDestination.class);
    }

    String getShortName() {
        return this.shortName;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getHelpLoc() {
        return this.helpLoc;
    }

    boolean includeProduct(DocDestination docDestination) {
        return this.destinations.contains((Object)docDestination);
    }
}

