/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.archive.MissingEntryException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;

class InstallableComponentImpl
implements InstallableComponent {
    private final ComponentData compData;
    private final String xml;
    private final String fileName;
    private final String type;
    private final long uncompressedBytes;
    private final long size;
    private final ComponentSourceProvider componentSourceProvider;
    private final String[] componentSourceIds;
    private boolean downloaded;
    private boolean installed;

    InstallableComponentImpl(ComponentData componentData, String string, String string2, String string3, long l, long l2, ComponentSourceProvider componentSourceProvider, String ... stringArray) {
        this.compData = componentData;
        this.xml = string;
        this.fileName = string2;
        this.type = string3;
        this.uncompressedBytes = l;
        this.size = l2;
        this.componentSourceProvider = componentSourceProvider;
        this.componentSourceIds = (String[])stringArray.clone();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getUncompressedBytes() {
        return this.uncompressedBytes;
    }

    @Override
    public ComponentData getComponentData() {
        return this.compData;
    }

    @Override
    public void download(File file, InstallFlowControlHandler installFlowControlHandler, IOObserver iOObserver, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!this.downloaded) {
            try {
                this.componentSourceProvider.download(file, this.fileName, this.getComponentData(), this.size, this.xml, iOObserver);
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.confirm();
                }
                this.downloaded = true;
            }
            catch (IOException iOException) {
                if (installFlowControlHandler.shouldRetry(InstallResourceKeys.EXTRACT_TITLE.getString(new Object[0]), InstallResourceKeys.DOWNLOAD_RETRY_MESSAGE.getString(this.fileName, iOException.getMessage()), iOException)) {
                    for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                        installStatusObserver.reset();
                    }
                    this.download(file, installFlowControlHandler, iOObserver, installStatusObserverArray);
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!this.installed) {
            try {
                this.componentSourceProvider.open();
                ComponentSource componentSource = null;
                for (String string : this.componentSourceIds) {
                    try {
                        componentSource = this.componentSourceProvider.getComponentSource(file, string);
                        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                            installStatusObserver.addComponent(this.getComponentData().getName());
                        }
                        componentSource.extract(file, installFlowControlHandler, installStatusObserverArray);
                        this.installed = true;
                        break;
                    }
                    catch (MissingEntryException missingEntryException) {
                    }
                }
                if (componentSource == null) {
                    throw new MissingEntryException(this.fileName);
                }
            }
            finally {
                this.componentSourceProvider.close();
            }
        }
    }

    @Override
    public long getRemainingDownloadSize() {
        return this.downloaded ? 0L : this.getDownloadSize();
    }

    @Override
    public long getDownloadSize() {
        return this.componentSourceProvider.getDownloadSize(this.size);
    }

    @Override
    public String getXML() {
        return this.xml;
    }
}

