/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.tabordereditor;

import com.jgoodies.forms.factories.Borders;
import com.mathworks.common.icons.ControlIcon;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.ObjectRegistryEvent;
import com.mathworks.services.ObjectRegistryListener;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.action.AbstractLayoutAction;
import com.mathworks.toolbox.matlab.guide.icons.MoveIcon;
import com.mathworks.toolbox.matlab.guide.palette.GObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.utils.BottomBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TabOrderEditor
extends MJPanel {
    private static String COMMAND_UP = "COMMAND_UP";
    private static String COMMAND_DOWN = "COMMAND_DOWN";
    private LayoutArea fLayoutArea;
    private ObjectRegistry fRegistry;
    private RegistryHandler fRegHandler;
    private Object fFigureHandle;
    private Object fCurrentParent;
    private MJList fListBox;
    private ListHandler fListHandler;
    private boolean amSendingEvent;
    private TabOrderAction upAction;
    private TabOrderAction downAction;
    private Vector fChildVector;
    private Vector fUiobjectVector;
    private Vector fTabableItems = new Vector();

    public TabOrderEditor(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        this.fFigureHandle = this.fLayoutArea.getRootObject();
        if (this.fFigureHandle != null) {
            this.doActualCreation();
        }
    }

    public void doActualCreation() {
        this.setLayout(new BorderLayout());
        this.buildList();
        this.buildToolbar();
        this.addListeners();
        this.updateChildList();
    }

    public void closeWindow() {
        this.removeListeners();
    }

    private void buildToolbar() {
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.setBorder((Border)new BottomBorder());
        this.upAction = new TabOrderAction(ResourceManager.getString("string.Up"), MoveIcon.MOVE_UP.getIcon(), COMMAND_UP);
        this.downAction = new TabOrderAction(ResourceManager.getString("string.Down"), MoveIcon.MOVE_DOWN.getIcon(), COMMAND_DOWN);
        mJToolBar.add((Action)((Object)this.upAction));
        mJToolBar.add((Action)((Object)this.downAction));
        this.add((Component)mJToolBar, "North");
    }

    private void addListeners() {
        this.fRegistry = ObjectRegistry.getLayoutRegistry();
        this.fRegHandler = new RegistryHandler(this);
        this.fRegistry.addObjectRegistryListener((ObjectRegistryListener)this.fRegHandler);
        this.fRegistry.addItemListener((ItemListener)this.fRegHandler);
    }

    void removeListeners() {
        this.fRegistry.removeObjectRegistryListener((ObjectRegistryListener)this.fRegHandler);
        this.fRegistry.removeItemListener((ItemListener)this.fRegHandler);
    }

    private void buildList() {
        this.fListBox = new MJList();
        this.fListBox.setSelectionMode(0);
        this.fListBox.setCellRenderer((ListCellRenderer)new TabOrderListCellRenderer());
        this.fListHandler = new ListHandler(this);
        this.fListBox.addListSelectionListener((ListSelectionListener)this.fListHandler);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fListBox);
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)mJScrollPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMoveEvent(ActionEvent actionEvent) {
        block5: {
            Vector vector;
            Vector vector2;
            Vector vector3;
            int n;
            String string;
            block6: {
                int n2;
                string = ((TabOrderAction)((Object)((MJButton)actionEvent.getSource()).getAction())).getName();
                n = this.fListBox.getSelectedIndex();
                Vector vector4 = this.fTabableItems;
                synchronized (vector4) {
                    vector3 = (Vector)this.fTabableItems.clone();
                    vector2 = (Vector)this.fChildVector.clone();
                    vector = (Vector)this.fUiobjectVector.clone();
                }
                if (n < 0) break block5;
                int n3 = vector2.indexOf(vector3.elementAt(n));
                if (!COMMAND_UP.equals(string) || n <= 0) break block6;
                for (int i = n2 = vector2.indexOf(vector3.elementAt(n - 1)); i < n3; ++i) {
                    if (vector.indexOf(vector2.elementAt(i)) < 0) continue;
                    this.fLayoutArea.moveBackward();
                }
                break block5;
            }
            if (!COMMAND_DOWN.equals(string) || n + 1 >= vector3.size()) break block5;
            int n4 = vector2.indexOf(vector3.elementAt(n + 1));
            for (int i = n3; i < n4; ++i) {
                if (vector.indexOf(vector2.elementAt(i)) < 0) continue;
                this.fLayoutArea.moveForward();
            }
        }
    }

    void updateChildList() {
        UpdateListWorker updateListWorker = new UpdateListWorker();
        updateListWorker.start();
    }

    private Object getTargetParent() {
        Object object = this.fCurrentParent;
        Object[] objectArray = this.fRegistry.getSelectedObjects();
        if (objectArray != null && objectArray.length > 0) {
            if (objectArray[0] == this.fFigureHandle) {
                object = this.fFigureHandle;
            } else {
                Object object2 = this.fRegistry.getParent(objectArray[0]);
                while (this.fRegistry.getParent(object2) != null) {
                    object2 = this.fRegistry.getParent(object2);
                }
                if (object2 == this.fFigureHandle) {
                    object = objectArray.length == 1 && this.fRegistry.isParental(objectArray[0]) ? objectArray[0] : this.fRegistry.getParent(objectArray[0]);
                }
            }
        }
        return object;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.setSize(400, 300);
        return dimension;
    }

    private Icon getIcon(Object object) {
        Icon icon = ControlIcon.UNKNOWN.getIcon();
        if (object instanceof UDDObject) {
            UDDObject uDDObject = (UDDObject)object;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(uDDObject.getClass());
                String string = beanInfo.getBeanDescriptor().getDisplayName();
                icon = HGControl.getDisplayIconForControl(string, uDDObject);
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
        return icon;
    }

    private String getLabel(Object object) {
        String string = "";
        Object var6_3 = null;
        UDDObject uDDObject = (UDDObject)object;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(uDDObject.getClass());
            string = beanInfo.getBeanDescriptor().getDisplayName();
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        return HGControl.getDisplayTextForControl(string, uDDObject);
    }

    private boolean isUiobject(Object object) {
        boolean bl;
        UDDObject uDDObject = (UDDObject)object;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(uDDObject.getClass());
            String string = beanInfo.getBeanDescriptor().getDisplayName();
            bl = string.equals(HGControl.UICONTROL.getClassName()) || string.equals(HGControl.TABLE.getClassName()) || string.equals(HGControl.PANEL.getClassName()) || string.equals(HGControl.CONTAINER.getClassName()) || string.equals(HGControl.BUTTONGROUP.getClassName());
        }
        catch (IntrospectionException introspectionException) {
            bl = false;
        }
        return bl;
    }

    private boolean isTabAble(Object object) {
        boolean bl = false;
        LOControlWrapper lOControlWrapper = this.fLayoutArea.findWrapper(object);
        if (lOControlWrapper != null && lOControlWrapper instanceof GObjectWrapper) {
            GObjectProxy gObjectProxy = (GObjectProxy)lOControlWrapper.getControl();
            bl = gObjectProxy.isTabable();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateToolbar() {
        int n = this.fListBox.getSelectedIndex();
        if (n < 0) {
            this.downAction.setEnabled(false);
            this.upAction.setEnabled(false);
        } else {
            Vector vector = this.fTabableItems;
            synchronized (vector) {
                if (n == this.fTabableItems.size() - 1) {
                    this.downAction.setEnabled(false);
                } else {
                    this.downAction.setEnabled(true);
                }
            }
            if (n == 0) {
                this.upAction.setEnabled(false);
            } else {
                this.upAction.setEnabled(true);
            }
        }
    }

    class TabOrderObject {
        private String label;
        private Icon icon;

        public TabOrderObject(String string, Icon icon) {
            this.label = string;
            this.icon = icon;
        }

        public String getLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    class TabOrderAction
    extends AbstractLayoutAction {
        public TabOrderAction(String string, Icon icon, String string2) {
            super(string);
            this.setButtonOnlyIcon(icon);
            this.setName(string2);
            this.setEnabled(false);
        }

        @Override
        protected void performAction(ActionEvent actionEvent) {
            TabOrderEditor.this.processMoveEvent(actionEvent);
        }
    }

    class TabOrderListCellRenderer
    extends MJLabel
    implements ListCellRenderer {
        public TabOrderListCellRenderer() {
            this.setBorder(Borders.createEmptyBorder((String)"1dlu, 2dlu, 1dlu, 2dlu"));
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TabOrderObject tabOrderObject = (TabOrderObject)object;
            this.setIcon(tabOrderObject.getIcon());
            this.setText(tabOrderObject.getLabel());
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
            return this;
        }
    }

    private class RegistryHandler
    implements ObjectRegistryListener,
    ItemListener {
        TabOrderEditor fLocalTabEditor;

        RegistryHandler(TabOrderEditor tabOrderEditor2) {
            this.fLocalTabEditor = tabOrderEditor2;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (EventQueue.isDispatchThread()) {
                this.processStateChange();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RegistryHandler.this.processStateChange();
                    }
                });
            }
        }

        private void processStateChange() {
            if (!TabOrderEditor.this.amSendingEvent) {
                TabOrderEditor.this.fListBox.clearSelection();
            }
            if (TabOrderEditor.this.getTargetParent() != TabOrderEditor.this.fCurrentParent) {
                this.fLocalTabEditor.updateChildList();
            } else {
                TabOrderEditor.this.updateToolbar();
            }
        }

        public void objectChanged(ObjectRegistryEvent objectRegistryEvent) {
            this.fLocalTabEditor.updateChildList();
        }

        public void objectMoved(ObjectRegistryEvent objectRegistryEvent) {
            this.fLocalTabEditor.updateChildList();
        }

        public void objectRegistered(ObjectRegistryEvent objectRegistryEvent) {
            this.fLocalTabEditor.updateChildList();
        }

        public void objectUnregistered(ObjectRegistryEvent objectRegistryEvent) {
            this.fLocalTabEditor.updateChildList();
        }

        public void transactionEnded(ObjectRegistryEvent objectRegistryEvent) {
        }

        public void transactionStarted(ObjectRegistryEvent objectRegistryEvent) {
        }
    }

    private class ListHandler
    implements ListSelectionListener {
        TabOrderEditor fLocalTabEditor;
        Object[] objects;

        ListHandler(TabOrderEditor tabOrderEditor2) {
            this.fLocalTabEditor = tabOrderEditor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getObjects(int[] nArray) {
            this.objects = new Object[nArray.length];
            Vector vector = TabOrderEditor.this.fTabableItems;
            synchronized (vector) {
                for (int i = 0; i < nArray.length; ++i) {
                    this.objects[i] = TabOrderEditor.this.fTabableItems.elementAt(nArray[i]);
                }
            }
            TabOrderEditor.this.amSendingEvent = true;
            this.fLocalTabEditor.fRegistry.setSelected(this.objects, true, true);
            TabOrderEditor.this.amSendingEvent = false;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int[] nArray = TabOrderEditor.this.fListBox.getSelectedIndices();
            if (nArray.length > 0 && nArray[0] >= 0) {
                this.getObjects(nArray);
            }
            TabOrderEditor.this.updateToolbar();
        }
    }

    private class UpdateListWorker
    extends MatlabWorker {
        Vector<Icon> icons = new Vector();
        Vector<String> labels = new Vector();

        private UpdateListWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            Vector vector = TabOrderEditor.this.fTabableItems;
            synchronized (vector) {
                if (TabOrderEditor.this.fRegistry != null) {
                    TabOrderEditor.this.fTabableItems.removeAllElements();
                    this.icons.clear();
                    this.labels.clear();
                    TabOrderEditor.this.fCurrentParent = TabOrderEditor.this.getTargetParent();
                    if (TabOrderEditor.this.fCurrentParent != null) {
                        TabOrderEditor.this.fChildVector = TabOrderEditor.this.fRegistry.getChildren(TabOrderEditor.this.fCurrentParent);
                        if (TabOrderEditor.this.fUiobjectVector == null) {
                            TabOrderEditor.this.fUiobjectVector = new Vector();
                        } else {
                            TabOrderEditor.this.fUiobjectVector.removeAllElements();
                        }
                        int n = TabOrderEditor.this.fChildVector.size();
                        for (int i = 0; i < n; ++i) {
                            Object e = TabOrderEditor.this.fChildVector.elementAt(i);
                            if (!TabOrderEditor.this.isUiobject(e)) continue;
                            TabOrderEditor.this.fUiobjectVector.addElement(e);
                            if (!TabOrderEditor.this.isTabAble(e)) continue;
                            TabOrderEditor.this.fTabableItems.addElement(e);
                            this.icons.addElement(TabOrderEditor.this.getIcon(e));
                            this.labels.addElement(TabOrderEditor.this.getLabel(e));
                        }
                        object = TabOrderEditor.this.fTabableItems.clone();
                    }
                }
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            if (object != null && TabOrderEditor.this.fRegistry != null) {
                Vector vector = (Vector)object;
                Object[] objectArray = TabOrderEditor.this.fRegistry.getSelectedObjects();
                int n = -1;
                Object[] objectArray2 = new TabOrderObject[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    objectArray2[i] = new TabOrderObject(this.labels.get(i), this.icons.get(i));
                    if (objectArray == null || objectArray.length != 1 || objectArray[0] == null || !objectArray[0].equals(vector.elementAt(i))) continue;
                    n = i;
                }
                TabOrderEditor.this.fListBox.setListData(objectArray2);
                if (n >= 0 && n < TabOrderEditor.this.fListBox.getModel().getSize()) {
                    TabOrderEditor.this.fListBox.removeListSelectionListener((ListSelectionListener)TabOrderEditor.this.fListHandler);
                    TabOrderEditor.this.fListBox.setSelectedIndex(n);
                    TabOrderEditor.this.fListBox.ensureIndexIsVisible(n);
                    TabOrderEditor.this.fListBox.addListSelectionListener((ListSelectionListener)TabOrderEditor.this.fListHandler);
                }
                TabOrderEditor.this.updateToolbar();
            }
        }
    }
}

