/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.layouttool;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolInfo;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolRegistry;
import com.mathworks.util.FileUtils;
import java.io.FileNotFoundException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

class LayoutToolParser {
    public static final String TOOL_TAG = "Tool";
    public static final String NAME_TAG = "Name";
    public static final String PATH_TAG = "Path";
    public static final String ICON_TAG = "Icon";
    public static final String COMMAND_TAG = "Command";
    public static final String TOOLBARENTRY_TAG = "ToolbarEntry";
    public static final String SINGLETON_TAG = "Singleton";
    private static DocumentBuilder sDocBuilder;
    private Document fToolDoc;

    LayoutToolParser() {
    }

    public void parseToolInfo(String string) {
        Object object;
        try {
            if (sDocBuilder == null) {
                object = DocumentBuilderFactory.newInstance();
                sDocBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            this.fToolDoc = sDocBuilder.parse(string);
        }
        catch (SAXParseException sAXParseException) {
            System.err.println("Parsing failed. \n" + sAXParseException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Parsing Failed. \n" + fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("File " + string + " could not be parsed successfully.");
            exception.printStackTrace();
        }
        if (null != this.fToolDoc) {
            try {
                object = XMLMessageSystem.getBundle((String)"MATLAB:guide:toolinfo");
                Element element = this.fToolDoc.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName(TOOL_TAG);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element2 = (Element)nodeList.item(i);
                    String string2 = element2.getAttribute(NAME_TAG);
                    string2 = ((ResourceBundle)object).getString(string2);
                    String string3 = element2.getAttribute(PATH_TAG);
                    String string4 = element2.getAttribute(COMMAND_TAG);
                    String string5 = element2.getAttribute(ICON_TAG);
                    boolean bl = Boolean.parseBoolean(element2.getAttribute(TOOLBARENTRY_TAG));
                    boolean bl2 = Boolean.parseBoolean(element2.getAttribute(SINGLETON_TAG));
                    LayoutToolRegistry.addTool(new LayoutTool(string2, string3, string5, string4, bl, bl2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("File " + string + " could not be parsed successfully.");
            }
        }
    }

    class LayoutTool
    implements LayoutToolInfo {
        private String fName = null;
        private String fLocation = null;
        private Icon fIcon = null;
        private String fCommand = null;
        private boolean fToolbarEntry = true;
        private boolean fSingleton = false;
        private boolean fIsRunning = false;

        public LayoutTool(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
            this.fName = string;
            this.fLocation = FileUtils.fromJavaPath((String)(Matlab.matlabRoot() + string2));
            this.fCommand = string4;
            this.fToolbarEntry = bl;
            this.fSingleton = bl2;
            if (FileUtils.fileExists((String)(this.fLocation + string3))) {
                this.fIcon = new ImageIcon(this.fLocation + string3);
            }
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getCommand() {
            return this.fCommand;
        }

        @Override
        public Icon getIcon() {
            return this.fIcon;
        }

        @Override
        public boolean isToolbarEntry() {
            return this.fToolbarEntry;
        }

        @Override
        public boolean isSingleton() {
            return this.fSingleton;
        }

        @Override
        public String getPath() {
            return this.fLocation;
        }

        @Override
        public boolean isRunning() {
            return this.fIsRunning;
        }

        @Override
        public void setRunning(boolean bl) {
            this.fIsRunning = bl;
        }
    }
}

