/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.AddDrag;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragListener;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.dragdrop.LayoutDragSupport;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.ToolPaletteButton;
import com.mathworks.toolbox.matlab.guide.palette.ToolRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AddDragListener
extends LayoutDragSupport
implements DragListener {
    private Object fBean;
    private ToolPaletteButton fPaletteButton;
    private boolean fDragging;
    private boolean fTracking;
    private boolean fContainerDrawn;
    private boolean fCanBeEnclosed;
    private Window fWindow;
    private Point fOffset;
    private Point fPinPt;
    private Point fStartPt;
    private Point fCurrentPt;
    private Dimension fSize;
    private Rectangle fLayoutBounds;
    private Point fLayoutLocation;
    private LOControlWrapper fCurrentParent;
    private static final int DRAG_THRESHOLD = 3;

    public AddDragListener(LayoutArea layoutArea) {
        super(layoutArea);
    }

    @Override
    public void startDrag(MouseEvent mouseEvent) {
        this.fDragging = false;
        this.fTracking = false;
        this.fContainerDrawn = false;
        this.fPaletteButton = (ToolPaletteButton)((Object)mouseEvent.getComponent());
        this.fWindow = SwingUtilities.getWindowAncestor((Component)((Object)this.fPaletteButton));
        Rectangle rectangle = new Rectangle(0, 0, this.fPaletteButton.getWidth(), this.fPaletteButton.getHeight());
        rectangle = SwingUtilities.convertRectangle((Component)((Object)this.fPaletteButton), rectangle, this.fWindow);
        this.fOffset = new Point(rectangle.x, rectangle.y);
        this.fPinPt = new Point(rectangle.x, rectangle.y);
        this.fStartPt = mouseEvent.getPoint();
        this.fStartPt.translate(this.fOffset.x, this.fOffset.y);
        this.fCurrentPt = this.fStartPt;
        this.fCurrentParent = null;
        this.fLayoutLocation = SwingUtilities.convertPoint(this.fLayoutArea, new Point(0, 0), this.fWindow);
        Rectangle rectangle2 = new Rectangle(0, 0, this.fLayoutArea.getParent().getWidth(), this.fLayoutArea.getParent().getHeight());
        this.fLayoutBounds = SwingUtilities.convertRectangle(this.fLayoutArea.getParent(), rectangle2, this.fWindow);
        this.resetDragTracker();
    }

    void resetDragTracker() {
        DragTracker dragTracker = this.fLayoutArea.getDragTracker();
        if (dragTracker != null && dragTracker instanceof AddDrag) {
            ((AddDrag)dragTracker).resetTracker();
        }
    }

    @Override
    public void continueDrag(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.translate(this.fOffset.x, this.fOffset.y);
        if (!this.fCurrentPt.equals(point)) {
            Serializable serializable;
            Object object;
            Object object2;
            Graphics graphics = this.getXORGraphics(this.fWindow);
            if (this.fTracking) {
                this.drawOutline(graphics);
            }
            this.fCurrentPt = point;
            if (!(this.fDragging || Math.abs(this.fCurrentPt.x - this.fStartPt.x) <= 3 && Math.abs(this.fCurrentPt.y - this.fStartPt.y) <= 3)) {
                this.fDragging = true;
                this.calcSize();
                object2 = null;
                object = this.fPaletteButton.getButtonGroup().getElements();
                while (object.hasMoreElements()) {
                    serializable = object.nextElement();
                    if (!serializable.isSelected()) continue;
                    object2 = serializable;
                    break;
                }
                if (!object2.equals(this.fPaletteButton)) {
                    this.fPaletteButton.setBusy(true);
                    this.fPaletteButton.setSelected(true);
                    this.fPaletteButton.getParent().getParent().repaint();
                    Toolkit.getDefaultToolkit().sync();
                }
            }
            if (this.fDragging && !this.fTracking) {
                boolean bl = this.fTracking = !this.fPaletteButton.isBusy();
            }
            if (this.fTracking) {
                if (this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
                    object2 = new Rectangle(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width, this.fSize.height);
                    object2 = SwingUtilities.convertRectangle(this.fWindow, (Rectangle)object2, this.fLayoutArea);
                    object = this.snapRect((Rectangle)object2);
                    if (((Point)object).x != 0 || ((Point)object).y != 0) {
                        this.fCurrentPt.translate(((Point)object).x, ((Point)object).y);
                    }
                }
                this.drawOutline(graphics);
                if (this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
                    object2 = new Point(this.fCurrentPt.x - this.fLayoutLocation.x, this.fCurrentPt.y - this.fLayoutLocation.y);
                    object = null;
                    if (this.fCanBeEnclosed) {
                        object = this.fLayoutArea.findContainer((Point)object2);
                    }
                    if (this.fContainerDrawn) {
                        if (object != this.fCurrentParent) {
                            graphics.setClip(this.fLayoutBounds);
                            graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                            this.drawContainer(graphics);
                            this.fCurrentParent = object;
                            this.drawContainer(graphics);
                        }
                    } else {
                        this.fCurrentParent = object;
                        graphics.setClip(this.fLayoutBounds);
                        graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                        this.drawContainer(graphics);
                        this.fContainerDrawn = true;
                    }
                } else if (this.fContainerDrawn) {
                    this.fContainerDrawn = false;
                    graphics.setClip(this.fLayoutBounds);
                    graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                    this.drawContainer(graphics);
                    this.fCurrentParent = null;
                }
            }
            if (this.fLayoutArea.getLayoutStatusBar() != null) {
                int n = this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x);
                int n2 = this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y);
                serializable = new Point(n -= this.fLayoutLocation.x, n2 -= this.fLayoutLocation.y);
                this.fLayoutArea.getLayoutStatusBar().setCurrentPoint(new Point(mouseEvent.getPoint().x + this.fPinPt.x - this.fLayoutLocation.x, mouseEvent.getPoint().y + this.fPinPt.y - this.fLayoutLocation.y));
                if (this.fSize != null) {
                    this.fLayoutArea.getLayoutStatusBar().setPosition(this.fCurrentParent, new Point(((Point)serializable).x, ((Point)serializable).y + this.fSize.height), new Point(((Point)serializable).x + this.fSize.width, ((Point)serializable).y), false);
                } else {
                    this.fLayoutArea.getLayoutStatusBar().setPosition(null, (Point)serializable, (Point)serializable, false);
                }
            }
            graphics.dispose();
        }
    }

    @Override
    public void finishDrag(MouseEvent mouseEvent) {
        if (this.fTracking) {
            Graphics graphics = this.getXORGraphics(this.fWindow);
            this.drawOutline(graphics);
            if (this.fContainerDrawn) {
                graphics.setClip(this.fLayoutBounds);
                graphics.translate(this.fLayoutLocation.x, this.fLayoutLocation.y);
                this.drawContainer(graphics);
            }
            graphics.dispose();
        }
        this.fCurrentPt = mouseEvent.getPoint();
        this.fCurrentPt.translate(this.fOffset.x, this.fOffset.y);
        this.checkDrop();
        this.fBean = null;
    }

    private void drawOutline(Graphics graphics) {
        graphics.drawRect(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width - 1, this.fSize.height - 1);
    }

    private void drawContainer(Graphics graphics) {
        if (this.fCurrentParent != null) {
            Point point = this.fCurrentParent.getBaseLocation();
            Dimension dimension = this.fCurrentParent.getControl().getSize();
            graphics.drawRect(point.x - 1, point.y - 1, dimension.width + 1, dimension.height + 1);
            graphics.drawRect(point.x - 2, point.y - 2, dimension.width + 3, dimension.height + 3);
        } else {
            this.drawDropOutline(graphics);
        }
    }

    private void calcSize() {
        int n = this.fPaletteButton.getID();
        Dimension dimension = this.fPaletteButton.getSize();
        this.fBean = ToolRegistry.buildObject(n);
        if (this.fBean != null && this.fBean instanceof Component) {
            this.fSize = ((Component)this.fBean).getPreferredSize();
            if (this.fSize.width < dimension.width) {
                this.fPinPt.x += (dimension.width - this.fSize.width) / 2;
            }
            if (this.fPinPt.x > this.fStartPt.x) {
                this.fPinPt.x = this.fStartPt.x;
            } else if (this.fPinPt.x + this.fSize.width - 1 < this.fStartPt.x) {
                this.fPinPt.x = this.fStartPt.x - this.fSize.width + 1;
            }
            if (this.fSize.height < dimension.height) {
                this.fPinPt.y += (dimension.height - this.fSize.height) / 2;
            }
            if (this.fPinPt.y > this.fStartPt.y) {
                this.fPinPt.y = this.fStartPt.y;
            } else if (this.fPinPt.y + this.fSize.height - 1 < this.fStartPt.y) {
                this.fPinPt.y = this.fStartPt.y - this.fSize.height + 1;
            }
        } else {
            this.fSize = dimension;
        }
        this.fCanBeEnclosed = n < 23 || n > 63 && n < 4096 || this.isLightweight(this.fBean) || this.fBean instanceof MObjectProxy && ((MObjectProxy)this.fBean).isEnclosable();
    }

    private boolean isLightweight(Object object) {
        boolean bl = false;
        if (Beans.isInstanceOf(object, JComponent.class)) {
            bl = true;
        } else if (Beans.isInstanceOf(object, Component.class)) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                Boolean bl2 = (Boolean)beanInfo.getBeanDescriptor().getValue("lightweight");
                if (bl2 != null) {
                    bl = bl2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private void checkDrop() {
        if (this.fDragging && this.fLayoutBounds.contains(this.fCurrentPt.x, this.fCurrentPt.y)) {
            Rectangle rectangle = new Rectangle(this.fPinPt.x + (this.fCurrentPt.x - this.fStartPt.x), this.fPinPt.y + (this.fCurrentPt.y - this.fStartPt.y), this.fSize.width, this.fSize.height);
            rectangle = SwingUtilities.convertRectangle(this.fWindow, rectangle, this.fLayoutArea);
            this.snapRect(rectangle);
            this.fLayoutArea.addObject(ToolRegistry.getType(this.fPaletteButton.getID()), this.fBean, rectangle, this.fCurrentParent);
            this.fLayoutArea.getPalette().resetToSelectTool();
        }
    }

    private Point snapRect(Rectangle rectangle) {
        int n = 0;
        if (rectangle.x < 0) {
            n = -rectangle.x;
        }
        int n2 = 0;
        if (rectangle.y < 0) {
            n2 = -rectangle.y;
        }
        Dimension dimension = this.fLayoutArea.getSize();
        if (rectangle.x + rectangle.width > dimension.width) {
            n = dimension.width - (rectangle.x + rectangle.width);
        }
        if (rectangle.y + rectangle.height > dimension.height) {
            n2 = dimension.height - (rectangle.y + rectangle.height);
        }
        if (n != 0 || n2 != 0) {
            rectangle.translate(n, n2);
        }
        Point point = this.getSnapRect(rectangle);
        if (point.x != 0 || point.y != 0) {
            n += point.x;
            n2 += point.y;
        }
        return new Point(n, n2);
    }
}

