/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ArchiveInputStreamProvider;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import java.io.File;
import java.io.IOException;

final class DWSInstallationInputFile
implements InstallationInputFile {
    private final File file;
    private final ArchiveFactory archiveFactory;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceProvider componentSourceProvider;
    private final ContentOptimizer contentOptimizer;

    DWSInstallationInputFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceProvider componentSourceProvider, ContentOptimizer contentOptimizer) {
        this.file = file;
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceProvider = componentSourceProvider;
        this.contentOptimizer = contentOptimizer;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void parse() throws IOException, XMLParseException {
        Archive archive = this.archiveFactory.createArchive(this.getFile());
        for (String string : archive.getEntries()) {
            if (!this.contentOptimizer.accept(string)) continue;
            this.xmlInstallationFileParser.readInDefinition(new ArchiveInputStreamProvider(archive, string), this.componentSourceProvider);
        }
    }
}

