/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.install.CommandContainer;
import com.mathworks.install.CommandContainerImpl;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentContainerImpl;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.ComponentInstallerImpl;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.ContentOptimizerImpl;
import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.DefaultDirectoryProviderNonWindows;
import com.mathworks.install.DefaultDirectoryProviderWindows;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationAdapter;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallConfigurationPersistenceImpl;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallOptionProviderLinux;
import com.mathworks.install.InstallOptionProviderMac;
import com.mathworks.install.InstallOptionProviderWindows;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.InstalledProductDataFactoryImpl;
import com.mathworks.install.InstalledProductDataImpl;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.InstalledProductDataVersionImpl;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerBuilderImpl;
import com.mathworks.install.InstallerFactory;
import com.mathworks.install.InstallerFactoryImpl;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.PreProductInstaller;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductContainerImpl;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.ProductInstallerImpl;
import com.mathworks.install.XMLInstallationFileParserImpl;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install.XMLParserFactoryImpl;
import com.mathworks.install.archive.zip.commonscompress.CommonsCompressModule;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.command.CommandModule;
import com.mathworks.install.input.InputModule;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install.service.ServiceModule;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.status.LoggingInstallStatusObserver;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Properties;

public final class InstallModule
extends AbstractModule {
    public static final String LOGGING_STATUS_OBSERVER = "loggingStatusObserver";
    public static final String UNINSTALL_STATUS_FACTOR = "uninstallStatusFactor";
    private static final String PRE_INSTALLER = "PreInstaller";
    private static final String POST_INSTALLER = "PostInstaller";
    private final Module archiveModule;
    private final InstallConfiguration installConfiguration;

    public InstallModule() {
        this(new InstallConfigurationAdapter());
    }

    public InstallModule(InstallConfiguration installConfiguration) {
        this(installConfiguration, (Module)new CommonsCompressModule());
    }

    public InstallModule(Module module) {
        this(new InstallConfigurationAdapter(), module);
    }

    private InstallModule(InstallConfiguration installConfiguration, Module module) {
        this.installConfiguration = installConfiguration;
        this.archiveModule = module;
    }

    protected void configure() {
        this.bind(Platform.class).toInstance((Object)new PlatformImpl());
        this.bind(ProductContainer.class).to(ProductContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(ComponentContainer.class).to(ComponentContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(FilePermissions.class).to(FilePermissionsUtil.class);
        this.bind(ComponentInstaller.class).to(ComponentInstallerImpl.class);
        this.bind(XMLParserFactory.class).to(XMLParserFactoryImpl.class).in(Scopes.SINGLETON);
        this.bind(InstallStatusObserver.class).annotatedWith((Annotation)Names.named((String)LOGGING_STATUS_OBSERVER)).to(LoggingInstallStatusObserver.class);
        this.bind(ProductInstaller.class).to(ProductInstallerImpl.class);
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)UNINSTALL_STATUS_FACTOR)).toInstance((Object)10000L);
        this.bind(InstallConfiguration.class).toInstance((Object)this.installConfiguration);
        this.bind(InstallConfigurationPersistence.class).to(InstallConfigurationPersistenceImpl.class);
        this.bind(InstalledProductDataVersion.class).to(InstalledProductDataVersionImpl.class);
        this.bind(XMLInstallationFileParser.class).to(XMLInstallationFileParserImpl.class);
        this.bind(ContentOptimizer.class).to(ContentOptimizerImpl.class);
        this.install(this.archiveModule);
        this.install((Module)new CommandModule());
        this.install((Module)new ServiceModule());
        this.install((Module)new InputModule());
    }

    @Provides
    static InstalledProductDataFactory provideInstalledProductDataFactory(XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstallConfiguration installConfiguration, IO iO) {
        return new InstalledProductDataFactoryImpl(xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installConfiguration, iO);
    }

    @Singleton
    @Provides
    static InstalledProductData provideInstalledProductData(ProductContainer productContainer, ComponentContainer componentContainer, XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstalledProductDataVersion installedProductDataVersion, IO iO) {
        return new InstalledProductDataImpl(productContainer, componentContainer, xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installedProductDataVersion, iO);
    }

    @Provides
    static InstallOptionProvider provideInstallOptionProvider(Platform platform) {
        if (platform.isWindows()) {
            return new InstallOptionProviderWindows();
        }
        if (platform.isMac()) {
            return new InstallOptionProviderMac();
        }
        return new InstallOptionProviderLinux();
    }

    @Provides
    static DefaultDirectoryProvider provideDefaultDirectoryProvider(Platform platform, Registry registry, InstallConfiguration installConfiguration) {
        if (platform.isWindows()) {
            return new DefaultDirectoryProviderWindows(registry, installConfiguration, platform);
        }
        return new DefaultDirectoryProviderNonWindows(installConfiguration, platform);
    }

    @Provides
    static InstallerBuilder provideInstallerBuilder(Platform platform, ProductContainer productContainer, InstallerFactory installerFactory, InstalledProductData installedProductData, ExecutorServiceManager executorServiceManager, InstallConfiguration installConfiguration, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger) {
        return new InstallerBuilderImpl(platform.getArchString(), productContainer, installerFactory, installedProductData, executorServiceManager, installationInputFileFactory, appLogger, installConfiguration);
    }

    @Provides
    static InstallerFactory provideInstallerFactory(InstallOptionProvider installOptionProvider, @Named(value="PreInstaller") ProductInstaller productInstaller, ProductInstaller productInstaller2, InstalledProductData installedProductData, @Named(value="PostInstaller") ProductInstaller productInstaller3, InstalledProductDataFactory installedProductDataFactory, ProductContainer productContainer, IO iO, AppLogger appLogger) {
        return new InstallerFactoryImpl(installOptionProvider, installedProductData, installedProductDataFactory, productContainer, iO, appLogger, productInstaller, productInstaller2, productInstaller3);
    }

    @Provides
    @Named(value="PreInstaller")
    static ProductInstaller providePreInstaller(CommandContainer commandContainer) {
        return new PreProductInstaller(commandContainer);
    }

    @Provides
    @Named(value="PostInstaller")
    static ProductInstaller providePostInstaller(final CommandContainer commandContainer) {
        return new ProductInstaller(){

            @Override
            public void installProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
                for (InstallStatusObserver object : installStatusObserverArray) {
                    object.postInstall();
                }
                for (Command command : commandContainer.getPostInstallCommands(installOptionArray, installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        command.execute(string, file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception(iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            private void update(InstallStatusObserver[] installStatusObserverArray) {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.updateUnits(0x100000L);
                }
            }

            @Override
            public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                return (long)commandContainer.getPostInstallCommands(installOptionArray, installableProductArray).length * 0x100000L;
            }

            @Override
            public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
                for (Command command : commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        command.undo(string, file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception(iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            @Override
            public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                return (long)commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray).length * 0x100000L;
            }

            @Override
            public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
            }
        };
    }

    @Provides
    static IO provideIO(FilePermissions filePermissions, SecurityOverride securityOverride) throws JNIException {
        return new FileIO(filePermissions, securityOverride);
    }

    @Provides
    static CommandContainer provideCommandContainer(Platform platform, Properties properties, CommandFactory commandFactory, ServiceFactory serviceFactory, InstallConfiguration installConfiguration, InstallConfigurationPersistence installConfigurationPersistence, IO iO, InstallerRequirements installerRequirements) {
        String string = platform.getArchString();
        String string2 = properties.getProperty("root");
        return new CommandContainerImpl(string2, commandFactory, serviceFactory, installConfiguration, iO, installConfigurationPersistence, installerRequirements, properties, platform);
    }
}

