/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.widgets;

import com.mathworks.ide.widgets.Highlighter;
import com.mathworks.ide.widgets.HighlighterFactory;
import com.mathworks.ide.widgets.Indenter;
import com.mathworks.ide.widgets.IndenterFactory;
import com.mathworks.ide.widgets.MHighlighter;
import com.mathworks.ide.widgets.MHighlighterFactory;
import com.mathworks.ide.widgets.MIndenter;
import com.mathworks.ide.widgets.MIndenterFactory;
import com.mathworks.ide.widgets.SimpleIndenter;
import com.mathworks.ide.widgets.SimpleIndenterFactory;
import com.mathworks.mwt.MWTextArea;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextListener;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Range;
import com.mathworks.util.Timer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public class SyntaxTextArea
extends MWTextArea {
    public static final String M_FILE_TYPE = "M-code";
    public static final String TEXT_FILE_TYPE = "Text";
    public static final String INDENTERTYPE_NONE = "NoIndent";
    public static final String INDENTERTYPE_BLOCK = "BlockIndent";
    public static final String INDENTERTYPE_SMART = "SmartIndent";
    public static final int BALANCE_PARENS = 1;
    public static final int UNDERSCORE_PARENS = 2;
    public static final int UNDERSCORE_STRINGS = 4;
    public static final int SKIP_KEYTYPED_IN_COMMENTS = 256;
    public static final int SKIP_KEYTYPED_IN_STRINGS = 512;
    public static final int SKIP_ARROWKEY_IN_COMMENTS = 1024;
    public static final int SKIP_ARROWKEY_IN_STRINGS = 2048;
    public static final int UNDERSCORE_ON_KEYTYPED_MATCH = 4096;
    public static final int HIGHLIGHT_ON_KEYTYPED_MATCH = 8192;
    public static final int BOLD_ON_KEYTYPED_MATCH = 12288;
    public static final int KEYTYPED_MATCH_MASK = 12288;
    public static final int STRIKETHRU_ON_KEYTYPED_ERROR = 16384;
    public static final int IGNORE_KEYTYPED_ERROR = 32768;
    public static final int GRAY_ON_KEYTYPED_ERROR = 49152;
    public static final int KEYTYPED_ERROR_MASK = 49152;
    public static final int BALANCE_ON_ARROWKEY_MATCH = 65536;
    public static final int HIGHLIGHT_ON_ARROWKEY_MATCH = 131072;
    public static final int BOLD_ON_ARROWKEY_MATCH = 196608;
    public static final int ARROWKEY_MATCH_MASK = 196608;
    public static final int BEEP_ON_ARROWKEY_ERROR = 262144;
    public static final int IGNORE_ARROWKEY_ERROR = 524288;
    public static final int GRAY_ON_ARROWKEY_ERROR = 786432;
    public static final int ARROWKEY_ERROR_MASK = 786432;
    private static final int HIGHLIGHT_MASK = 3072;
    private static final int BALANCE_STYLE = 0;
    private static final int BEEP_STYLE = 0;
    private static final int IGNORE_STYLE = -1;
    private static final int HIGHLIGHT_STYLE = 3072;
    private static final int GRAY_STYLE = 2048;
    private static final int BALANCE_DELAY = 300;
    private static final int ARROW_DELAY = 1000;
    private static TimerGuy sTimer;
    private String fFileType;
    private Highlighter fHighlighter;
    private boolean fSyntaxHighlightingEnabled = false;
    private boolean fSyntaxHighlightingOn = false;
    private boolean fIsConsole = false;
    private Indenter fIndenter;
    private String fIndenterType;
    private int fSpacesPerIndent = 4;
    private int fSpacesPerTab = 4;
    private int fTabSpaces = 4;
    private boolean fTabUsingSpaces = false;
    private boolean fEmacsStyleTab = false;
    private KissyKeyListener fKeyFilter;
    private int fDelimiterOptions;
    private int fBalanceDelay = 300;
    private int fArrowDelay = 1000;
    private static Hashtable fHighlighters;
    private static Hashtable fIndenters;

    public SyntaxTextArea() {
        this(false);
    }

    public SyntaxTextArea(boolean bl) {
        this.fIsConsole = bl;
        this.setCRMode(bl);
        this.getView().overrideCommand(31, (ActionListener)new InsertCharAndIndent());
        this.getView().overrideCommand(30, (ActionListener)new InsertLineBreakAndIndent());
        this.getView().overrideCommand(2, (ActionListener)new CharLeftDeleteAndIndent());
        this.getView().overrideCommand(5, (ActionListener)new CharRightDeleteAndIndent());
        if (!PlatformInfo.isMacintosh()) {
            this.getView().setBlackHighlight(true);
        }
        this.getView().setColorMode(1);
        this.setFont(new Font("Monospaced", 0, 12));
        this.setFileType(TEXT_FILE_TYPE);
        this.setSyntaxHighlightingEnabled(true);
        this.setIndenterType(INDENTERTYPE_BLOCK);
        this.getModel().addTextListener((MWTextListener)new TextEventHandler());
        this.getView().addMouseListener((MouseListener)new BalanceClickListener());
        this.fKeyFilter = new KissyKeyListener();
        this.getView().addKeyFilter((KeyListener)this.fKeyFilter);
        this.fDelimiterOptions = 16391;
        ArrowKeyOverride arrowKeyOverride = new ArrowKeyOverride();
        this.getView().overrideCommand(0, (ActionListener)arrowKeyOverride);
        this.getView().overrideCommand(3, (ActionListener)arrowKeyOverride);
        this.getView().overrideCommand(13, (ActionListener)arrowKeyOverride);
        this.getView().overrideCommand(15, (ActionListener)arrowKeyOverride);
    }

    public String getFileType() {
        return this.fFileType;
    }

    public void setFileType(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals(this.fFileType)) {
            return;
        }
        this.fFileType = string;
        this.fHighlighter = SyntaxTextArea.createHighlighter(string);
        this.updateSyntaxHighlightingOn();
        if (this.fHighlighter instanceof MHighlighter) {
            ((MHighlighter)this.fHighlighter).setCRIsWhiteSpace(this.fIsConsole);
        }
        if (this.fFileType.equals(M_FILE_TYPE)) {
            this.setIndenterType(INDENTERTYPE_SMART);
        } else {
            this.setIndenterType(INDENTERTYPE_BLOCK);
        }
    }

    public int getDelimiterMatchingOptions() {
        return this.fDelimiterOptions;
    }

    public void setDelimiterMatchingOptions(int n) {
        this.fDelimiterOptions = n;
    }

    public void setParenMatchingDelays(int n, int n2) {
        if (n < 0) {
            n = this.fBalanceDelay;
        }
        if (n2 < 0) {
            n2 = this.fArrowDelay;
        }
        this.fBalanceDelay = n;
        this.fArrowDelay = n2;
    }

    public void setAutoIndentEnabled(boolean bl) {
    }

    public void setSmartIndentEnabled(boolean bl) {
    }

    public String getIndenterType() {
        return this.fIndenterType;
    }

    public void setIndenterType(String string) {
        if (string == null) {
            string = INDENTERTYPE_BLOCK;
        }
        if (string.equals(INDENTERTYPE_NONE)) {
            this.fIndenter = null;
        } else if (!string.equals(this.fIndenterType)) {
            if (fIndenters.get(string) == null) {
                string = INDENTERTYPE_BLOCK;
            }
            this.fIndenter = SyntaxTextArea.createIndenter(string);
            this.fIndenter.setModel(this.getModel());
            if (this.fIndenter instanceof MIndenter) {
                ((MIndenter)this.fIndenter).setCRIsWhiteSpace(this.fIsConsole);
            }
        }
        this.fIndenterType = string;
    }

    public void setSpacesPerIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fSpacesPerIndent = n;
    }

    public int getSpacesPerIndent() {
        return this.fSpacesPerIndent;
    }

    public void setSpacesPerTab(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fSpacesPerTab = n;
        this.getModel().setSpacesPerTab(n);
        if (!this.fTabUsingSpaces) {
            this.fTabSpaces = n;
        }
    }

    public int getSpacesPerTab() {
        return this.fSpacesPerTab;
    }

    public void setEmacsStyleTabEnabled(boolean bl) {
        this.fEmacsStyleTab = bl;
    }

    public boolean isEmacsStyleTabEnabled() {
        return this.fEmacsStyleTab;
    }

    public void setTabUsingSpaces(boolean bl) {
        this.fTabUsingSpaces = bl;
        this.fTabSpaces = bl ? 0 : this.fSpacesPerTab;
    }

    public boolean isTabUsingSpaces() {
        return this.fTabUsingSpaces;
    }

    public void setSyntaxHighlightingEnabled(boolean bl) {
        this.fSyntaxHighlightingEnabled = bl;
        this.updateSyntaxHighlightingOn();
    }

    public boolean isSyntaxHighlightingEnabled() {
        return this.fSyntaxHighlightingEnabled;
    }

    private void updateSyntaxHighlightingOn() {
        boolean bl;
        boolean bl2 = bl = this.fSyntaxHighlightingEnabled && this.fHighlighter != null;
        if (bl != this.fSyntaxHighlightingOn) {
            if (this.fSyntaxHighlightingEnabled && this.fHighlighter != null) {
                this.doHighlighting(0, this.getModel().getNumLines() - 1);
            } else {
                this.getModel().setStyle(0, this.getModel().length(), this.getModel().getDefaultStyle());
            }
            this.fSyntaxHighlightingOn = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHighlighting(int n, int n2) {
        MWTextModel mWTextModel = this.getModel();
        mWTextModel.deferStyleChangeNotification();
        try {
            this.fHighlighter.highlight(mWTextModel, n, n2);
        }
        finally {
            mWTextModel.resumeStyleChangeNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHighlightRange(int n, int n2) {
        MWTextModel mWTextModel = this.getModel();
        mWTextModel.deferStyleChangeNotification();
        try {
            this.fHighlighter.highlightRange(mWTextModel, n, n2);
        }
        finally {
            mWTextModel.resumeStyleChangeNotification();
        }
    }

    public static String[] getHighlightCategories(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new String[0];
        }
        return highlighter.getCategories();
    }

    public static MWStyle[] getHighlightStyles(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new MWStyle[0];
        }
        return highlighter.getStyles();
    }

    public static MWStyle[] getDefaultHighlightStyles(String string) {
        Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
        if (highlighter == null) {
            return new MWStyle[0];
        }
        return highlighter.getDefaultStyles();
    }

    public void setHighlightStyle(String string, String string2, MWStyle mWStyle) {
        if (string == this.fFileType) {
            if (this.fHighlighter != null) {
                this.fHighlighter.setStyle(string2, mWStyle);
                if (this.fSyntaxHighlightingEnabled) {
                    this.doHighlighting(0, this.getModel().getNumLines() - 1);
                }
            }
        } else {
            Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
            if (highlighter != null) {
                highlighter.setStyle(string2, mWStyle);
            }
        }
    }

    public void setHighlightStyles(String string, MWStyle[] mWStyleArray) {
        if (string == this.fFileType) {
            if (this.fHighlighter != null) {
                this.fHighlighter.setStyles(mWStyleArray);
                if (this.fSyntaxHighlightingEnabled) {
                    this.doHighlighting(0, this.getModel().getNumLines() - 1);
                }
            }
        } else {
            Highlighter highlighter = SyntaxTextArea.createHighlighter(string);
            if (highlighter != null) {
                highlighter.setStyles(mWStyleArray);
            }
        }
    }

    public void setTextStyle(MWStyle mWStyle) {
        if (this.fHighlighter != null) {
            this.fHighlighter.setTextStyle(mWStyle);
        }
        if (mWStyle.isAutoColor()) {
            this.getView().setColorMode(0);
        } else {
            this.setTextColor(mWStyle.getColor());
        }
    }

    public void setBackgroundStyle(MWStyle mWStyle) {
        if (mWStyle.isAutoColor()) {
            this.setBackground(Decorations.getColor((int)0));
        } else {
            this.setBackground(mWStyle.getColor());
        }
    }

    public void setTextColor(Color color) {
        this.setForeground(color);
        this.getView().setColorMode(2);
    }

    public MWStyle[] swapHighlighterStyles(MWStyle[] mWStyleArray) {
        MWStyle[] mWStyleArray2 = this.fHighlighter != null ? this.fHighlighter.swapHighlightStyles(mWStyleArray) : null;
        return mWStyleArray2;
    }

    public MWStyle swapTextStyle(MWStyle mWStyle) {
        MWStyle mWStyle2;
        if (this.fHighlighter != null) {
            mWStyle2 = this.fHighlighter.swapTextStyle(mWStyle);
            if (mWStyle != null) {
                if (mWStyle.isAutoColor()) {
                    if (!mWStyle2.isAutoColor()) {
                        this.getView().setColorMode(0);
                    }
                } else if (mWStyle2.isAutoColor()) {
                    this.setTextColor(mWStyle.getColor());
                }
            }
        } else {
            mWStyle2 = null;
        }
        return mWStyle2;
    }

    public void setKeyBindingScheme(int n) {
        this.getView().setKeyBindingScheme(n);
    }

    public int getKeyBindingScheme() {
        return this.getView().getKeyBindingScheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indentSel() {
        MWTextModel mWTextModel = this.getModel();
        MWTextView mWTextView = this.getView();
        Range range = (Range)mWTextView.getSel().clone();
        int n = mWTextView.getTopLine();
        int n2 = mWTextView.getHScrollAmount();
        int n3 = this.getModel().lineFromPos(range.getStart());
        int n4 = this.getModel().lineFromPos(range.getEnd());
        if (range.getStart() != range.getEnd() && range.getEnd() == mWTextModel.getLineStart(n4)) {
            n4 = Math.max(n4 - 1, 0);
            range.setEnd(mWTextModel.getLineEndNoEOL(n4));
            mWTextView.setSel(range);
        }
        mWTextModel.startCommand("Indent");
        try {
            this.indentLines(n3, n4, range);
            mWTextView.setSel(range);
            mWTextView.setTopLine(n);
            mWTextView.setHScrollAmount(n2);
        }
        finally {
            mWTextModel.endCommand();
        }
    }

    public void indentLines(int n, int n2) {
        this.indentLines(n, n2, null);
    }

    public void indentLines(int n, int n2, Range range) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (this.fIndenter != null) {
            this.fIndenter.indent(n3, n4, this.fSpacesPerIndent, this.fTabSpaces, range);
        }
    }

    private void doTabProcessing(char c) {
        if (this.fEmacsStyleTab) {
            boolean bl = false;
            if (this.fIndenter == null) {
                bl = true;
                this.setIndenterType(INDENTERTYPE_SMART);
            }
            this.indentSel();
            if (bl) {
                this.setIndenterType(INDENTERTYPE_NONE);
            }
        } else if (this.fTabUsingSpaces) {
            if (this.fSpacesPerTab > 0) {
                int n = this.getView().getSel().getMin();
                int n2 = this.getModel().lineFromPos(n);
                int n3 = this.getModel().getLineStart(n2);
                int n4 = this.getModel().expandedWidthInChars(n3, n, 0);
                int n5 = this.fSpacesPerTab - n4 % this.fSpacesPerTab;
                for (int i = 0; i < n5; ++i) {
                    this.getView().insertChar(' ');
                }
            }
        } else {
            this.getView().insertChar(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertCharAndIndent(char c) {
        if (c == '\t') {
            this.doTabProcessing(c);
            return;
        } else if (this.fIndenter != null) {
            this.getModel().startCommand("Typing");
            try {
                int n = this.getView().getSel().getMin();
                int n2 = this.getModel().lineFromPos(n);
                int n3 = this.fIndenter.contributionToCurr(n2);
                this.getView().insertChar(c);
                int n4 = this.fIndenter.contributionToCurr(n2);
                if (n3 == n4) return;
                Range range = (Range)this.getView().getSel().clone();
                this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                this.getView().setSel(range);
                return;
            }
            finally {
                this.getModel().endCommand();
            }
        } else {
            this.getView().insertChar(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void charLeftDeleteAndIndent() {
        if (this.getView().getSel().isEmpty() && this.fIndenter != null) {
            this.getModel().startCommand("Typing");
            try {
                int n = this.getView().getSel().getMin();
                int n2 = this.getModel().lineFromPos(n);
                if (n2 > 0 && this.getModel().colFromPos(n) == 0) {
                    --n2;
                }
                int n3 = this.fIndenter.contributionToCurr(n2);
                this.getView().charLeftDelete();
                int n4 = this.getModel().lineFromPos(this.getView().getSel().getMin());
                int n5 = this.fIndenter.contributionToCurr(n4);
                if (n3 == n5) return;
                Range range = (Range)this.getView().getSel().clone();
                this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                this.getView().setSel(range);
                return;
            }
            finally {
                this.getModel().endCommand();
            }
        } else {
            this.getView().charLeftDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void charRightDeleteAndIndent() {
        if (this.getView().getSel().isEmpty() && this.fIndenter != null) {
            this.getModel().startCommand("Delete");
            try {
                int n = this.getView().getSel().getMin();
                int n2 = this.getModel().lineFromPos(n);
                int n3 = this.fIndenter.contributionToCurr(n2);
                this.getView().charRightDelete();
                int n4 = this.getModel().lineFromPos(this.getView().getSel().getMin());
                int n5 = this.fIndenter.contributionToCurr(n4);
                if (n3 == n5) return;
                Range range = (Range)this.getView().getSel().clone();
                this.fIndenter.indent(n2, n2, this.fSpacesPerIndent, this.fTabSpaces, range);
                this.getView().setSel(range);
                return;
            }
            finally {
                this.getModel().endCommand();
            }
        } else {
            this.getView().charRightDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLineBreakAndIndent() {
        if (this.fIndenter == null) {
            this.getView().insertLineBreak();
            return;
        }
        int n = this.getView().getSel().getMin();
        int n2 = this.getModel().lineFromPos(n);
        int n3 = this.fIndenter.contributionToCurr(n2);
        this.getView().insertLineBreak();
        this.getModel().startCommand("Typing");
        try {
            int n4 = this.fIndenter.contributionToCurr(n2);
            int n5 = n3 == n4 ? n2 + 1 : n2;
            Range range = (Range)this.getView().getSel().clone();
            this.fIndenter.indent(n5, n2 + 1, this.fSpacesPerIndent, this.fTabSpaces, range);
            this.getView().setSel(range);
        }
        finally {
            this.getModel().endCommand();
        }
    }

    private static Highlighter createHighlighter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        HighlighterFactory highlighterFactory = (HighlighterFactory)fHighlighters.get(string);
        if (highlighterFactory == null) {
            return null;
        }
        return highlighterFactory.create();
    }

    private static void registerHighlighter(String string, HighlighterFactory highlighterFactory) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        fHighlighters.put(string, highlighterFactory);
    }

    private static Indenter createIndenter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        IndenterFactory indenterFactory = (IndenterFactory)fIndenters.get(string);
        if (indenterFactory == null) {
            return new SimpleIndenter();
        }
        return indenterFactory.create();
    }

    private static void registerIndenter(String string, IndenterFactory indenterFactory) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        fIndenters.put(string, indenterFactory);
    }

    public void cancelBalance() {
        this.fKeyFilter.actionPerformed(null);
    }

    public void doBalance() {
        this.doBalance(this.getView().getSelMin());
    }

    public void doBalance(int n) {
        int n2;
        MWTextView mWTextView = this.getView();
        MWTextModel mWTextModel = this.getModel();
        int n3 = this.getMaxBalancePos(n);
        int n4 = this.getMinBalancePos(n);
        char c = ' ';
        char c2 = ' ';
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n2 = n; n2 < n3; ++n2) {
            c = mWTextModel.charAt(n2);
            if (c == ')') {
                --n7;
            } else if (c == ']') {
                --n6;
            } else if (c == '}') {
                --n5;
            } else if (c == '(') {
                ++n7;
            } else if (c == '[') {
                ++n6;
            } else if (c == '{') {
                ++n5;
            }
            if (n7 < 0) {
                c2 = '(';
                break;
            }
            if (n6 < 0) {
                c2 = '[';
                break;
            }
            if (n5 >= 0) continue;
            c2 = '{';
            break;
        }
        if (n2 < n3) {
            int n8 = n2;
            int n9 = 1;
            for (n2 = n8 - 1; n2 >= n4; --n2) {
                if (mWTextModel.charAt(n2) == c) {
                    ++n9;
                } else if (mWTextModel.charAt(n2) == c2) {
                    --n9;
                }
                if (n9 != 0) continue;
                mWTextView.setSel(n2 + 1, n8);
                break;
            }
            if (n2 < 0) {
                mWTextView.beep();
            }
        } else {
            mWTextView.beep();
        }
    }

    public int getMaxBalancePos(int n) {
        MWTextModel mWTextModel = this.getModel();
        int n2 = mWTextModel.lineFromPos(n);
        int n3 = mWTextModel.lineFromPos(mWTextModel.length());
        n3 = Math.min(n3, this.getView().getBottomCompleteLine());
        n3 = Math.min(n3, n2 + 50);
        int n4 = mWTextModel.getLineEndNoEOL(n3);
        return n4;
    }

    public int getMinBalancePos(int n) {
        MWTextModel mWTextModel = this.getModel();
        int n2 = mWTextModel.lineFromPos(n);
        int n3 = Math.max(0, n2 - 50);
        n3 = Math.min(n3, this.getView().getTopLine());
        int n4 = mWTextModel.getLineStart(n3);
        return n4;
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    static {
        fHighlighters = new Hashtable();
        fIndenters = new Hashtable();
        SyntaxTextArea.registerHighlighter(M_FILE_TYPE, new MHighlighterFactory());
        SyntaxTextArea.registerIndenter(INDENTERTYPE_SMART, new MIndenterFactory());
        SyntaxTextArea.registerIndenter(INDENTERTYPE_BLOCK, new SimpleIndenterFactory());
    }

    private static class Test
    extends Frame {
        private Panel fPanel = new TestPanel();
        private Component fComponent;

        public Test() {
            super("SyntaxText Example");
            this.fPanel.setLayout(new BorderLayout());
            this.add((Component)this.fPanel, "Center");
            SyntaxTextArea syntaxTextArea = new SyntaxTextArea();
            syntaxTextArea.setFileType(SyntaxTextArea.M_FILE_TYPE);
            syntaxTextArea.setGutterWidth(10);
            this.fComponent = syntaxTextArea;
            this.fPanel.add(this.fComponent, "Center");
            this.addWindowListener(new TestWindowEventHandler());
            this.setSize(500, 500);
            this.setVisible(true);
        }

        class TestPanel
        extends Panel {
            TestPanel() {
                this.setBackground(Decorations.getColor((int)0));
            }

            @Override
            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        }

        class TestWindowEventHandler
        extends WindowAdapter {
            TestWindowEventHandler() {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Test.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                Test.this.fPanel.requestFocus();
                Test.this.fComponent.requestFocus();
            }
        }
    }

    private class KissyKeyListener
    extends KeyAdapter
    implements ActionListener {
        private Range fOldSelection = new Range(-1, -1);
        private Range fOldStyleRange1 = new Range(-1, -1);
        private Range fOldStyleRange2 = new Range(-1, -1);
        private int fOldHScrollAmount = -1;
        private Color fOldStyleBkColor1;
        private Color fOldStyleFgColor1;
        private Color fOldStyleBkColor2;
        private Color fOldStyleFgColor2;
        private int fHighlightStyle;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.actionPerformed(null);
        }

        void handleArrowKeys(KeyEvent keyEvent) {
            MWTextView mWTextView = SyntaxTextArea.this.getView();
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            int n = keyEvent.getKeyCode();
            int n2 = SyntaxTextArea.this.getKeyMap().getCommand(keyEvent.getModifiers(), keyEvent.getKeyCode());
            if (n2 == 0) {
                mWTextView.charLeft();
            } else if (n2 == 3) {
                mWTextView.charRight();
            } else if (n2 == 13) {
                mWTextView.lineUp();
            } else if (n2 == 15) {
                mWTextView.lineDown();
            }
            if (n == 37 || n == 39 || n == 38 || n == 40) {
                int n3 = mWTextView.getSelStart();
                if (n3 <= 0) {
                    return;
                }
                if (n == 37) {
                    ++n3;
                }
                this.balanceChar(mWTextModel.charAt(n3 - 1), n, true);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            this.balanceChar(c, 0, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KissyKeyListener kissyKeyListener = this;
            synchronized (kissyKeyListener) {
                if (this.fOldSelection.getStart() != -1) {
                    if (this.fOldHScrollAmount != -1) {
                        SyntaxTextArea.this.getView().setHScrollAmount(this.fOldHScrollAmount);
                    }
                    SyntaxTextArea.this.getView().setSel(this.fOldSelection);
                    this.fOldSelection.setStart(-1);
                    this.fOldHScrollAmount = -1;
                    SyntaxTextArea.this.getView().setSelectionNotification(true);
                }
                if (this.fOldStyleRange1.getStart() != -1) {
                    this.doDelimiterHilite(this.fOldStyleRange1.getStart(), this.fOldStyleRange2.getStart(), ~this.fHighlightStyle);
                    this.fOldStyleRange1.setStart(-1);
                    this.fOldStyleRange2.setStart(-1);
                    this.fOldStyleBkColor1 = null;
                    this.fOldStyleFgColor1 = null;
                    this.fOldStyleBkColor2 = null;
                    this.fOldStyleFgColor2 = null;
                }
            }
        }

        private void balanceChar(char c, int n, boolean bl) {
            if (!bl && (SyntaxTextArea.this.fDelimiterOptions & 1) == 0) {
                return;
            }
            if (bl && (c == '\'' && (SyntaxTextArea.this.fDelimiterOptions & 4) == 0 || (SyntaxTextArea.this.fDelimiterOptions & 2) == 0)) {
                return;
            }
            if (c == ')') {
                this.kissStartToken('(', ')', n, bl);
            } else if (c == ']') {
                this.kissStartToken('[', ']', n, bl);
            } else if (c == '}') {
                this.kissStartToken('{', '}', n, bl);
            } else if (c == '(') {
                this.kissCloseToken('(', ')', n, bl);
            } else if (c == '[') {
                this.kissCloseToken('[', ']', n, bl);
            } else if (c == '{') {
                this.kissCloseToken('{', '}', n, bl);
            } else {
                this.fOldHScrollAmount = -1;
                this.fOldSelection.setStart(-1);
                this.fOldStyleRange1.setStart(-1);
                this.fOldStyleRange2.setStart(-1);
            }
        }

        private boolean tokenInComment(int n) {
            boolean bl = false;
            if (SyntaxTextArea.this.fSyntaxHighlightingOn) {
                n = n > 0 ? n - 1 : n;
                MWStyle mWStyle = SyntaxTextArea.this.getModel().getStyleAt(n);
                bl = mWStyle == SyntaxTextArea.this.fHighlighter.getStyle(2);
            } else if (SyntaxTextArea.this.fFileType.equals(SyntaxTextArea.M_FILE_TYPE)) {
                MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
                int n2 = mWTextModel.lineFromPos(n);
                int n3 = mWTextModel.getLineStart(n2);
                int n4 = mWTextModel.getLineEndNoEOL(n2);
                for (int i = n3; i < n4; ++i) {
                    if (mWTextModel.charAt(i) != '%') continue;
                    bl = i < n;
                    break;
                }
            }
            return bl;
        }

        private boolean tokenInString(int n) {
            boolean bl = false;
            if (SyntaxTextArea.this.fSyntaxHighlightingOn) {
                MWStyle mWStyle;
                if (n == SyntaxTextArea.this.getModel().length() && n > 0) {
                    --n;
                }
                bl = (mWStyle = SyntaxTextArea.this.getModel().getStyleAt(n)) == SyntaxTextArea.this.fHighlighter.getStyle(3) || mWStyle == SyntaxTextArea.this.fHighlighter.getStyle(4);
            } else if (SyntaxTextArea.this.fFileType.equals(SyntaxTextArea.M_FILE_TYPE)) {
                bl = false;
            }
            return bl;
        }

        private boolean tokenInCommentString(int n) {
            int n2;
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            int n3 = mWTextModel.lineFromPos(n);
            n3 = n2 = mWTextModel.getLineStart(n3);
            n2 = 0;
            while (n3 < n) {
                if (mWTextModel.charAt(n3) == '\'') {
                    n2 = n2 == 0 ? n3 : 0;
                }
                ++n3;
            }
            return n2 != 0;
        }

        private int findCommentLimit(int n, boolean bl) {
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            int n2 = mWTextModel.lineFromPos(n);
            int n3 = mWTextModel.getLineEndNoEOL(n2);
            if (bl) {
                int n4;
                for (int i = n4 = mWTextModel.getLineStart(n2); i < n3; ++i) {
                    if (mWTextModel.charAt(i) != '%') continue;
                    n4 = 0;
                    for (int j = i; j < n; ++j) {
                        if (mWTextModel.charAt(j) != '\'') continue;
                        n4 = n4 == 0 ? j : 0;
                    }
                    n = n4 > 0 ? n4 : i;
                    ++n;
                    break;
                }
            } else if (n < SyntaxTextArea.this.getModel().length()) {
                int n5 = 0;
                for (int i = n3 - 1; i > n; --i) {
                    if (mWTextModel.charAt(i) == '\'') {
                        n5 = n5 == 0 ? i : 0;
                        continue;
                    }
                    if (mWTextModel.charAt(i) == '%') break;
                }
                n = n5 > 0 ? n5 : n3;
            }
            return n;
        }

        private int findStringLimit(int n, boolean bl) {
            if (SyntaxTextArea.this.fSyntaxHighlightingOn && n < SyntaxTextArea.this.getModel().length()) {
                Range range = SyntaxTextArea.this.getModel().getStyleRangeAt(n, null);
                n = bl ? range.getStart() + 1 : range.getEnd() - 1;
            }
            return n;
        }

        private void kissStartToken(char c, char c2, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            MWTextView mWTextView = SyntaxTextArea.this.getView();
            Range range = mWTextView.getSel();
            int n6 = range.getMin();
            if (n == 37) {
                ++n6;
            }
            if (this.tokenInString(n6)) {
                if (!bl && (SyntaxTextArea.this.fDelimiterOptions & 0x200) != 0 || bl && (SyntaxTextArea.this.fDelimiterOptions & 0x800) != 0) {
                    return;
                }
                n5 = 1;
                n4 = n6 == SyntaxTextArea.this.getModel().length() && n6 > 0 ? n6 - 1 : n6;
                n3 = this.findStringLimit(n4, true);
            } else if (this.tokenInComment(n6)) {
                if (!bl && (SyntaxTextArea.this.fDelimiterOptions & 0x100) != 0 || bl && (SyntaxTextArea.this.fDelimiterOptions & 0x400) != 0) {
                    return;
                }
                n5 = this.tokenInCommentString(n6) ? 1 : 2;
                n3 = this.findCommentLimit(n6, true);
            } else {
                n3 = SyntaxTextArea.this.getMinBalancePos(n6);
                n5 = 0;
            }
            int n7 = 1;
            for (n4 = n6 - 2; n4 >= 0; --n4) {
                if (mWTextModel.charAt(n4) == c2 && (!this.tokenInComment(n4) && !this.tokenInString(n4) || n5 == 1 || n5 == 2 && !this.tokenInCommentString(n4))) {
                    ++n7;
                }
                if (mWTextModel.charAt(n4) == c && (!this.tokenInComment(n4) && !this.tokenInString(n4) || n5 == 1 || n5 == 2 && !this.tokenInCommentString(n4))) {
                    --n7;
                }
                if (n7 == 0) {
                    int n8 = n2 = bl ? this.arrowKeyMatchStyle() : this.keyTypeMatchStyle();
                    if (n2 != 0 && (mWTextModel.lineFromPos(n4) < mWTextView.getTopLine() || mWTextModel.lineFromPos(n4) > mWTextView.getBottomCompleteLine())) break;
                    if (n2 != 0) {
                        this.doDelimiterHilite(n4, n6 - 1, n2);
                    } else {
                        this.fOldHScrollAmount = mWTextView.getHScrollAmount();
                        mWTextView.setSelectionNotification(false);
                        mWTextView.setSel(n4, n4 + 1);
                    }
                    this.startTimer(n2 != 0);
                    if (n2 != 0) {
                        this.fOldStyleRange1.setValues(n4, n4 + 1);
                        this.fOldStyleRange2.setValues(n6 - 1, n6);
                        break;
                    }
                    this.fOldSelection.setValues(n6, n6);
                    break;
                }
                if (n4 >= n3) continue;
                n4 = 0;
            }
            if (n4 < 0) {
                int n9 = n2 = bl ? this.arrowKeyErrorStyle() : this.keyTypeErrorStyle();
                if (n2 == 0) {
                    mWTextView.beep();
                } else if (n2 != -1) {
                    this.fOldStyleRange1.setValues(n6 - 1, n6);
                    this.doDelimiterHilite(n6 - 1, -1, n2);
                    this.startTimer(true);
                }
            }
        }

        private void kissCloseToken(char c, char c2, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            MWTextView mWTextView = SyntaxTextArea.this.getView();
            Range range = mWTextView.getSel();
            int n7 = range.getMin();
            if (n == 37) {
                ++n7;
            }
            int n8 = n6 = n7 > 0 ? n7 - 1 : n7;
            if (this.tokenInString(n6)) {
                if (!bl && (SyntaxTextArea.this.fDelimiterOptions & 0x200) != 0 || bl && (SyntaxTextArea.this.fDelimiterOptions & 0x800) != 0) {
                    return;
                }
                n5 = 1;
                n4 = this.findStringLimit(n7, false);
            } else if (this.tokenInComment(n7)) {
                if (!bl && (SyntaxTextArea.this.fDelimiterOptions & 0x100) != 0 || bl && (SyntaxTextArea.this.fDelimiterOptions & 0x400) != 0) {
                    return;
                }
                n5 = this.tokenInCommentString(n6) ? 1 : 2;
                n4 = this.findCommentLimit(n6, false);
            } else {
                n4 = SyntaxTextArea.this.getMaxBalancePos(n7);
                n5 = 0;
            }
            int n9 = mWTextModel.length() - 1;
            n6 = 1;
            for (n3 = n7; n3 <= n9; ++n3) {
                if (mWTextModel.charAt(n3) == c && (!this.tokenInComment(n3) && !this.tokenInString(n3) || n5 == 1 || n5 == 2 && !this.tokenInCommentString(n3))) {
                    ++n6;
                } else if (mWTextModel.charAt(n3) == c2 && (!this.tokenInComment(n3) && !this.tokenInString(n3) || n5 == 1 || n5 == 2 && !this.tokenInCommentString(n3))) {
                    --n6;
                }
                if (n6 == 0) {
                    int n10 = n2 = bl ? this.arrowKeyMatchStyle() : this.keyTypeMatchStyle();
                    if (n2 != 0 && (mWTextModel.lineFromPos(n3) < mWTextView.getTopLine() || mWTextModel.lineFromPos(n3) > mWTextView.getBottomCompleteLine())) break;
                    if (n2 != 0) {
                        this.doDelimiterHilite(n3, n7 - 1, n2);
                    } else {
                        this.fOldHScrollAmount = mWTextView.getHScrollAmount();
                        mWTextView.setSelectionNotification(false);
                        mWTextView.setSel(n3, n3 + 1);
                    }
                    this.startTimer(n2 != 0);
                    if (n2 != 0) {
                        this.fOldStyleRange1.setValues(n3, n3 + 1);
                        this.fOldStyleRange2.setValues(n7 - 1, n7);
                        break;
                    }
                    this.fOldSelection.setValues(n7, n7);
                    break;
                }
                if (n3 != n4) continue;
                n3 = n9;
            }
            if (n3 > n9 && bl) {
                n2 = this.arrowKeyErrorStyle();
                if (n2 == 0) {
                    mWTextView.beep();
                } else if (n2 != -1) {
                    this.fOldStyleRange1.setValues(n7 - 1, n7);
                    this.doDelimiterHilite(n7 - 1, -1, n2);
                    this.startTimer(true);
                }
            }
        }

        private void startTimer(boolean bl) {
            int n;
            int n2 = n = bl ? SyntaxTextArea.this.fArrowDelay : SyntaxTextArea.this.fBalanceDelay;
            if (sTimer == null) {
                sTimer = new TimerGuy();
            }
            sTimer.setTimerGuyDelay(n);
            sTimer.setActionListener(this);
            sTimer.start();
        }

        private void doDelimiterHilite(int n, int n2, int n3) {
            MWStyle mWStyle;
            int n4;
            MWStyle mWStyle2;
            MWTextModel mWTextModel = SyntaxTextArea.this.getModel();
            if (n >= 0) {
                mWStyle2 = mWTextModel.getStyleAt(n);
                n4 = mWStyle2.getStyle();
                if (n3 < 0) {
                    mWStyle = (n3 & 0x800) == 0 ? new MWStyle(this.fOldStyleFgColor1, this.fOldStyleBkColor1, n4 &= 0xFFFFFF7F) : new MWStyle(mWStyle2.getForeground(), mWStyle2.getBackground(), n4 &= n3);
                } else {
                    this.fHighlightStyle = n3;
                    if ((n3 & 0xC00) != 0) {
                        this.fOldStyleFgColor1 = mWStyle2.getForeground();
                        this.fOldStyleBkColor1 = mWStyle2.getBackground();
                        mWStyle = n3 == 3072 ? new MWStyle(Decorations.getColor((int)5, (boolean)true, null), Decorations.getColor((int)4, (boolean)true, null), n4) : new MWStyle(Decorations.getColor((int)15), mWStyle2.getBackground(), n4 | 0x80);
                    } else {
                        mWStyle = new MWStyle(mWStyle2.getForeground(), mWStyle2.getBackground(), n4 |= n3);
                    }
                }
                mWTextModel.setStyle(n, n + 1, mWStyle);
            }
            if (n2 >= 0) {
                mWStyle2 = mWTextModel.getStyleAt(n2);
                n4 = mWStyle2.getStyle();
                if (n3 < 0) {
                    mWStyle = (n3 & 0x800) == 0 ? new MWStyle(this.fOldStyleFgColor2, this.fOldStyleBkColor2, n4 &= 0xFFFFFF7F) : new MWStyle(mWStyle2.getForeground(), mWStyle2.getBackground(), n4 &= n3);
                } else {
                    this.fHighlightStyle = n3;
                    if ((n3 & 0xC00) != 0) {
                        this.fOldStyleFgColor2 = mWStyle2.getForeground();
                        this.fOldStyleBkColor2 = mWStyle2.getBackground();
                        mWStyle = n3 == 3072 ? new MWStyle(Decorations.getColor((int)5, (boolean)true, null), Decorations.getColor((int)4, (boolean)true, null), n4) : new MWStyle(Decorations.getColor((int)15), mWStyle2.getBackground(), n4 | 0x80);
                    } else {
                        mWStyle = new MWStyle(mWStyle2.getForeground(), mWStyle2.getBackground(), n4 |= n3);
                    }
                }
                mWTextModel.setStyle(n2, n2 + 1, mWStyle);
            }
        }

        private int keyTypeErrorStyle() {
            int n = SyntaxTextArea.this.fDelimiterOptions & 0xC000;
            int n2 = n == 0 ? 0 : (n == 16384 ? 4 : (n == 49152 ? 2048 : -1));
            return n2;
        }

        private int keyTypeMatchStyle() {
            int n = SyntaxTextArea.this.fDelimiterOptions & 0x3000;
            int n2 = n == 0 ? 0 : (n == 4096 ? 8 : (n == 8192 ? 3072 : (n == 12288 ? 128 : 0)));
            return n2;
        }

        private int arrowKeyErrorStyle() {
            int n = SyntaxTextArea.this.fDelimiterOptions & 0xC0000;
            int n2 = n == 0 ? 4 : (n == 786432 ? 2048 : (n == 262144 ? 0 : -1));
            return n2;
        }

        private int arrowKeyMatchStyle() {
            int n = SyntaxTextArea.this.fDelimiterOptions & 0x30000;
            int n2 = n == 0 ? 8 : (n == 65536 ? 0 : (n == 131072 ? 3072 : (n == 196608 ? 128 : 8)));
            return n2;
        }
    }

    class ArrowKeyOverride
    implements ActionListener {
        ArrowKeyOverride() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeyEvent keyEvent = (KeyEvent)actionEvent.getSource();
            if (!keyEvent.isConsumed()) {
                SyntaxTextArea.this.fKeyFilter.handleArrowKeys(keyEvent);
            }
        }
    }

    private class TimerGuy
    implements ActionListener {
        private ActionListener fActionListener;
        private Timer fTimer;

        public TimerGuy() {
            this.fTimer = new Timer(SyntaxTextArea.this.fBalanceDelay, (ActionListener)this, 2, "SyntaxTextArea token kissing");
        }

        public void start() {
            this.fTimer.start();
        }

        void setTimerGuyDelay(int n) {
            this.fTimer.setDelay(n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fActionListener != null) {
                this.fActionListener.actionPerformed(actionEvent);
            }
        }

        public void setActionListener(ActionListener actionListener) {
            this.fActionListener = actionListener;
        }
    }

    private class BalanceClickListener
    extends MouseAdapter {
        private BalanceClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            SyntaxTextArea.this.fKeyFilter.actionPerformed(null);
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && (n = SyntaxTextArea.this.getView().posFromPixel(mouseEvent.getPoint())) > -1) {
                switch (SyntaxTextArea.this.getModel().charAt(n)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++n;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        SyntaxTextArea.this.getView().setSel(n, n);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 2 && (n = SyntaxTextArea.this.getView().posFromPixel(mouseEvent.getPoint())) > -1) {
                switch (SyntaxTextArea.this.getModel().charAt(n)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++n;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        SyntaxTextArea.this.doBalance(n);
                    }
                }
            }
        }
    }

    class TextEventHandler
    extends MWTextAdapter {
        TextEventHandler() {
        }

        public void textInserted(MWTextEvent mWTextEvent) {
            if (SyntaxTextArea.this.fSyntaxHighlightingEnabled && SyntaxTextArea.this.fHighlighter != null) {
                SyntaxTextArea.this.doHighlighting(mWTextEvent.getMinLine(), mWTextEvent.getMaxLine());
            }
        }

        public void textDeleted(MWTextEvent mWTextEvent) {
            if (SyntaxTextArea.this.fSyntaxHighlightingEnabled && SyntaxTextArea.this.fHighlighter != null) {
                SyntaxTextArea.this.doHighlighting(mWTextEvent.getMinLine(), mWTextEvent.getMinLine());
            }
        }
    }

    class InsertLineBreakAndIndent
    implements ActionListener {
        InsertLineBreakAndIndent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.insertLineBreakAndIndent();
        }
    }

    class CharRightDeleteAndIndent
    implements ActionListener {
        CharRightDeleteAndIndent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.charRightDeleteAndIndent();
        }
    }

    class CharLeftDeleteAndIndent
    implements ActionListener {
        CharLeftDeleteAndIndent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.charLeftDeleteAndIndent();
        }
    }

    class InsertCharAndIndent
    implements ActionListener {
        InsertCharAndIndent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SyntaxTextArea.this.insertCharAndIndent(((KeyEvent)actionEvent.getSource()).getKeyChar());
        }
    }
}

