/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.X509Certificate;
import ice.cert.X509CertificateFactory;
import ice.debug.Debug;
import ice.ssl.ServerCertificateList;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

class CertListGenerator {
    ServerCertificateList CAList = null;
    X509CertificateFactory X509factory = new X509CertificateFactory();

    CertListGenerator() {
        this.CAList = new ServerCertificateList();
    }

    CertListGenerator(String[] args) {
        this.readCertsFiles(args);
    }

    public void readCertsFiles(String[] args) {
        this.CAList = new ServerCertificateList();
        int i = 0;
        while (i < args.length) {
            block5: {
                try {
                    FileInputStream in = new FileInputStream(args[i]);
                    X509Certificate cert = this.X509factory.generateCertificate(in);
                    if (cert != null) {
                        this.CAList.addCertificate(cert);
                    }
                    ((InputStream)in).close();
                }
                catch (Exception ex) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)ex);
                    }
                    if (!Debug.trace) break block5;
                    Debug.trace((String)("Could not read certificate file: " + args[i]));
                }
            }
            ++i;
        }
    }

    public void writeCertFiles() {
        int i = 0;
        Enumeration enumeration = this.CAList.getList();
        while (enumeration.hasMoreElements()) {
            X509Certificate cert = (X509Certificate)enumeration.nextElement();
            try {
                FileOutputStream out = new FileOutputStream("cert" + new Integer(++i).toString());
                ((OutputStream)out).write(cert.getSubjectDN().toString().getBytes());
                ((OutputStream)out).write("\n".getBytes());
                ((OutputStream)out).write(cert.getIssuerDN().toString().getBytes());
                ((OutputStream)out).write("\n".getBytes());
                cert.saveAsText(out);
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) continue;
                Debug.trace((String)"Could not write certificate file: ");
            }
        }
    }

    public void saveCerts(String certFileName) {
        block3: {
            try {
                FileOutputStream out = new FileOutputStream(certFileName);
                this.CAList.save(out);
                ((OutputStream)out).close();
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block3;
                Debug.trace((String)("Could not serialize certificates: " + ex.getMessage()));
            }
        }
    }

    public void loadCerts(String certFileName) {
        block3: {
            try {
                FileInputStream in = new FileInputStream(certFileName);
                this.CAList = ServerCertificateList.restoreList(in);
                ((InputStream)in).close();
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block3;
                Debug.trace((String)("Could not serialize certificates: " + ex.getMessage()));
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(args[0]);
        if (args[0].equals("-d")) {
            CertListGenerator C = new CertListGenerator();
            C.loadCerts("cacerts.cel");
            C.writeCertFiles();
        } else {
            CertListGenerator C = new CertListGenerator(args);
            C.saveCerts("cacerts.cel");
        }
    }
}

