/*
 * Decompiled with CFR 0.152.
 */
package ice.cert;

import ice.cert.CertificateParsingException;
import ice.cert.DERUtil;
import ice.cert.DERValue;
import ice.cert.OID;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X500Name
implements Principal,
Serializable {
    private Hashtable names = new Hashtable();
    static final long serialVersionUID = -7294414188212032516L;

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Principal)) {
            return false;
        }
        if (!(object instanceof X500Name)) {
            return this.getName().equals(((Principal)object).getName());
        }
        X500Name x500Name = (X500Name)object;
        if (x500Name.names.size() != this.names.size()) {
            return false;
        }
        Enumeration enumeration = x500Name.names.keys();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String[] stringArray = (String[])x500Name.names.get(k);
            String[] stringArray2 = (String[])this.names.get(k);
            if (stringArray == null && stringArray2 == null) continue;
            if (stringArray == null && stringArray2 != null || stringArray != null && stringArray2 == null || stringArray.length != stringArray2.length) {
                bl = false;
                break;
            }
            int n = 0;
            while (bl && n < stringArray2.length) {
                bl = stringArray[n].equals(stringArray2[n]);
                ++n;
            }
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = (String[])this.names.get(string);
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(" " + string + "=" + stringArray[n]);
                ++n;
            }
        }
        return stringBuffer.length() == 0 ? "" : stringBuffer.toString().substring(1);
    }

    public void addElement(String string, String string2) {
        String[] stringArray;
        Object v = this.names.get(string);
        String[] stringArray2 = stringArray = v == null ? null : (String[])v;
        if (stringArray == null) {
            stringArray = new String[]{string2};
        } else {
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            stringArray3[stringArray.length] = string2;
            stringArray = stringArray3;
        }
        this.names.put(string, stringArray);
    }

    public String getElement(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = (String[])this.names.get(string);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("; " + stringArray[n]);
            ++n;
        }
        return stringBuffer.length() == 0 ? "" : stringBuffer.toString().substring(2);
    }

    public String[] getElementArray(String string) {
        return (String[])this.names.get(string);
    }

    public Enumeration getAllElements() {
        return this.names.keys();
    }

    public void printContent() {
        Enumeration enumeration = this.names.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " = " + this.getElement(string));
        }
    }

    public static X500Name[] parseNames(byte[] byArray) throws CertificateParsingException {
        Object[] objectArray;
        int n = 0;
        int n2 = 0;
        Vector<X500Name> vector = new Vector<X500Name>();
        do {
            n2 = (byArray[n++] & 0xFF) << 8;
            objectArray = new byte[n2 += byArray[n++] & 0xFF];
            System.arraycopy(byArray, n, objectArray, 0, n2);
            DERValue dERValue = new DERValue();
            byte[] byArray2 = DERUtil.decode(objectArray, dERValue, 1);
            X500Name x500Name = X500Name.parseName((byte[])dERValue.getData());
            vector.addElement(x500Name);
        } while ((n += n2) < byArray.length);
        objectArray = new X500Name[vector.size()];
        int n3 = 0;
        while (n3 < objectArray.length) {
            objectArray[n3] = (byte)((X500Name)vector.elementAt(n3));
            ++n3;
        }
        return objectArray;
    }

    public static X500Name parseName(byte[] byArray) throws CertificateParsingException {
        X500Name x500Name = new X500Name();
        byte[] byArray2 = byArray;
        while (byArray2.length > 0) {
            DERValue dERValue = new DERValue();
            byArray2 = DERUtil.decode(byArray2, dERValue, 2);
            byte[] byArray3 = (byte[])dERValue.getData();
            while (byArray3.length > 0) {
                DERValue dERValue2 = new DERValue();
                byArray3 = DERUtil.decode(byArray3, dERValue2, 1);
                DERValue dERValue3 = new DERValue();
                byte[] byArray4 = DERUtil.decode((byte[])dERValue2.getData(), dERValue3, 3, (byte)2);
                String string = ((OID)dERValue3.getData()).oidName;
                DERValue dERValue4 = new DERValue();
                DERUtil.decode(byArray4, dERValue4, 6, (byte)1);
                x500Name.addElement(string, (String)dERValue4.getData());
            }
        }
        return x500Name;
    }
}

