/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.ComponentData;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.AbstractInstallationInputFile;
import com.mathworks.install.input.ArchiveInputStreamProvider;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

final class ProductArchiveFile
extends AbstractInstallationInputFile {
    private final ArchiveFactory archiveFactory;
    private Archive archive;

    ProductArchiveFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        super(file, xMLInstallationFileParser, componentSourceFactory);
        this.archiveFactory = archiveFactory;
    }

    @Override
    public void open() throws IOException {
        if (this.archive == null) {
            this.archive = this.archiveFactory.createArchive(this.getFile());
        }
    }

    @Override
    protected InputStream getInputStream(String string) throws IOException {
        return this.archive.getInputStream(string);
    }

    @Override
    public void close() {
        if (this.archive != null) {
            this.archive.closeQuietly();
        }
        this.archive = null;
    }

    @Override
    public void addComponent(String string) {
    }

    @Override
    public void download(File file, String string, ComponentData componentData, long l, String string2, IOObserver iOObserver) throws IOException, InterruptedException {
    }

    @Override
    protected InputStreamProvider getInputStreamProvider(String string) {
        return new ArchiveInputStreamProvider(this.archive, string);
    }

    @Override
    protected String getContentsEntry() {
        return "mwcontents_" + FilenameUtils.getBaseName((String)this.getFile().getName()) + ".xml";
    }
}

