/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocProductList;
import com.mathworks.install.command.doc.InstalledDocProduct;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.SharedDocUtils;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

class GenerateDocSetCommand
implements SharedDocSubCommand {
    private static final String DOCSET_FILE_NAME = "docset.xml";
    private final IO io;
    private final boolean writeEmptyFile;

    GenerateDocSetCommand(IO iO) {
        this(iO, false);
    }

    GenerateDocSetCommand(IO iO, boolean bl) {
        this.io = iO;
        this.writeEmptyFile = bl;
    }

    @Override
    public void handleProductsFound(File file, DocProductList docProductList) throws InterruptedException, IOException {
        this.handleProductsFound(file, docProductList.getInstalledProducts());
    }

    @Override
    public void handleNoProducts(File file) throws IOException, InterruptedException {
        if (this.writeEmptyFile) {
            List<InstalledDocProduct> list = Collections.emptyList();
            this.handleProductsFound(file, list);
        } else {
            this.deleteDocSetFile(file);
        }
    }

    private void handleProductsFound(File file, List<InstalledDocProduct> list) throws InterruptedException, IOException {
        String string = this.buildDocSetXmlString(list);
        this.deleteDocSetFile(file);
        File file2 = new File(file, DOCSET_FILE_NAME);
        try {
            this.io.writeStringToFile(string, file2, System.currentTimeMillis(), 420, new IOObserver[0]);
        }
        catch (IOException iOException) {
            this.deleteDocSetFile(file);
            throw iOException;
        }
    }

    private String buildDocSetXmlString(List<InstalledDocProduct> list) {
        Document document = SharedDocUtils.buildDocSetXmlDocument(list);
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        return xMLOutputter.outputString(document);
    }

    private void deleteDocSetFile(File file) {
        File file2 = new File(file, DOCSET_FILE_NAME);
        this.io.deleteFile(file2);
    }
}

