/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install.command.StartMenuShortcuts;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class StartMenuShortcutCreator
implements FileProcessor {
    private final String shortcutName;
    private final String applicationFolderName;
    private String appRelease;
    private final AppLogger theLogger;
    private final IO io;
    private final StartMenuShortcuts startMenuShortcuts;

    StartMenuShortcutCreator(String string, String string2, String string3, AppLogger appLogger, IO iO, StartMenuShortcuts startMenuShortcuts) {
        this.shortcutName = string;
        this.applicationFolderName = string2;
        this.appRelease = string3;
        this.theLogger = appLogger;
        this.io = iO;
        this.startMenuShortcuts = startMenuShortcuts;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.theLogger.logMsg("Creating Start Menu shortcut: " + this.shortcutName);
        this.theLogger.debugMsg("target: " + file.getAbsolutePath() + "; location: " + this.applicationFolderName + " ;shortcut name: " + this.shortcutName);
        this.startMenuShortcuts.createShortcutInStartMenuFolder(file, this.shortcutName, this.applicationFolderName, this.appRelease);
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.deleteStartMenuShortcut(this.shortcutName, this.applicationFolderName, file);
    }

    private void deleteStartMenuShortcut(String string, String string2, File file) throws IOException {
        File file2 = this.startMenuShortcuts.getStartMenuFolder();
        File file3 = new File(file2, string2);
        File file4 = new File(file3, string);
        String string3 = this.startMenuShortcuts.getShortcutTargetPath(file4);
        this.theLogger.logMsg("Found Start Menu shortcut target path: " + string3);
        if (string3 != null && file.getAbsolutePath().equalsIgnoreCase(string3)) {
            this.theLogger.logMsg("Deleting start menu shortcut");
            file4.delete();
            this.theLogger.logMsg("deleted target: " + file.getAbsolutePath() + "; location: " + file3.getAbsolutePath());
            if (file2.equals(file3)) {
                return;
            }
            this.io.recursivelyDeleteFileAndParents(file3, file2);
        }
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.fileFileFilter();
    }
}

