/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class AssemblyFileInstaller
implements FileProcessor {
    private final DotNetFramework dotNetFramework;
    private final AppLogger appLogger;

    AssemblyFileInstaller(DotNetFramework dotNetFramework, AppLogger appLogger) {
        this.dotNetFramework = dotNetFramework;
        this.appLogger = appLogger;
    }

    @Override
    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Installing assembly " + file.getName());
        if (!this.dotNetFramework.installAssembly(file)) {
            installFlowControlHandler.alert(InstallResourceKeys.GAC_INSTALL_ERROR_MESSAGE.getString(file.getAbsolutePath()));
        }
    }

    @Override
    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.falseFileFilter();
    }
}

