/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.FontPicker;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;

class BasicFontPicker
extends MJPanel {
    private FontPicker fOwner;
    private MJComboBox fNameChoice;
    private MJComboBox fStyleChoice;
    private MJComboBox fSizeCombo;

    BasicFontPicker(FontPicker fontPicker) {
        this.fOwner = fontPicker;
        this.setLayout(new BorderLayout());
        ChoiceHandler choiceHandler = new ChoiceHandler();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(FontPicker.NAMES));
        this.fNameChoice = new MJComboBox(arrayList);
        this.fNameChoice.setName("NameChoice");
        this.fNameChoice.addItemListener((ItemListener)choiceHandler);
        this.add((Component)this.fNameChoice, "Center");
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(1, 0, 0));
        mJPanel.add(Box.createHorizontalStrut(4));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(Arrays.asList(FontPicker.STYLES));
        this.fStyleChoice = new MJComboBox(arrayList2);
        this.fStyleChoice.setName("StyleChoice");
        this.fStyleChoice.addItemListener((ItemListener)choiceHandler);
        mJPanel.add((Component)this.fStyleChoice);
        mJPanel.add(Box.createHorizontalStrut(4));
        this.fSizeCombo = new MJComboBox((Object[])FontPicker.SIZES);
        this.fSizeCombo.setEditable(true);
        this.fSizeCombo.setEditorColumnCount(3);
        this.fSizeCombo.setSelectedIndex(0);
        this.fSizeCombo.setName("SizeChoice");
        this.fSizeCombo.addActionListener((ActionListener)choiceHandler);
        mJPanel.add((Component)this.fSizeCombo);
        this.add((Component)mJPanel, "East");
        this.updateControls();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width > 275) {
            dimension.width = 275;
        }
        return dimension;
    }

    protected void updateControls() {
        Font font = this.fOwner.getSelectedFont();
        String string = font.getName();
        int n = font.getStyle();
        int n2 = font.getSize();
        for (int i = 0; i < this.fNameChoice.getItemCount(); ++i) {
            String string2 = (String)this.fNameChoice.getItemAt(i);
            if (!string.equals(string2)) continue;
            this.fNameChoice.setSelectedIndex(i);
            break;
        }
        this.fStyleChoice.setSelectedIndex(n);
        this.fSizeCombo.setSelectedItem((Object)Integer.toString(n2));
        this.fNameChoice.setEnabled(this.fOwner.isEnabled());
        this.fStyleChoice.setEnabled(this.fOwner.isEnabled());
        this.fSizeCombo.setEnabled(this.fOwner.isEnabled());
    }

    private boolean updateSelectedFont() {
        int n;
        String string = (String)this.fNameChoice.getSelectedItem();
        int n2 = this.fStyleChoice.getSelectedIndex();
        Font font = this.fOwner.getSelectedFont();
        boolean bl = false;
        try {
            n = Integer.parseInt((String)this.fSizeCombo.getSelectedItem());
            if (n < 0) {
                n = font.getSize();
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = font.getSize();
        }
        if (!string.equals(font.getName()) || n2 != font.getStyle() || n != font.getSize()) {
            this.fOwner.setSelectedFont(new Font(string, n2, n));
            bl = true;
        }
        return bl;
    }

    private class ChoiceHandler
    implements ItemListener,
    TextListener,
    ActionListener {
        private ChoiceHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
            } else {
                BasicFontPicker.this.updateControls();
            }
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (BasicFontPicker.this.updateSelectedFont()) {
                BasicFontPicker.this.fOwner.fireItemEvent();
            }
        }
    }
}

