/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans;

import com.mathworks.beans.CustomEnum;
import com.mathworks.beans.CustomEnumTags;
import com.mathworks.beans.EnumPair;
import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.ApplyPropertyEditorNew;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.util.IntHashtable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.Hashtable;

public class CustomEnumEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ApplyPropertyEditorNew {
    public static final String VALUE_KEY = "CustomEnumTags";
    private CustomEnumTags fTags = null;
    private PropertyEditor fCustomValueEditor = null;
    private Hashtable fStringToInt = new Hashtable();
    private IntHashtable fIntToString = new IntHashtable();
    private String[] fOrderedTags = new String[0];

    @Override
    public String[] getTags() {
        return this.fOrderedTags;
    }

    @Override
    public void setAsText(String string) {
        Object v = this.fStringToInt.get(string);
        Object object = this.getValue();
        if (object instanceof CustomEnum) {
            if (v instanceof Integer) {
                CustomEnum customEnum = (CustomEnum)object;
                customEnum.setEnumValue((Integer)v);
                this.setValue(customEnum);
            } else {
                throw new IllegalArgumentException(string);
            }
        }
    }

    @Override
    public String getAsText() {
        String string = null;
        Object object = this.getValue();
        if (object instanceof CustomEnum) {
            CustomEnum customEnum = (CustomEnum)object;
            string = customEnum.hasCustomValue() && this.fCustomValueEditor != null ? this.fCustomValueEditor.getAsText() : (customEnum.hasCustomValue() && this.fTags != null ? this.fTags.getCustomString() : (String)this.fIntToString.get(customEnum.getEnumValue()));
        }
        return string;
    }

    @Override
    public boolean isPaintable() {
        CustomEnum customEnum;
        boolean bl = false;
        Object object = this.getValue();
        if (object instanceof CustomEnum && (customEnum = (CustomEnum)object).hasCustomValue()) {
            bl = this.fCustomValueEditor.isPaintable();
        }
        return bl;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (this.fCustomValueEditor != null) {
            this.fCustomValueEditor.paintValue(graphics, rectangle);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        if (this.fCustomValueEditor != null) {
            return this.fCustomValueEditor.supportsCustomEditor();
        }
        return false;
    }

    @Override
    public Component getCustomEditor() {
        if (this.fCustomValueEditor != null) {
            return this.fCustomValueEditor.getCustomEditor();
        }
        return null;
    }

    @Override
    public boolean isAppliable() {
        return this.fCustomValueEditor instanceof ApplyPropertyEditor;
    }

    @Override
    public void apply() {
        if (this.fCustomValueEditor instanceof ApplyPropertyEditor) {
            ((ApplyPropertyEditor)((Object)this.fCustomValueEditor)).apply();
        }
    }

    @Override
    public Image getIcon() {
        Image image = null;
        if (this.fTags != null) {
            image = this.fTags.getIcon();
        }
        return image;
    }

    @Override
    public void setFrame(Frame frame) {
    }

    @Override
    public boolean hasAttachedData() {
        return true;
    }

    @Override
    public String getDataKey() {
        return VALUE_KEY;
    }

    @Override
    public void setData(Object object) {
        if (object instanceof CustomEnumTags) {
            this.fTags = (CustomEnumTags)object;
            this.updateTags();
            if (this.fTags.getCustomClass() != null) {
                this.fCustomValueEditor = PropertyEditorManager.findEditor(this.fTags.getCustomClass());
                this.fCustomValueEditor.addPropertyChangeListener(new CustomValueListener());
            } else {
                this.fCustomValueEditor = null;
            }
        } else {
            this.fTags = null;
        }
    }

    private void updateTags() {
        this.fStringToInt.clear();
        this.fIntToString.clear();
        this.fOrderedTags = new String[0];
        if (this.fTags != null) {
            EnumPair[] enumPairArray = this.fTags.getEnumPairs();
            if (enumPairArray != null && enumPairArray.length > 0) {
                this.fOrderedTags = new String[enumPairArray.length + 2];
                for (int i = 0; i < enumPairArray.length; ++i) {
                    this.fIntToString.put(enumPairArray[i].getValue(), (Object)enumPairArray[i].getName());
                    this.fStringToInt.put(enumPairArray[i].getName(), new Integer(enumPairArray[i].getValue()));
                    this.fOrderedTags[i] = enumPairArray[i].getName();
                }
                this.fOrderedTags[enumPairArray.length] = "-";
                this.fOrderedTags[enumPairArray.length + 1] = this.fTags.getCustomString();
            } else {
                this.fOrderedTags = new String[1];
                this.fOrderedTags[0] = this.fTags.getCustomString();
            }
        }
    }

    private class CustomValueListener
    implements PropertyChangeListener {
        private CustomValueListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = CustomEnumEditor.this.getValue();
            if (object instanceof CustomEnum) {
                CustomEnum customEnum = (CustomEnum)object;
                if (CustomEnumEditor.this.fCustomValueEditor != null) {
                    customEnum.setCustomValue(CustomEnumEditor.this.fCustomValueEditor.getValue());
                    CustomEnumEditor.this.firePropertyChange();
                }
            }
        }
    }
}

