/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.toolbox.coder.plugin.CodeGenResult;
import com.mathworks.toolbox.coder.plugin.TargetArtifact;
import java.io.File;

public class CodeGenWrapper
implements Command {
    private File fProjectFile;
    private WritableConfiguration fConfig;
    private volatile boolean fCancelled = false;
    private static final Matlab sMatlab = new Matlab();

    public CodeGenWrapper(File file, WritableConfiguration writableConfiguration, XmlReader xmlReader) {
        this.fProjectFile = file;
        this.fConfig = writableConfiguration;
    }

    public void execute(final CommandStatus commandStatus) {
        final boolean bl = this.fConfig.getParamAsString("param.artifact").equals("option.target.artifact.mex.instrumented");
        this.fConfig.setParamAsBoolean("param.BuiltInstrumentedMex", false);
        Object[] objectArray = new Object[]{"codeProject", this.fProjectFile.getAbsolutePath(), this, bl};
        sMatlab.fevalConsoleOutput("emlcprivate", objectArray, 1, new CompletionObserver(){

            public void completed(final int n, final Object object) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Matlab.getExecutionStatus((int)n) == 0) {
                            CodeGenResult codeGenResult = (CodeGenResult)object;
                            CodeGenWrapper.this.logBuildResults(codeGenResult);
                            commandStatus.printOutputLine(codeGenResult.getLog());
                            if (CodeGenWrapper.this.fCancelled) {
                                commandStatus.canceled();
                                return;
                            }
                            if (codeGenResult.isSucceeded()) {
                                commandStatus.finished();
                                CodeGenWrapper.this.fConfig.setParamAsBoolean("param.BuiltInstrumentedMex", bl);
                                CodeGenWrapper.this.fConfig.setParamAsBoolean("param.RanInstrumentedMex", false);
                                return;
                            }
                        }
                        commandStatus.failed(new CommandExecutionException((Command)CodeGenWrapper.this));
                    }
                });
            }
        });
    }

    private void logBuildResults(CodeGenResult codeGenResult) {
        String string = this.fConfig.getParamAsString("param.artifact");
        String string2 = TargetArtifact.isMexTarget(string) ? "param.mex.mainhtml" : "param.grt.mainhtml";
        this.fConfig.setParamAsString(string2, codeGenResult.getMainHtml());
    }

    public void cancel() {
        this.fCancelled = true;
    }

    public boolean isCancelled() {
        return this.fCancelled;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.fProjectFile.getName();
        if (string.indexOf(32) == -1) {
            stringBuilder.append(">> coder -build ");
            stringBuilder.append(string);
        } else {
            stringBuilder.append(">> coder('-build', '");
            stringBuilder.append(string);
            stringBuilder.append("')");
        }
        return stringBuilder.toString();
    }
}

