/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.ps.AbstractPSGraphics2D;

public class PSGraphics2D
extends AbstractPSGraphics2D
implements MultiPageDocument {
    private boolean multiPage;
    private int currentPage;

    public PSGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public PSGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PSGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public PSGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    public PSGraphics2D(OutputStream ros, Rectangle bbox) {
        super(bbox, false);
        this.init(ros);
    }

    public PSGraphics2D(OutputStream ros, Rectangle bbox, int psLangLevel) {
        super(bbox, false, psLangLevel);
        this.init(ros);
    }

    protected PSGraphics2D(PSGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
        this.multiPage = graphics.multiPage;
        this.currentPage = graphics.currentPage;
    }

    protected void init(OutputStream os) {
        super.init(os);
        this.multiPage = false;
        this.currentPage = 0;
    }

    public void setMultiPage(boolean multiPage) {
        this.multiPage = multiPage;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension size, String title) throws IOException {
        this.openPage(size, title, null);
    }

    protected void openPage(Dimension size, String title, Component component) {
        ++this.currentPage;
        String string = title = title == null ? "" + this.currentPage : "(" + title + ")";
        if (this.isMultiPage()) {
            this.os.println("%%Page: " + title + " " + this.currentPage);
        }
        this.os.println(this.isMultiPage() ? "%%BeginPageSetup" : "%%BeginSetup");
        super.openPage(size, title, component);
        this.os.println(this.isMultiPage() ? "%%EndPageSetup" : "%%EndSetup");
        this.os.println();
        try {
            this.writeGraphicsState();
            this.writeBackground();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closePage() {
        if (this.isMultiPage()) {
            this.os.println("%%PageTrailer");
        }
    }

    public void writeHeader() throws IOException {
        if (!this.isMultiPage()) {
            Dimension size = this.getSize();
            this.resetClip(new Rectangle(0, 0, size.width, size.height));
        }
        this.os = new PrintStream(this.ros, true);
        this.os.println("%!PS-Adobe-3.0");
        super.writeHeader();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeTrailer() throws IOException {
        if (!this.isMultiPage()) {
            this.closePage();
        }
        super.writeTrailer();
        if (this.isMultiPage()) {
            this.os.println("%%Pages: " + this.currentPage);
        }
        this.os.println("%%EOF");
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new PSGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        PSGraphics2D graphics = new PSGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }
}

