/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ScripterCallback;
import ice.storm.StormBase;
import ice.storm.StormCallback;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.util.security.BoxedCode;
import java.awt.Container;

public class CallbackAdapter
implements ViewportCallback,
ScripterCallback {
    public void init(StormBase stormBase) {
    }

    public Container createTopLevelContainer(Viewport viewport) {
        if (Debug.trace) {
            Debug.trace((String)("ERROR: NO TOP LEVEL CONTAINER FOR " + viewport));
        }
        throw new RuntimeException("ice.storm.CallbackAdapter.createTopLevelContainer should be overwritten to return viewport container");
    }

    public void disposeTopLevelContainer(Viewport viewport) {
        if (Debug.trace) {
            Debug.trace((String)("WARNING: IGNORING FOR " + viewport));
        }
    }

    public void processViewportMessage(Viewport viewport, String string, Object object, Object object2) {
    }

    public long getMaxScriptRunningTime() {
        return 5000L;
    }

    public boolean interruptLongRunningScript(Viewport viewport, long l) {
        if (Debug.trace) {
            Debug.trace((String)("Interrupting too long (" + l + " ms) running script"));
        }
        return true;
    }

    public boolean allowScriptClose(Viewport viewport, boolean bl) {
        if (bl) {
            return true;
        }
        if (Debug.trace) {
            Debug.trace((String)("Attempt to close top level window " + viewport + " by script"));
        }
        return false;
    }

    public void reportScriptError(Viewport viewport, boolean bl, String string, String string2, int n, String string3, int n2) {
        if (Debug.trace) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bl ? "script warning: " : "SCRIPT ERROR: ");
            stringBuffer.append(string2);
            stringBuffer.append(':');
            stringBuffer.append(n + 1);
            stringBuffer.append(':');
            stringBuffer.append(n2);
            stringBuffer.append(": ");
            stringBuffer.append(string);
            if (string3 != null) {
                stringBuffer.append('\n');
                stringBuffer.append(string3);
                stringBuffer.append('\n');
                for (int i = 0; i < n2 - 1; ++i) {
                    stringBuffer.append('.');
                }
                stringBuffer.append('^');
            }
            if (Debug.trace) {
                Debug.trace((String)stringBuffer.toString());
            }
        }
    }

    public String scriptPrompt(Viewport viewport, String string, String string2) {
        if (Debug.trace) {
            Debug.trace((String)("Script prompt call, window=" + viewport + ", message=" + string + " default=" + string2));
        }
        return string2;
    }

    public boolean scriptConfirm(Viewport viewport, String string) {
        if (Debug.trace) {
            Debug.trace((String)("Script confirm call, window=" + viewport + ", message=" + string));
        }
        return false;
    }

    public void scriptAlert(Viewport viewport, String string) {
        if (Debug.trace) {
            Debug.trace((String)("Script alert call, window=" + viewport + ", message=" + string));
        }
    }

    public void scriptPrint(Viewport viewport) {
        if (Debug.trace) {
            Debug.trace((String)("Script print call, window=" + viewport));
        }
    }

    public final void registerWith(StormBase stormBase) {
        stormBase.setViewportCallback(this);
        stormBase.setScripterCallback(this);
    }

    public static BoxedCode box_createTopLevelContainer(ViewportCallback viewportCallback, Viewport viewport) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 1;
        boxedCallback.viewportCallback = viewportCallback;
        boxedCallback.vp = viewport;
        return boxedCallback;
    }

    public static BoxedCode box_disposeTopLevelContainer(ViewportCallback viewportCallback, Viewport viewport) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 2;
        boxedCallback.viewportCallback = viewportCallback;
        boxedCallback.vp = viewport;
        return boxedCallback;
    }

    public static BoxedCode box_getMaxScriptRunningTime(ScripterCallback scripterCallback) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 3;
        boxedCallback.scripterCallback = scripterCallback;
        return boxedCallback;
    }

    public static BoxedCode box_interruptLongRunningScript(ScripterCallback scripterCallback, Viewport viewport, long l) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 4;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.scriptRunTime = l;
        return boxedCallback;
    }

    public static BoxedCode box_allowScriptClose(ScripterCallback scripterCallback, Viewport viewport, boolean bl) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 5;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.openedByScript = bl;
        return boxedCallback;
    }

    public static BoxedCode box_reportScriptError(ScripterCallback scripterCallback, Viewport viewport, boolean bl, String string, String string2, int n, String string3, int n2) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 6;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.justWarning = bl;
        boxedCallback.errorMessage = string;
        boxedCallback.url = string2;
        boxedCallback.lineNumber = n;
        boxedCallback.lineSource = string3;
        boxedCallback.lineOffset = n2;
        return boxedCallback;
    }

    public static BoxedCode box_scriptPrompt(ScripterCallback scripterCallback, Viewport viewport, String string, String string2) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 7;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.msg = string;
        boxedCallback.defVal = string2;
        return boxedCallback;
    }

    public static BoxedCode box_scriptConfirm(ScripterCallback scripterCallback, Viewport viewport, String string) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 8;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.msg = string;
        return boxedCallback;
    }

    public static BoxedCode box_scriptAlert(ScripterCallback scripterCallback, Viewport viewport, String string) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 9;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        boxedCallback.msg = string;
        return boxedCallback;
    }

    public static BoxedCode box_scriptPrint(ScripterCallback scripterCallback, Viewport viewport) {
        BoxedCallback boxedCallback = new BoxedCallback();
        boxedCallback.id = 10;
        boxedCallback.scripterCallback = scripterCallback;
        boxedCallback.vp = viewport;
        return boxedCallback;
    }

    private static final class BoxedCallback
    implements BoxedCode {
        private static final int Id_createTopLevelContainer = 1;
        private static final int Id_disposeTopLevelContainer = 2;
        private static final int Id_getMaxScriptRunningTime = 3;
        private static final int Id_interruptLongRunningScript = 4;
        private static final int Id_allowScriptClose = 5;
        private static final int Id_reportScriptError = 6;
        private static final int Id_scriptPrompt = 7;
        private static final int Id_scriptConfirm = 8;
        private static final int Id_scriptAlert = 9;
        private static final int Id_scriptPrint = 10;
        int id;
        ViewportCallback viewportCallback;
        ScripterCallback scripterCallback;
        Viewport vp;
        long scriptRunTime;
        boolean openedByScript;
        boolean justWarning;
        String errorMessage;
        String url;
        int lineNumber;
        String lineSource;
        int lineOffset;
        String msg;
        String defVal;

        private BoxedCallback() {
        }

        public Object run() {
            switch (this.id) {
                case 1: {
                    return this.viewportCallback.createTopLevelContainer(this.vp);
                }
                case 2: {
                    this.viewportCallback.disposeTopLevelContainer(this.vp);
                    return null;
                }
                case 3: {
                    return new Long(this.scripterCallback.getMaxScriptRunningTime());
                }
                case 4: {
                    return this.scripterCallback.interruptLongRunningScript(this.vp, this.scriptRunTime) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 5: {
                    return this.scripterCallback.allowScriptClose(this.vp, this.openedByScript) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 6: {
                    this.scripterCallback.reportScriptError(this.vp, this.justWarning, this.errorMessage, this.url, this.lineNumber, this.lineSource, this.lineOffset);
                    return null;
                }
                case 7: {
                    return this.scripterCallback.scriptPrompt(this.vp, this.msg, this.defVal);
                }
                case 8: {
                    return this.scripterCallback.scriptConfirm(this.vp, this.msg) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 9: {
                    this.scripterCallback.scriptAlert(this.vp, this.msg);
                    return null;
                }
                case 10: {
                    this.scripterCallback.scriptPrint(this.vp);
                    return null;
                }
            }
            Debug.bug();
            return null;
        }
    }

    static class OldCallbackWrap
    extends CallbackAdapter {
        StormCallback oldCallback;

        OldCallbackWrap(StormCallback stormCallback) {
            this.oldCallback = stormCallback;
        }

        public void init(StormBase stormBase) {
            this.oldCallback.init(stormBase);
        }

        public Container createTopLevelContainer(Viewport viewport) {
            return this.oldCallback.createTopLevelContainer(viewport);
        }

        public void disposeTopLevelContainer(Viewport viewport) {
            this.oldCallback.disposeTopLevelContainer(viewport);
        }

        public String scriptPrompt(Viewport viewport, String string, String string2) {
            return this.oldCallback.prompt(viewport, string, string2);
        }

        public boolean scriptConfirm(Viewport viewport, String string) {
            return this.oldCallback.confirm(viewport, string);
        }

        public void scriptAlert(Viewport viewport, String string) {
            this.oldCallback.message(viewport, string);
        }
    }
}

