/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.ObjectBox;
import java.awt.Graphics;
import java.awt.Point;

public class ScrollBox
extends BlockBox {
    private BlockBox block;
    private FloatPainter floatPainter = new FloatPainter();
    private int scrollX;
    private int scrollY;

    ScrollBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout, byte by) {
        super(dElement, cSSAttribs, cSSLayout, by);
        CSSAttribs cSSAttribs2 = new CSSAttribs(cSSLayout.sdata, cSSAttribs);
        cSSAttribs2.display = 41;
        cSSAttribs2.stealBackgroundFrom(cSSAttribs);
        this.block = new BlockBox(dElement, cSSAttribs2, cSSLayout, by);
        this.block.setParentBox(this);
        if (cSSAttribs2.background_image != null) {
            this.block.loadBackgroundImage(cSSLayout.doc);
        }
    }

    void dispose() {
        this.block.dispose();
        this.block = null;
        super.dispose();
    }

    CSSBox addChild(CSSBox cSSBox) {
        if (cSSBox instanceof ObjectBox) {
            super.addChild(cSSBox);
        } else {
            this.block = (BlockBox)this.block.addChild(cSSBox);
        }
        return this;
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        CSSBox cSSBox = this.block.getBoxAt(n + this.scrollX, n2 + this.scrollY, point);
        if (cSSBox == null || cSSBox == this.block) {
            cSSBox = this;
        }
        return cSSBox;
    }

    public void setScrollPosition(int n, int n2) {
        this.scrollX = n;
        this.scrollY = n2;
    }

    void findAbsolutePosition_int(Point point) {
    }

    void calcMinMaxWidths() {
        this.block.calcMinMaxWidths();
    }

    public void paint(Graphics graphics) {
    }

    public int getScrollableWidth() {
        return this.block.width;
    }

    public int getScrollableHeight() {
        return this.block.height;
    }

    public void layoutScrollable(int n, int n2) {
        this.floatPainter.clear();
        int n3 = n;
        if (n3 < this.block.minWidth) {
            n3 = this.block.minWidth;
        }
        FloatManager floatManager = new FloatManager(0, n3);
        this.block.layout(n3, n2, floatManager);
        this.block.height += floatManager.skipTill(n3);
        CSSBox cSSBox = floatManager.getFirstFloater();
        if (cSSBox != null) {
            this.floatPainter.add(cSSBox);
        }
    }

    public void paintScrollable(Graphics graphics) {
        this.block.paint(graphics);
    }

    public ScrollBox getAncestorScrollBox() {
        CSSBox cSSBox = this.parentBox;
        while (cSSBox != null) {
            if (cSSBox instanceof ScrollBox) {
                return (ScrollBox)cSSBox;
            }
            cSSBox = cSSBox.parentBox;
        }
        return null;
    }

    public ObjectBox getObjectBox() {
        CSSBox cSSBox = this.first;
        if (cSSBox != null && cSSBox instanceof ObjectBox) {
            return (ObjectBox)cSSBox;
        }
        return null;
    }
}

