/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.LineMetricValue;
import ice.util.UnsupportedOperationException;

public class LineBox {
    public int _inheritedContentHeight;
    boolean _normalized;
    private int normalizedBaseline;
    private LineMetricValue[] _chunks;
    private static final int CHUNK_ALLOCATION = 3;
    private int _topOfLineBox = Integer.MAX_VALUE;
    private int _bottomOfLineBox = Integer.MIN_VALUE;
    private int _superscriptHackValue;
    private int _subscriptHackValue;
    private int _lmIndex;
    static int _passes;
    static int _expansions;

    LineBox() {
        this._chunks = new LineMetricValue[3];
    }

    void treatInlineBox(long l, int n, int n2) {
        if (l == 0L) {
            return;
        }
        LineMetricValue lineMetricValue = new LineMetricValue();
        lineMetricValue.boxId = n;
        lineMetricValue.verticalAlign = n2;
        int n3 = CSSBox.unwrapLineHeight(l);
        int n4 = CSSBox.unwrapAscent(l);
        int n5 = CSSBox.unwrapDescent(l);
        if (n3 == 0) {
            n3 = n4 + n5;
        }
        int n6 = 0;
        if (n3 > 0) {
            n6 = Math.round((float)(n4 + n5 - n3) / 2.0f);
        }
        switch (n2) {
            case 140: {
                lineMetricValue.topOfContent = -n4;
                lineMetricValue.topOfInline = lineMetricValue.topOfContent + n6;
                lineMetricValue.bottomOfInline = lineMetricValue.topOfInline + n3;
                lineMetricValue.bottomOfContent = n5;
                if (lineMetricValue.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = lineMetricValue.topOfInline;
                }
                if (lineMetricValue.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = lineMetricValue.bottomOfInline;
                break;
            }
            case 16: {
                lineMetricValue.topOfContent = -n6;
                lineMetricValue.topOfInline = 0;
                lineMetricValue.bottomOfInline = n3;
                lineMetricValue.bottomOfContent = lineMetricValue.bottomOfInline + n6;
                break;
            }
            case 144: {
                int n7 = n4 + n5;
                lineMetricValue.topOfContent = this._inheritedContentHeight != 0 ? Math.round(-((float)this._inheritedContentHeight / 3.0f) - (float)n7 / 2.0f) : Math.round(-(n7 / 5) - n7 / 2);
                lineMetricValue.topOfInline = lineMetricValue.topOfContent + n6;
                lineMetricValue.bottomOfInline = lineMetricValue.topOfInline + n3;
                lineMetricValue.bottomOfContent = lineMetricValue.bottomOfInline + n6;
                if (lineMetricValue.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = lineMetricValue.topOfInline;
                }
                if (lineMetricValue.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = lineMetricValue.bottomOfInline;
                break;
            }
            case 17: {
                lineMetricValue.topOfContent = -n4;
                lineMetricValue.topOfInline = lineMetricValue.topOfContent + n6;
                lineMetricValue.bottomOfInline = lineMetricValue.topOfInline + n3;
                lineMetricValue.bottomOfContent = n5;
                break;
            }
            case 145: {
                lineMetricValue.bottomOfInline = Math.round((float)this._inheritedContentHeight / 4.0f);
                lineMetricValue.bottomOfContent = lineMetricValue.bottomOfInline + n6;
                lineMetricValue.topOfInline = lineMetricValue.bottomOfInline - n3;
                lineMetricValue.topOfContent = lineMetricValue.topOfInline - n6;
                if (lineMetricValue.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = lineMetricValue.topOfInline;
                }
                if (lineMetricValue.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = lineMetricValue.bottomOfInline;
                break;
            }
            case 143: {
                lineMetricValue.topOfContent = -Math.round((float)this._inheritedContentHeight * 4.0f / 5.0f);
                lineMetricValue.topOfInline = lineMetricValue.topOfContent + n6;
                lineMetricValue.bottomOfInline = lineMetricValue.topOfInline + n3;
                lineMetricValue.bottomOfContent = lineMetricValue.bottomOfInline + n6;
                if (lineMetricValue.bottomOfInline > this._bottomOfLineBox) {
                    this._bottomOfLineBox = lineMetricValue.bottomOfInline;
                }
                if (lineMetricValue.topOfInline >= this._topOfLineBox) break;
                this._topOfLineBox = lineMetricValue.topOfInline;
                break;
            }
            case 141: 
            case 142: {
                int n8 = this._inheritedContentHeight / 4;
                if (n2 == 142) {
                    this._superscriptHackValue = n8;
                } else {
                    this._subscriptHackValue = n8;
                }
                lineMetricValue.topOfContent = -n4;
                lineMetricValue.topOfInline = lineMetricValue.topOfContent + n6;
                lineMetricValue.bottomOfInline = lineMetricValue.topOfInline + n3;
                lineMetricValue.bottomOfContent = n5;
                if (lineMetricValue.bottomOfInline > this._bottomOfLineBox) {
                    this._bottomOfLineBox = lineMetricValue.bottomOfInline;
                }
                if (lineMetricValue.topOfInline >= this._topOfLineBox) break;
                this._topOfLineBox = lineMetricValue.topOfInline;
                break;
            }
            default: {
                if (!Debug.trace) break;
                Debug.trace((String)("Unsupported Vertical-align parameter: " + n2));
            }
        }
        ++_passes;
        if (this._lmIndex == this._chunks.length) {
            LineMetricValue[] lineMetricValueArray = new LineMetricValue[this._chunks.length * 2];
            System.arraycopy(this._chunks, 0, lineMetricValueArray, 0, this._chunks.length);
            this._chunks = lineMetricValueArray;
            ++_expansions;
        }
        this._chunks[this._lmIndex++] = lineMetricValue;
    }

    public void doneLine() {
        int n;
        int n2;
        if (this._lmIndex == 0) {
            this._bottomOfLineBox = 0;
            this._topOfLineBox = 0;
            this._normalized = true;
            return;
        }
        for (n2 = 0; n2 < this._lmIndex; ++n2) {
            if (this._chunks[n2].verticalAlign != 17 || (n = this._chunks[n2].bottomOfInline - this._chunks[n2].topOfInline) <= this._bottomOfLineBox - this._topOfLineBox) continue;
            this._topOfLineBox = this._bottomOfLineBox - n;
        }
        this._bottomOfLineBox -= this._topOfLineBox;
        block8: for (n = 0; n < this._lmIndex; ++n) {
            switch (this._chunks[n].verticalAlign) {
                case 17: {
                    n2 = this._bottomOfLineBox - this._chunks[n].bottomOfInline;
                    this._chunks[n].topOfContent += n2;
                    this._chunks[n].topOfInline += n2;
                    this._chunks[n].bottomOfInline += n2;
                    this._chunks[n].bottomOfContent += n2;
                    if (this._chunks[n].bottomOfInline <= this._bottomOfLineBox) continue block8;
                    this._bottomOfLineBox = this._chunks[n].bottomOfInline;
                    continue block8;
                }
                case 140: 
                case 143: 
                case 144: 
                case 145: {
                    this._chunks[n].topOfContent -= this._topOfLineBox;
                    this._chunks[n].topOfInline -= this._topOfLineBox;
                    this._chunks[n].bottomOfInline -= this._topOfLineBox;
                    this._chunks[n].bottomOfContent -= this._topOfLineBox;
                    continue block8;
                }
                case 141: {
                    this._chunks[n].topOfContent -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[n].topOfInline -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[n].bottomOfInline -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[n].bottomOfContent -= this._topOfLineBox - this._subscriptHackValue;
                    continue block8;
                }
                case 142: {
                    this._chunks[n].topOfContent -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[n].topOfInline -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[n].bottomOfInline -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[n].bottomOfContent -= this._topOfLineBox + this._superscriptHackValue;
                    continue block8;
                }
                case 16: {
                    if (this._chunks[n].bottomOfInline <= this._bottomOfLineBox) continue block8;
                    this._bottomOfLineBox = this._chunks[n].bottomOfInline;
                }
            }
        }
        this.normalizedBaseline = -this._topOfLineBox;
        this._topOfLineBox = 0;
        this._normalized = true;
    }

    public long getLineParameters() {
        if (!this._normalized) {
            throw new UnsupportedOperationException("Programmer error: LineBox not normalized");
        }
        long l = CSSBox.wrapDescentAscent(0, 0, this._bottomOfLineBox);
        if (this._bottomOfLineBox < -300) {
            Debug.p((String)"Warning, uninitialized bottom of lineBox");
        }
        return l;
    }

    public int getYDeflectionOfChunk(int n) {
        for (int i = 0; i < this._chunks.length; ++i) {
            if (this._chunks[i] == null || this._chunks[i].boxId != n) continue;
            return this._chunks[i].topOfContent;
        }
        return 0;
    }

    public int getNormalizedBaseline() {
        if (!this._normalized) {
            throw new UnsupportedOperationException("Programmer error: LineBox not normalized");
        }
        return this.normalizedBaseline;
    }
}

