/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.util.Stack;

class HtmlDOMFixer {
    private static final int TSET_LEAF = 0;
    private static final int TSET_SPAN = 1;
    private static final int TSET_BODY = 2;
    private static final int TSET_ADDRESS = 3;
    private static final int TSET_DIV = 4;
    private static final int TSET_A = 5;
    private static final int TSET_MAP = 6;
    private static final int TSET_OBJECT = 7;
    private static final int TSET_PRE = 8;
    private static final int TSET_DL = 9;
    private static final int TSET_UL = 10;
    private static final int TSET_FORM = 11;
    private static final int TSET_LABEL = 12;
    private static final int TSET_SELECT = 13;
    private static final int TSET_OPTGROUP = 14;
    private static final int TSET_OPTION = 15;
    private static final int TSET_FIELDSET = 16;
    private static final int TSET_BUTTON = 17;
    private static final int TSET_TABLE = 18;
    private static final int TSET_TBODY = 19;
    private static final int TSET_COLGROUP = 20;
    private static final int TSET_TR = 21;
    private static final int TSET_HEAD = 22;
    private static final int TSET_SCRIPT = 23;
    private static final int TSET_HTML = 24;
    private static final int TSET_FRAMESET = 25;
    private static final int TSET_DOCUMENT = 26;
    private static final int TSET_NOSCRIPT = 27;
    private static final int LAST_TSET = 27;
    private static final int NEED_END = 1;
    private static final int END_OPTIONAL = 2;
    private DDocument doc;
    private DMapElement latestMap;
    private DNode nodeToAdd;
    private boolean[] checked;
    private boolean check_required = true;
    private boolean head_exists = false;
    private boolean body_exists = false;
    private boolean html_exists = false;
    private boolean title_exists = false;
    DNode parentOfIllegalTitleNode;
    DNode hackTable;
    private DNode lastBreakNode;
    private boolean allowNoScript = false;
    private Stack isIndexElements;

    HtmlDOMFixer(DDocument dDocument) {
        this.doc = dDocument;
    }

    void onClosingTR(DNode dNode) {
        DNode dNode2 = dNode.getLastDChild();
        if (dNode2 == null || dNode2.getNameId() != 81) {
            return;
        }
        DNode dNode3 = dNode2.getLastDChild();
        if (dNode3 == null || dNode3.getNameId() != 92) {
            return;
        }
        DTextNode dTextNode = (DTextNode)dNode3;
        if (dTextNode.text == null || dTextNode.text.length != 1 || dTextNode.text[0] != ' ') {
            return;
        }
        dNode2.removeDChild(dTextNode);
    }

    boolean isFirstWhitespaceAllowed(DNode dNode) {
        if (dNode.getFirstChild() != null) {
            return true;
        }
        while (dNode != null) {
            int n = dNode.getNameId();
            if (n == 64 || n == 26 || n == 81) {
                return false;
            }
            DNode dNode2 = dNode.getParentDNode();
            if (dNode2 == null || dNode2 != null && dNode2.getFirstChild() != dNode) break;
            dNode = dNode2;
        }
        return true;
    }

    boolean tagsAreSynonymous(DElement dElement, int n) {
        boolean bl = false;
        switch (dElement.tagId) {
            case 31: {
                bl = n == 7 || n == 1;
                break;
            }
            case 7: {
                bl = n == 31 || n == 1;
                break;
            }
            case 1: {
                bl = n == 31 || n == 7;
                break;
            }
            case 3: {
                bl = n == 1;
            }
        }
        return bl;
    }

    boolean canCloseNodeWith(DNode dNode, int n) {
        int n2 = dNode.getNameId();
        switch (n) {
            case 58: 
            case 59: {
                return true;
            }
            case 60: {
                if (n2 != 45) break;
                return true;
            }
            case 81: {
                if (n2 != 71) break;
                return true;
            }
        }
        if (n2 >= 96) {
            return false;
        }
        return 1 != HtmlDOMFixer.getEndTagFlag(n2);
    }

    DNode closeHackTable(boolean bl) {
        DNode dNode = this.hackTable;
        this.hackTable = null;
        return dNode;
    }

    boolean hasHackTable() {
        return this.hackTable != null;
    }

    void closeLastBreakNode() {
        if (this.lastBreakNode != null) {
            DNode dNode = this.lastBreakNode;
            DNode dNode2 = this.lastBreakNode.getParentDNode();
            while (dNode != null && dNode.getNameId() == 14) {
                DNode dNode3 = dNode.getPreviousDSibling();
                dNode2.removeDChild(dNode);
                dNode = dNode3;
            }
            this.lastBreakNode = null;
        }
    }

    DNode addChildNode(DNode dNode, DNode dNode2) {
        if (this.parentOfIllegalTitleNode != null) {
            return this.parentOfIllegalTitleNode;
        }
        this.nodeToAdd = dNode2;
        int n = dNode2.getNameId();
        if (this.hackTable != null) {
            switch (n) {
                case 16: 
                case 80: 
                case 81: 
                case 83: 
                case 85: 
                case 87: {
                    DNode dNode3 = this.hackTable;
                    this.hackTable = null;
                    return this.addChildNode(dNode3, dNode2);
                }
            }
            if (this.hackTable.getParentDNode() == dNode && this.test_r(dNode.getNameId(), n)) {
                dNode.insertBefore(dNode2, this.hackTable);
                return dNode2;
            }
        }
        if (this.lastBreakNode != null && dNode == this.lastBreakNode.getParentDNode()) {
            this.lastBreakNode = null;
        }
        this.check_required = true;
        DNode dNode4 = this.do_fix_add(dNode, dNode2, n);
        if (dNode4 == null) {
            this.check_required = false;
            dNode4 = this.do_fix_add(dNode, dNode2, n);
            if (dNode4 == null) {
                int n2 = dNode.getNameId();
                if (n == 79 || n2 == 80) {
                    return this.addChildNode(dNode.getParentDNode(), dNode2);
                }
                if (n2 == 79 || n2 == 87 || n2 == 80) {
                    DNode dNode5;
                    for (dNode5 = dNode; dNode5 != null && dNode5.getNameId() != 79; dNode5 = dNode5.getParentDNode()) {
                    }
                    DNode dNode6 = dNode5.getParentDNode();
                    if (dNode6 != null) {
                        dNode6.insertBefore(dNode2, dNode5);
                        switch (dNode2.getNameId()) {
                            case 1: 
                            case 71: {
                                if (HtmlDOMFixer.get_child_index(dNode2.getNameId()) == 0) break;
                                this.hackTable = dNode5;
                                return dNode2;
                            }
                        }
                    }
                }
            }
            if (dNode4 == null) {
                dNode4 = dNode;
            }
        }
        return dNode4;
    }

    void setAllowNoScript(boolean bl) {
        this.allowNoScript = bl;
    }

    void moveIsIndexElements() {
        if (this.isIndexElements != null) {
            DElement dElement = this.doc.getDBody();
            while (!this.isIndexElements.isEmpty()) {
                dElement.insertDChildBefore((DNode)this.isIndexElements.pop(), dElement.getFirstDChild());
            }
            this.isIndexElements.removeAllElements();
            this.isIndexElements = null;
        }
    }

    private DNode do_fix_add(DNode dNode, DNode dNode2, int n) {
        DNode dNode3;
        int n2 = dNode.getNameId();
        if (n2 >= 96 || n >= 96) {
            dNode.appendDChild(dNode2);
            if (n == 92) {
                return dNode;
            }
            return dNode2;
        }
        if (n2 == 93) {
            if (n == 92) {
                return dNode.appendDChild(dNode2);
            }
            return this.do_fix_add(dNode.getParentDNode(), dNode2, n);
        }
        if (n == 46 && n2 == 1) {
            DNode dNode4 = dNode.getFirstDChild();
            if (dNode4 != null && dNode4.getNameId() == 92 && ((DTextNode)dNode4).isEmpty()) {
                dNode.removeDChild(dNode4);
            }
            dNode.appendDChild(dNode2);
            return dNode;
        }
        if (n == 92 && n2 == 26) {
            DNode dNode5;
            if (((DTextNode)dNode2).isEmpty() && (dNode5 = dNode.getLastDChild()) != null && dNode5.getNameId() == 46) {
                return dNode;
            }
        } else if (n == 49) {
            boolean bl = true;
            dNode3 = dNode;
            while (dNode3.getNameId() != 43) {
                if (dNode3.getNameId() == 13) {
                    bl = false;
                    break;
                }
                dNode3 = dNode3.getParentDNode();
            }
            if (bl) {
                if (this.isIndexElements == null) {
                    this.isIndexElements = new Stack();
                }
                this.isIndexElements.addElement(dNode2);
                return dNode;
            }
        } else if (n == 43) {
            if (this.html_exists) {
                return dNode;
            }
            this.html_exists = true;
        } else if (n == 13) {
            if (this.body_exists) {
                DElement dElement = this.doc.getDBody();
                if (dNode2 != null) {
                    if (dElement != null) {
                        dElement.copyAttrsFrom((DElement)dNode2, false);
                        return dNode;
                    }
                    this.doc.getDocumentDElement().appendDChild(dNode2);
                    return dNode2;
                }
                return null;
            }
            this.body_exists = true;
        }
        if (n2 == 43 && this.body_exists && n == 14) {
            DElement dElement = dNode.doc.getDBody();
            dElement.appendDChild(dNode2);
            return dNode2;
        }
        if (n2 == 59) {
            return this.allowNoScript ? dNode.appendDChild(dNode2) : dNode;
        }
        if (n2 == 58 && n != 33 && n != 34 && !ThePilot.viewNoframes) {
            return dNode;
        }
        int n3 = HtmlDOMFixer.get_child_index(n2);
        if (n3 >= 0 && HtmlDOMFixer.checkHTML4Accept(n3, n)) {
            return this.do_trivial_add(dNode, dNode2, n, n2);
        }
        if (n == 92) {
            if (((DTextNode)dNode2).isEmpty()) {
                return dNode;
            }
        } else if (n == 41) {
            if (this.head_exists) {
                return null;
            }
            this.head_exists = true;
        } else {
            if (n == 86 && this.title_exists) {
                this.parentOfIllegalTitleNode = dNode;
                return this.parentOfIllegalTitleNode;
            }
            if (n == 55) {
                this.latestMap = (DMapElement)dNode2;
            } else if (n == 6 && n2 != 55) {
                if (this.latestMap != null) {
                    this.latestMap.appendDChild(dNode2);
                    return dNode;
                }
            } else if (n == 57 && this.head_exists && (dNode3 = this.doc.getHead()) != null) {
                dNode3.appendDChild(dNode2);
                return dNode;
            }
        }
        this.checked = new boolean[96];
        dNode3 = dNode;
        do {
            int n4;
            if (n2 == 81 && n == 87) {
                DElement dElement = (DElement)dNode3.getParentDNode();
                if (dElement.getSynthetic() && !dNode3.hasChildNodes()) {
                    dElement.setSynthetic(false);
                    dElement.copyAttrsFrom((DElement)dNode2);
                    return dNode3;
                }
            } else {
                if (n2 == 60 && n == 45) {
                    return dNode3;
                }
                if (n2 == 73 && n == 26) {
                    return dNode3.appendDChild(dNode2);
                }
                if (n2 == 43) {
                    if (this.body_exists && this.doc.getDBody() != null && this.test_r(13, n)) {
                        return this.doc.getDBody().appendDChild(this.nodeToAdd);
                    }
                } else if (n == 31 && n2 == 79) {
                    DElement dElement = this.doc.createElement(80);
                    dElement.setSynthetic(true);
                    dNode3.appendDChild(dElement);
                    DElement dElement2 = this.doc.createElement(87);
                    dElement2.setSynthetic(true);
                    dElement.appendDChild(dElement2);
                    dElement = dElement2;
                    dElement2 = this.doc.createElement(81);
                    dElement2.setSynthetic(true);
                    dElement.appendDChild(dElement2);
                    dElement = dElement2;
                    return dElement.appendDChild(dNode2);
                }
            }
            if ((n4 = HtmlDOMFixer.get_child_index(n2)) == 10) {
                if (n == 64) {
                    dNode3.appendDChild(dNode2);
                    return dNode3;
                }
                if (n != 53 && !dNode3.hasChildNodes()) {
                    if (n == 64) {
                        return dNode3.appendDChild(dNode2);
                    }
                    DElement dElement = this.doc.createElement(53);
                    dNode3.appendDChild(dElement);
                    dElement.setSynthetic(true);
                    dElement.appendDChild(dNode2);
                    return dNode2;
                }
                if (dNode2 instanceof DTextNode) {
                    return this.do_fix_add(dNode3.getParentDNode(), dNode2, n);
                }
            } else {
                if (n2 == 7 && (n == 64 || n == 27 || n == 25)) {
                    dNode3.appendDChild(dNode2);
                    return dNode2;
                }
                if (n2 == 1 && (n == 64 || n == 17 || n == 26 || 35 <= n && n <= 40)) {
                    dNode3.appendDChild(dNode2);
                    return dNode2;
                }
                if (n == 53 && n2 != 53 && n2 != 31) {
                    DNode dNode6;
                    if (n2 == 64) {
                        for (DNode dNode7 = dNode3.getParentDNode(); dNode7 != null; dNode7 = dNode7.getParentDNode()) {
                            if (dNode7.getNameId() != 53) continue;
                            dNode7.getParentDNode().appendDChild(dNode2);
                            return dNode2;
                        }
                    }
                    DNode dNode8 = dNode3;
                    while (dNode8 != null) {
                        dNode6 = dNode8.getParentDNode();
                        if (dNode6 != null) {
                            int n5 = dNode6.getNameId();
                            if (n5 == 1) {
                                DNode dNode9 = dNode6.getParentDNode();
                                if (dNode9.getNameId() == 61) {
                                    dNode9.removeDChild(dNode6);
                                    this.nodeToAdd.appendDChild(dNode6);
                                    dNode9.appendDChild(this.nodeToAdd);
                                    return dNode8;
                                }
                            } else if (n5 == 53) {
                                if (((DElement)dNode6).getSynthetic()) {
                                    ((DElement)dNode6).setSynthetic(false);
                                } else {
                                    dNode6.removeDChild(dNode8);
                                    this.nodeToAdd.appendDChild(dNode8);
                                    dNode6.getParentDNode().appendDChild(this.nodeToAdd);
                                }
                                return dNode;
                            }
                            n2 = n5;
                        }
                        dNode8 = dNode6;
                    }
                    if (n2 != 90) {
                        dNode6 = this.doc.createElement(90);
                        ((DElement)dNode6).setAttribute("style", "margin-left: 13px");
                        dNode3.appendDChild(dNode6);
                        ((DElement)dNode6).setSynthetic(true);
                        return dNode6.appendDChild(dNode2);
                    }
                } else if (n == 53 && n2 == 53) {
                    dNode3 = dNode3.getParentDNode();
                    dNode3.appendDChild(this.nodeToAdd);
                    return dNode2;
                }
            }
            if (this.test_r(n2, n)) {
                if (this.nodeToAdd != null) {
                    dNode3.appendDChild(this.nodeToAdd);
                }
                if (HtmlDOMFixer.get_child_index(dNode2.getNameId()) != 0) {
                    return dNode2;
                }
                return dNode2.getParentDNode();
            }
            if (dNode3 == null) continue;
            int n6 = HtmlDOMFixer.getEndTagFlag(n2);
            if (n6 == 1) {
                return null;
            }
            if (n6 == 2 && this.check_required) {
                return null;
            }
            if (n == 92) {
                return null;
            }
            if ((dNode3 = dNode3.getParentDNode()) == null) continue;
            n2 = dNode3.getNameId();
        } while (dNode3 != null);
        return null;
    }

    private DNode do_trivial_add(DNode dNode, DNode dNode2, int n, int n2) {
        if (n == 41) {
            if (this.head_exists) {
                return dNode.doc.getHead();
            }
            this.head_exists = true;
        } else if (n == 86) {
            this.title_exists = true;
        } else if (n == 14 && n2 == 81) {
            this.lastBreakNode = this.nodeToAdd;
        }
        dNode.appendDChild(this.nodeToAdd);
        if (HtmlDOMFixer.get_child_index(dNode2.getNameId()) != 0) {
            return dNode2;
        }
        return dNode2.getParentDNode();
    }

    private final boolean test_r(int n, int n2) {
        int n3 = HtmlDOMFixer.get_child_index(n);
        if (n3 == 0) {
            this.checked[n] = true;
            return false;
        }
        if (HtmlDOMFixer.checkHTML4Accept(n3, n2)) {
            return true;
        }
        this.checked[n] = true;
        int n4 = HtmlDOMFixer.getSyntheticInsert(n3, -1);
        for (int i = 0; i != n4 && this.nodeToAdd != null; ++i) {
            n = HtmlDOMFixer.getSyntheticInsert(n3, i);
            if (this.checked[n] || n == 87 && this.check_required || !this.test_r(n, n2)) continue;
            if (this.nodeToAdd == null) {
                return true;
            }
            if (n == 41) {
                if (this.head_exists) {
                    DElement dElement = this.doc.getHead();
                    if (dElement != null) {
                        dElement.appendDChild(this.nodeToAdd);
                        this.nodeToAdd = null;
                    } else {
                        dElement = this.doc.createElement(n);
                        this.doc.getDocumentDElement().appendDChild(dElement);
                        dElement.setSynthetic(true);
                        dElement.appendDChild(this.nodeToAdd);
                        this.nodeToAdd = null;
                    }
                    return true;
                }
                this.head_exists = true;
            } else if (n == 13) {
                if (this.body_exists) {
                    return false;
                }
                this.body_exists = true;
            } else if (n == 43) {
                if (this.html_exists) {
                    return false;
                }
                this.html_exists = true;
            }
            DElement dElement = this.doc.createElement(n);
            dElement.setSynthetic(true);
            dElement.appendDChild(this.nodeToAdd);
            this.nodeToAdd = dElement;
            return true;
        }
        return false;
    }

    private static final boolean checkHTML4Accept(int n, int n2) {
        switch (n) {
            case 0: {
                return n2 == 93 || n2 == 94;
            }
            case 1: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 27: 
                    case 29: 
                    case 31: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 53: 
                    case 55: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 60: 
                    case 64: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 26: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 60: 
                    case 64: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 6: {
                switch (n2) {
                    case 4: 
                    case 6: 
                    case 12: 
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 49: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 79: 
                    case 90: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 8: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 9: {
                switch (n2) {
                    case 22: 
                    case 28: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 10: {
                switch (n2) {
                    case 1: 
                    case 14: 
                    case 25: 
                    case 31: 
                    case 53: 
                    case 56: 
                    case 61: 
                    case 73: 
                    case 79: 
                    case 90: 
                    case 92: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 12: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 29: 
                    case 31: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 55: 
                    case 60: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                switch (n2) {
                    case 62: 
                    case 63: 
                    case 70: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 14: {
                return n2 == 63 || n2 == 93 || n2 == 94;
            }
            case 15: {
                return n2 == 92 || n2 == 93 || n2 == 94;
            }
            case 16: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 17: {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 31: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 46: 
                    case 50: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
            case 18: {
                switch (n2) {
                    case 16: 
                    case 20: 
                    case 21: 
                    case 70: 
                    case 80: 
                    case 83: 
                    case 85: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 19: {
                switch (n2) {
                    case 59: 
                    case 70: 
                    case 76: 
                    case 87: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 20: {
                return n2 == 20 || n2 == 93 || n2 == 94;
            }
            case 21: {
                switch (n2) {
                    case 70: 
                    case 76: 
                    case 81: 
                    case 84: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 22: {
                switch (n2) {
                    case 8: 
                    case 49: 
                    case 54: 
                    case 57: 
                    case 60: 
                    case 70: 
                    case 76: 
                    case 86: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 23: {
                return n2 == 92 || n2 == 93 || n2 == 94;
            }
            case 24: {
                switch (n2) {
                    case 13: 
                    case 34: 
                    case 41: 
                    case 58: 
                    case 70: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 25: {
                switch (n2) {
                    case 33: 
                    case 34: 
                    case 58: 
                    case 93: 
                    case 94: {
                        return true;
                    }
                }
                return false;
            }
            case 26: {
                return n2 == 43 || n2 == 93 || n2 == 94;
            }
            case 27: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 55: 
                    case 56: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 64: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return true;
                    }
                }
                return false;
            }
        }
        Defs.badArg();
        return false;
    }

    private static int getSyntheticInsert(int n, int n2) {
        switch (n) {
            case 9: {
                return n2 < 0 ? 1 : 28;
            }
            case 18: {
                return n2 < 0 ? 1 : 80;
            }
            case 19: {
                return n2 < 0 ? 1 : 87;
            }
            case 24: {
                return n2 < 0 ? 2 : (n2 == 0 ? 13 : 41);
            }
            case 26: {
                return n2 < 0 ? 1 : 43;
            }
            case 27: {
                return n2 < 0 ? 1 : 13;
            }
        }
        return 0;
    }

    private static int get_child_index(int n) {
        switch (n) {
            case 0: {
                return 26;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 4;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 17;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 4;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 1;
            }
            case 20: {
                return 0;
            }
            case 21: {
                return 20;
            }
            case 22: {
                return 4;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return 10;
            }
            case 26: {
                return 4;
            }
            case 27: {
                return 9;
            }
            case 28: {
                return 1;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 16;
            }
            case 31: {
                return 1;
            }
            case 32: {
                return 11;
            }
            case 33: {
                return 0;
            }
            case 34: {
                return 25;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 1;
            }
            case 37: {
                return 1;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 1;
            }
            case 40: {
                return 1;
            }
            case 41: {
                return 22;
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 24;
            }
            case 44: {
                return 1;
            }
            case 45: {
                return 4;
            }
            case 46: {
                return 0;
            }
            case 47: {
                return 0;
            }
            case 48: {
                return 4;
            }
            case 49: {
                return 0;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 12;
            }
            case 52: {
                return 1;
            }
            case 53: {
                return 4;
            }
            case 54: {
                return 0;
            }
            case 55: {
                return 6;
            }
            case 56: {
                return 10;
            }
            case 57: {
                return 0;
            }
            case 58: {
                return 27;
            }
            case 59: {
                return 24;
            }
            case 60: {
                return 7;
            }
            case 61: {
                return 10;
            }
            case 62: {
                return 14;
            }
            case 63: {
                return 15;
            }
            case 64: {
                return 1;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 8;
            }
            case 67: {
                return 1;
            }
            case 68: {
                return 1;
            }
            case 69: {
                return 1;
            }
            case 70: {
                return 23;
            }
            case 71: {
                return 13;
            }
            case 72: {
                return 1;
            }
            case 73: {
                return 1;
            }
            case 74: {
                return 1;
            }
            case 75: {
                return 1;
            }
            case 76: {
                return 23;
            }
            case 77: {
                return 1;
            }
            case 78: {
                return 1;
            }
            case 79: {
                return 18;
            }
            case 80: {
                return 19;
            }
            case 81: {
                return 4;
            }
            case 82: {
                return 15;
            }
            case 83: {
                return 19;
            }
            case 84: {
                return 4;
            }
            case 85: {
                return 19;
            }
            case 86: {
                return 15;
            }
            case 87: {
                return 21;
            }
            case 88: {
                return 1;
            }
            case 89: {
                return 1;
            }
            case 90: {
                return 10;
            }
            case 91: {
                return 1;
            }
            case 92: {
                return 0;
            }
            case 93: {
                return 23;
            }
            case 94: {
                return 23;
            }
            case 95: {
                return 1;
            }
        }
        Defs.badArg();
        return 0;
    }

    private static int getEndTagFlag(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 0;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 0;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 0;
            }
            case 21: {
                return 0;
            }
            case 22: {
                return 0;
            }
            case 23: {
                return 1;
            }
            case 24: {
                return 1;
            }
            case 25: {
                return 2;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 2;
            }
            case 28: {
                return 0;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 1;
            }
            case 31: {
                return 2;
            }
            case 32: {
                return 2;
            }
            case 33: {
                return 0;
            }
            case 34: {
                return 1;
            }
            case 35: {
                return 2;
            }
            case 36: {
                return 2;
            }
            case 37: {
                return 2;
            }
            case 38: {
                return 2;
            }
            case 39: {
                return 2;
            }
            case 40: {
                return 2;
            }
            case 41: {
                return 0;
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 0;
            }
            case 44: {
                return 2;
            }
            case 45: {
                return 2;
            }
            case 46: {
                return 0;
            }
            case 47: {
                return 0;
            }
            case 48: {
                return 1;
            }
            case 49: {
                return 0;
            }
            case 50: {
                return 1;
            }
            case 51: {
                return 1;
            }
            case 52: {
                return 1;
            }
            case 53: {
                return 0;
            }
            case 54: {
                return 0;
            }
            case 55: {
                return 2;
            }
            case 56: {
                return 1;
            }
            case 57: {
                return 0;
            }
            case 58: {
                return 1;
            }
            case 59: {
                return 1;
            }
            case 60: {
                return 1;
            }
            case 61: {
                return 2;
            }
            case 62: {
                return 1;
            }
            case 63: {
                return 0;
            }
            case 64: {
                return 0;
            }
            case 65: {
                return 0;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 1;
            }
            case 68: {
                return 1;
            }
            case 69: {
                return 1;
            }
            case 70: {
                return 1;
            }
            case 71: {
                return 1;
            }
            case 72: {
                return 2;
            }
            case 73: {
                return 2;
            }
            case 74: {
                return 1;
            }
            case 75: {
                return 2;
            }
            case 76: {
                return 1;
            }
            case 77: {
                return 1;
            }
            case 78: {
                return 1;
            }
            case 79: {
                return 1;
            }
            case 80: {
                return 0;
            }
            case 81: {
                return 0;
            }
            case 82: {
                return 1;
            }
            case 83: {
                return 0;
            }
            case 84: {
                return 0;
            }
            case 85: {
                return 0;
            }
            case 86: {
                return 1;
            }
            case 87: {
                return 0;
            }
            case 88: {
                return 2;
            }
            case 89: {
                return 2;
            }
            case 90: {
                return 2;
            }
            case 91: {
                return 2;
            }
            case 92: {
                return 0;
            }
            case 93: {
                return 1;
            }
            case 94: {
                return 1;
            }
            case 95: {
                return 2;
            }
        }
        Defs.badArg();
        return 0;
    }
}

