/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.TextBox;
import java.awt.FontMetrics;

class BreakBox
extends CSSBox {
    private boolean tall = false;
    private int _descent;
    private int _ascent;
    private int _lineHeight;

    BreakBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout) {
        super(dElement, cSSAttribs, cSSLayout);
        this.numBreaks = 1;
        this.totalWidth = 1;
        FontMetrics fontMetrics = cSSAttribs.getFontMetrics();
        this._descent = fontMetrics.getDescent();
        this._ascent = fontMetrics.getAscent();
        long l = TextBox.calculateCompressedFontSize(this._ascent, this._descent, cSSAttribs);
        this._descent = BreakBox.unwrapDescent(l);
        this._ascent = BreakBox.unwrapAscent(l);
        this._lineHeight = TextBox.calculateLineHeight(cSSAttribs);
    }

    void dispose() {
        super.dispose();
        this.element = null;
    }

    DNode getDomNode() {
        return this.element;
    }

    int calcBreaks() {
        return 1;
    }

    int getBreaks(int[] nArray, int n) {
        this.tall = false;
        if (n == 0) {
            if (this.parentBox instanceof BlockBox) {
                DNode dNode = this.parentBox.getDomNode();
                if (dNode == null || dNode.getNameId() != 14) {
                    this.tall = true;
                }
            } else if (this.parentBox instanceof InlineBox) {
                if (((InlineBox)this.parentBox).first == this) {
                    this.tall = true;
                }
            } else {
                this.tall = true;
            }
        } else if (nArray[n - 1] < 0) {
            this.tall = true;
        }
        nArray[n] = -1;
        return 1;
    }

    long getChunkDescentAscent(int n, int n2, LineBox lineBox) {
        if (this.tall) {
            return BreakBox.wrapDescentAscent(this._descent, this._ascent, this._lineHeight);
        }
        return 0L;
    }
}

