/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.truthtable;

import com.mathworks.toolbox.dastudio.truthtable.RowHeaderRenderer;
import com.mathworks.toolbox.dastudio.truthtable.TextAreaEditor;
import com.mathworks.toolbox.dastudio.truthtable.TextAreaRenderer;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ActionTableModel
extends AbstractTableModel {
    private int _numRows;
    private static final int _numCols = 4;
    private Hashtable _data;
    private TableColumnModel _columnModel;
    private DefaultTableCellRenderer _defaultRenderer;
    private DefaultCellEditor _defaultEditor;

    public ActionTableModel(String[][] stringArray) {
        this._numRows = stringArray.length;
        this._data = new Hashtable();
        for (int i = 0; i < this._numRows; ++i) {
            for (int j = 1; j < 4; ++j) {
                this.setValueAt(stringArray[i][j - 1], i, j);
            }
        }
        this.initializeTableModel();
    }

    public ActionTableModel(int n) {
        this._numRows = n >= 1 ? n : 1;
        this._data = new Hashtable();
        this.initializeTableModel();
    }

    public ActionTableModel() {
        this._numRows = 1;
        this._data = new Hashtable();
        this.initializeTableModel();
    }

    private void initializeTableModel() {
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        TextAreaEditor textAreaEditor = new TextAreaEditor();
        this._columnModel = new DefaultTableColumnModel();
        this._defaultRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
        };
        this._defaultEditor = new DefaultCellEditor(new JTextField());
        TableColumn tableColumn = new TableColumn(0, 30, new RowHeaderRenderer(), null);
        tableColumn.setHeaderValue(" ");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 160, textAreaRenderer, textAreaEditor);
        tableColumn.setHeaderValue("Action Description");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 80, this._defaultRenderer, this._defaultEditor);
        tableColumn.setHeaderValue("Label");
        this._columnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 240, textAreaRenderer, textAreaEditor);
        tableColumn.setHeaderValue("Action Code");
        this._columnModel.addColumn(tableColumn);
        this.updateRowHeaderIndex(0);
    }

    public TableColumnModel getColumnModel() {
        return this._columnModel;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this._numRows;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 4) {
            System.out.println("Warning: getColumnName(idx), idx exceeds the max column index.");
            return null;
        }
        return (String)this._columnModel.getColumn(n).getHeaderValue();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._data.get(this.getHashKey(n, n2));
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            this._data.remove(this.getHashKey(n, n2));
            return;
        }
        String string = ((String)object).trim();
        if (string.length() > 0) {
            this._data.put(this.getHashKey(n, n2), string);
        } else {
            this._data.remove(this.getHashKey(n, n2));
        }
    }

    private Object getHashKey(int n, int n2) {
        return new String(n + "," + n2);
    }

    private void updateRowHeaderIndex(int n) {
        for (int i = n; i < this._numRows; ++i) {
            this._data.put(this.getHashKey(i, 0), String.valueOf(i + 1));
        }
    }

    public void deleteRow(int n) {
        if (n >= this._numRows) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this._data.remove(this.getHashKey(n, i));
            for (int j = n + 1; j < this._numRows; ++j) {
                Object v = this._data.remove(this.getHashKey(j, i));
                if (v == null) continue;
                this._data.put(this.getHashKey(j - 1, i), v);
            }
        }
        --this._numRows;
        this.updateRowHeaderIndex(n);
        this.fireTableRowsDeleted(this._numRows, this._numRows);
    }

    public void addRow() {
        ++this._numRows;
        this.updateRowHeaderIndex(this._numRows - 1);
        this.fireTableRowsInserted(this._numRows - 1, this._numRows - 1);
    }

    public void addRow(int n) {
        if (n >= this._numRows || n < 0) {
            return;
        }
        for (int i = 1; i < 4; ++i) {
            for (int j = this._numRows; j > n; --j) {
                Object v = this._data.remove(this.getHashKey(j - 1, i));
                if (v == null) continue;
                this._data.put(this.getHashKey(j, i), v);
            }
        }
        ++this._numRows;
        this.updateRowHeaderIndex(n);
        this.fireTableRowsInserted(n, n);
    }

    public void switchRow(int n, int n2) {
        if (n == n2 || n < 0 || n2 < 0 || n >= this._numRows || n2 >= this._numRows) {
            return;
        }
        for (int i = 1; i < 4; ++i) {
            Object object = this.getHashKey(n, i);
            Object object2 = this.getHashKey(n2, i);
            Object v = this._data.remove(object);
            Object v2 = this._data.remove(object2);
            if (v != null) {
                this._data.put(object2, v);
            }
            if (v2 == null) continue;
            this._data.put(object, v2);
        }
        this.fireTableRowsUpdated(n, n);
        this.fireTableRowsUpdated(n2, n2);
    }

    public Vector getRowData(int n) {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 1; i < 4; ++i) {
            vector.addElement(this.getValueAt(n, i));
        }
        return vector;
    }

    public void setRow(Vector vector, int n) {
        for (int i = 0; i < 3; ++i) {
            Object e = vector.elementAt(i);
            if (e != null) {
                this.setValueAt(new String((String)e), n, i + 1);
                continue;
            }
            this.setValueAt(null, n, i + 1);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public String[][] getStringArray() {
        int n = this.getValidRowCount();
        String[][] stringArray = new String[n][4];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                stringArray[i][j] = (String)this.getValueAt(i, j + 1);
            }
        }
        return stringArray;
    }

    private int getValidRowCount() {
        int n = 0;
        for (int i = this._numRows - 1; i >= 0; --i) {
            boolean bl = false;
            for (int j = 1; j < 4; ++j) {
                if (this.getValueAt(i, j) == null) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public void makeCompact() {
        int n = this.getValidRowCount();
        for (int i = this._numRows - 1; i > n - 1; --i) {
            this.deleteRow(i);
        }
    }
}

