/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.EmulatorConnection;
import com.intel.bluetooth.EmulatorLocalDevice;
import java.io.IOException;
import javax.bluetooth.BluetoothConnectionException;

abstract class EmulatorLinkedConnection
extends EmulatorConnection {
    protected long remoteAddress;

    EmulatorLinkedConnection(EmulatorLocalDevice localDevice, long handle) {
        super(localDevice, handle);
    }

    void connectVerify(BluetoothConnectionParams params) throws IOException {
        if (params.address == this.localDevice.getAddress()) {
            throw new BluetoothConnectionException(4, "Can't connect to local device");
        }
        if (params.encrypt && !this.localDevice.getConfiguration().isLinkEncryptionSupported()) {
            throw new BluetoothConnectionException(2, "encrypt mode not supported");
        }
    }

    void connect(long remoteAddress, long connectionHandle) throws IOException {
        this.connectionHandle = connectionHandle;
        this.remoteAddress = remoteAddress;
    }

    int getSecurityOpt(int expected) throws IOException {
        return this.localDevice.getDeviceManagerService().getSecurityOpt(this.localDevice.getAddress(), this.connectionHandle, expected);
    }

    boolean encrypt(long address, boolean on) throws IOException {
        return this.localDevice.getDeviceManagerService().encrypt(this.localDevice.getAddress(), this.connectionHandle, address, on);
    }

    long getRemoteAddress() throws IOException {
        return this.remoteAddress;
    }

    void close() throws IOException {
        this.localDevice.getDeviceManagerService().closeConnection(this.localDevice.getAddress(), this.connectionHandle);
    }
}

