/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.EmulatorCommandReceiver;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.emu.DeviceDescriptor;
import com.intel.bluetooth.emu.DeviceManagerService;
import com.intel.bluetooth.rmi.Client;
import java.util.HashMap;
import java.util.Map;
import javax.bluetooth.BluetoothStateException;

class EmulatorHelper {
    private static Map<EmulatorLocalDevice, EmulatorCommandReceiver> receivers = new HashMap<EmulatorLocalDevice, EmulatorCommandReceiver>();

    EmulatorHelper() {
    }

    static DeviceManagerService getService() {
        String host = BlueCoveImpl.getConfigProperty((String)"bluecove.emu.rmiRegistryHost");
        String port = BlueCoveImpl.getConfigProperty((String)"bluecove.emu.rmiRegistryPort");
        boolean isMaster = BlueCoveImpl.getConfigProperty((String)"bluecove.emu.rmiRegistry", (boolean)false);
        return (DeviceManagerService)Client.getService(DeviceManagerService.class, isMaster, host, port);
    }

    static EmulatorLocalDevice createNewLocalDevice() throws BluetoothStateException {
        DeviceDescriptor deviceDescriptor;
        DeviceManagerService service;
        try {
            service = EmulatorHelper.getService();
            deviceDescriptor = service.createNewDevice(BlueCoveImpl.getConfigProperty((String)"bluecove.deviceID"), BlueCoveImpl.getConfigProperty((String)"bluecove.deviceAddress"));
        }
        catch (RuntimeException e) {
            throw (BluetoothStateException)UtilsJavaSE.initCause((Throwable)new BluetoothStateException(e.getMessage()), (Throwable)e);
        }
        EmulatorLocalDevice device = new EmulatorLocalDevice(service, deviceDescriptor);
        EmulatorCommandReceiver receiver = new EmulatorCommandReceiver(device);
        receivers.put(device, receiver);
        receiver.setDaemon(true);
        receiver.start();
        return device;
    }

    static void releaseDevice(EmulatorLocalDevice device) {
        EmulatorCommandReceiver receiver = receivers.remove(device);
        if (receiver != null) {
            receiver.shutdownReceiver();
        }
        device.getDeviceManagerService().releaseDevice(device.getAddress());
        device.destroy();
    }
}

