/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.crypto.DHKeyAgreement;
import ice.crypto.DHKeyPairGenerator;
import ice.crypto.DHParameterSpec;
import ice.crypto.DHPublicKey;
import ice.crypto.RSAPublicKey;
import ice.debug.Debug;
import ice.ssl.ClientHandshake;
import ice.ssl.ConnectionState;
import ice.ssl.HandshakeState;
import ice.ssl.SSLSocket;
import ice.ssl.SessionState;
import ice.ssl.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

final class ClientKeyExchange
extends ClientHandshake {
    private HandshakeState I;

    ClientKeyExchange(SessionState sessionState, ConnectionState connectionState, HandshakeState handshakeState) {
        super(16, sessionState, connectionState);
        this.I = handshakeState;
        if (handshakeState.keyExchange == 1 || handshakeState.keyExchange == 1) {
            this.length = (((RSAPublicKey)sessionState.serverPublicKey).getModulus().bitLength() - 1) / 8 + 1;
        } else if ((handshakeState.keyExchange == 7 || handshakeState.keyExchange == 6 || handshakeState.keyExchange == 9 || handshakeState.keyExchange == 8) && Debug.trace) {
            Debug.trace((String)"WARNING: I don't know how to calculate the length field !");
        }
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray2;
        block19: {
            Object object;
            block14: {
                Serializable serializable;
                Object object2;
                block20: {
                    block18: {
                        block17: {
                            block15: {
                                block16: {
                                    byArray2 = new byte[]{};
                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                    byArray = null;
                                    byteArrayOutputStream.write(super.toByteArray());
                                    if (this.I.clientCertificate == null) break block15;
                                    if (this.I.keyExchange == 3) break block16;
                                    if (this.I.keyExchange == 2) break block16;
                                    if (this.I.keyExchange == 5) break block16;
                                    if (this.I.keyExchange != 4) break block15;
                                }
                                object2 = (DHPublicKey)this.I.clientCertificate.getPublicKey();
                                serializable = (DHPublicKey)this.sesState.serverPublicKey;
                                object = ((DHPublicKey)object2).getParams();
                                DHParameterSpec dHParameterSpec = ((DHPublicKey)serializable).getParams();
                                if (((DHParameterSpec)object).getL() == dHParameterSpec.getL() && ((DHParameterSpec)object).getP().equals(dHParameterSpec.getP()) && ((DHParameterSpec)object).getG().equals(dHParameterSpec.getG())) {
                                    DHKeyAgreement dHKeyAgreement;
                                    block13: {
                                        dHKeyAgreement = new DHKeyAgreement();
                                        try {
                                            PrivateKey privateKey = SSLSocket.getCertificateCallback().supplyPrivateKey(this.I.clientCertificate);
                                            dHKeyAgreement.engineInit(privateKey, Util.getSecureRandom());
                                            dHKeyAgreement.engineDoPhase((Key)serializable, true);
                                        }
                                        catch (InvalidKeyException invalidKeyException) {
                                            if (Debug.ex) {
                                                Debug.ex((Throwable)invalidKeyException);
                                            }
                                            if (!Debug.trace) break block13;
                                            Debug.trace((String)"WARNING: Invalid Key in DH key agreement");
                                        }
                                    }
                                    byArray = dHKeyAgreement.engineGenerateSecret();
                                }
                            }
                            if (this.I.keyExchange == 1) break block17;
                            if (this.I.keyExchange != 1) break block18;
                        }
                        byArray = new byte[48];
                        byArray[0] = (byte)Util.majorVersion(this.sesState.nowProto);
                        byArray[1] = (byte)Util.minorVersion(this.sesState.nowProto);
                        Util.secureRandom(byArray, 2, 46);
                        object2 = Util.encryptRSAPKCS1(byArray, this.sesState.serverPublicKey);
                        byteArrayOutputStream.write((byte[])object2);
                        break block19;
                    }
                    if (byArray != null) break block19;
                    if (this.I.keyExchange == 7) break block20;
                    if (this.I.keyExchange == 6) break block20;
                    if (this.I.keyExchange == 9) break block20;
                    if (this.I.keyExchange == 8) break block20;
                    if (this.I.keyExchange == 3) break block20;
                    if (this.I.keyExchange == 2) break block20;
                    if (this.I.keyExchange == 5) break block20;
                    if (this.I.keyExchange != 4) break block19;
                }
                object2 = null;
                try {
                    object2 = KeyPairGenerator.getInstance("DH");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SecurityException("Key agreement algorithm DH not found");
                }
                ((DHKeyPairGenerator)object2).init(((DHPublicKey)this.sesState.serverPublicKey).getParams());
                serializable = ((KeyPairGenerator)object2).generateKeyPair();
                byteArrayOutputStream.write(((DHPublicKey)((KeyPair)serializable).getPublic()).getY().toByteArray());
                object = new DHKeyAgreement();
                try {
                    ((DHKeyAgreement)object).engineInit(((KeyPair)serializable).getPrivate(), Util.getSecureRandom());
                    ((DHKeyAgreement)object).engineDoPhase(this.sesState.serverPublicKey, true);
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)invalidKeyException);
                    }
                    if (!Debug.trace) break block14;
                    Debug.trace((String)"WARNING: Invalid Key in DH key agreement");
                }
            }
            byArray = ((DHKeyAgreement)object).engineGenerateSecret();
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        this.I(byArray);
        return byArray2;
    }

    private void I(byte[] byArray) {
        if (this.sesState.nowProto != 2) {
            this.sesState.masterSecret = Util.prf(48, byArray, "master secret", Util.concat(this.conState.clientRandom, this.conState.serverRandom));
        } else {
            MessageDigest messageDigest = null;
            MessageDigest messageDigest2 = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
                messageDigest2 = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityException("Algorithm not found : " + (messageDigest == null ? "MD5" : "SHA") + " digest");
            }
            byte[][] byArrayArray = new byte[][]{{65}, {66, 66}, {67, 67, 67}};
            int n = 0;
            while (n < 3) {
                messageDigest2.reset();
                messageDigest2.update(byArrayArray[n]);
                messageDigest2.update(byArray);
                messageDigest2.update(this.conState.clientRandom);
                messageDigest2.update(this.conState.serverRandom);
                byte[] byArray2 = messageDigest2.digest();
                messageDigest.reset();
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = messageDigest.digest();
                System.arraycopy(byArray3, 0, this.sesState.masterSecret, n * 16, 16);
                ++n;
            }
        }
    }
}

