/*
 * Decompiled with CFR 0.152.
 */
package ice.crypto;

import ice.crypto.DHParameterSpec;
import java.math.BigInteger;
import java.security.PublicKey;

public class DHPublicKey
implements PublicKey {
    DHParameterSpec parameters;
    BigInteger y;

    public DHPublicKey(BigInteger y, DHParameterSpec parameters) {
        this.parameters = parameters;
        this.y = y;
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        return this.parameters;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        int offset = 0;
        byte[] encoded = new byte[this.y.toByteArray().length + this.parameters.getG().toByteArray().length + this.parameters.getP().toByteArray().length + 4];
        System.arraycopy(this.y.toByteArray(), 0, encoded, offset, this.y.toByteArray().length);
        System.arraycopy(this.parameters.getG().toByteArray(), 0, encoded, offset += this.y.toByteArray().length, this.parameters.getG().toByteArray().length);
        System.arraycopy(this.parameters.getP().toByteArray(), 0, encoded, offset += this.parameters.getG().toByteArray().length, this.parameters.getP().toByteArray().length);
        offset += this.parameters.getP().toByteArray().length;
        int i = 0;
        while (i < 4) {
            encoded[i + offset] = (byte)(this.parameters.getL() >>> 8 * i);
            ++i;
        }
        return encoded;
    }

    public String getFormat() {
        return "raw";
    }
}

