/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.product.dao;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.Logger;

final class DaoPluginFactory {
    private static final Logger log = Logger.getLogger("com.mathworks.product.dao.DaoPluginFactory");
    private static final String SYSTEM_PROPERTY_PROPERTY_FILE_KEY = "com.mathworks.product.dao.DaoPluginFactory";
    private static final String IFACE_PREF_ID = "com.mathworks.product.dao.DaoFactory";
    private static final Properties props = new Properties();

    static Properties getProperties() {
        return props;
    }

    public static Object getPlugin() {
        String string = props.getProperty(IFACE_PREF_ID);
        if (string == null) {
            throw new RuntimeException("implemenation not specified for com.mathworks.product.dao.DaoFactory in DaoPluginFactory");
        }
        try {
            Object obj = Class.forName(string).newInstance();
            log.info("Custom DaoFactory instantiated: " + obj);
            return obj;
        }
        catch (Exception exception) {
            throw new RuntimeException(" factory unable to construct instance of com.mathworks.product.dao.DaoFactory", exception);
        }
    }

    public static boolean checkPrefSet() {
        boolean bl = false;
        String string = props.getProperty(IFACE_PREF_ID);
        if (string != null && string.length() > 0) {
            bl = true;
        }
        log.fine("DaoPluginFactory preference valid?: " + bl);
        return bl;
    }

    private DaoPluginFactory() {
    }

    static {
        try {
            String string = System.getProperty(SYSTEM_PROPERTY_PROPERTY_FILE_KEY);
            props.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            log.fine("error retrieving system property 'com.mathworks.product.dao.DaoPluginFactory'");
        }
    }
}

