/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;

public class OpenGLUtils {
    private MyFrame fFrame = null;
    private boolean fResultReady = false;
    private Data fData = null;
    private boolean fGLValid = false;
    private boolean fGetDataObject = false;
    private boolean fNeverMind = false;

    public static OpenGLUtils requestGLData() {
        return new OpenGLUtils(true);
    }

    public static OpenGLUtils requestGLValid() {
        return new OpenGLUtils(false);
    }

    public boolean isResultReady() {
        return this.fResultReady;
    }

    public Data getGLData() {
        return this.fData;
    }

    public boolean getGLValid() {
        return this.fGLValid;
    }

    public void cleanup() {
        this.fNeverMind = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OpenGLUtils.this.fFrame != null) {
                    OpenGLUtils.this.fFrame.setVisible(false);
                    OpenGLUtils.this.fFrame.dispose();
                    OpenGLUtils.this.fFrame = null;
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private OpenGLUtils(boolean bl) {
        this.fGetDataObject = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!OpenGLUtils.this.fNeverMind) {
                    OpenGLUtils.this.fFrame = new MyFrame();
                    OpenGLUtils.this.fFrame.setVisible(true);
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private class MyFrame
    extends Frame
    implements GLEventListener {
        MyFrame() {
            this.setSize(2, 2);
            this.setUndecorated(true);
            this.setResizable(false);
            GLCanvas gLCanvas = new GLCanvas();
            this.add((Component)gLCanvas);
            gLCanvas.addGLEventListener((GLEventListener)this);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            if (OpenGLUtils.this.fGetDataObject) {
                Data data = new Data();
                if (gL != null) {
                    data.version = gL.glGetString(7938);
                    data.vendor = gL.glGetString(7936);
                    data.renderer = gL.glGetString(7937);
                    int[] nArray = new int[1];
                    gL.glGetIntegerv(3379, nArray, 0);
                    data.textureSize = nArray[0];
                    data.visual = "";
                    data.software = "";
                    String string = gL.glGetString(7939);
                    data.extensions = string.split(" ");
                    OpenGLUtils.this.fData = data;
                    int[] nArray2 = new int[1];
                    gL.glGetIntegerv(34024, nArray2, 0);
                    data.frameBufferSize = nArray2[0];
                }
            } else {
                OpenGLUtils.this.fGLValid = gL.glGetString(7938) != null;
            }
            OpenGLUtils.this.fResultReady = true;
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
        }
    }

    public static class Data {
        public String version;
        public String vendor;
        public String renderer;
        public double textureSize;
        public String visual;
        public String software;
        public String[] extensions;
        public double frameBufferSize;
    }
}

