/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.format;

import com.jgoodies.forms.factories.Borders;
import com.jidesoft.dialog.AbstractDialogPage;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractFormatPanel
extends AbstractDialogPage {
    public static final ResourceBundle FORMAT_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.format.resources.RES_TableFormat");
    private FormatTypeEnum formatType;

    public AbstractFormatPanel(FormatTypeEnum formatTypeEnum) {
        super(formatTypeEnum.getShortDescription(), formatTypeEnum.getLongDescription());
        this.formatType = formatTypeEnum;
    }

    public void lazyInitialize() {
        this.initComponents();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent jComponent = AbstractFormatPanel.this.getFocusTarget();
                if (jComponent != null) {
                    jComponent.requestFocusInWindow();
                }
            }
        });
    }

    public void initComponents() {
        this.buildPanel();
    }

    public FormatTypeEnum getFormatType() {
        return this.formatType;
    }

    public void cleanup() {
    }

    public JComponent getFocusTarget() {
        return null;
    }

    protected String getResourceString(String string) {
        try {
            return FORMAT_RESOURCES.getString(string);
        }
        catch (Exception exception) {
            System.out.println("Resource " + string + " is missing from the table format resource file.");
            return "";
        }
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.buildTitlePanel(this.formatType.getShortDescription());
        if (jPanel != null) {
            this.add(jPanel, "North");
        }
        JPanel jPanel2 = this.buildFormatPanel();
        this.add(jPanel2, "Center");
    }

    protected JPanel buildTitlePanel(String string) {
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        mJLabel.setBorder(Borders.createEmptyBorder((String)"0dlu, 4dlu, 0dlu, 4dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(3));
        mJPanel.add((Component)mJLabel);
        mJPanel.setBackground(ColorUtils.getDarkenedHeadingBackground((JComponent)mJPanel));
        mJPanel.setForeground(ColorUtils.getDarkenedHeadingForeground((JComponent)mJPanel));
        return mJPanel;
    }

    protected abstract JPanel buildFormatPanel();

    protected abstract String getFormat();

    protected abstract boolean isValidFormat();
}

