/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.jmi.types.MLArrayRef;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class HGCallback {
    private volatile MLArrayRef fCallbackObject;
    private final String fCallback;
    private static final String sAutoCallbackSignature = ",hObject,eventdata,guidata(hObject)";
    private static final String sAutoCallbackHeader = "@(hObject,eventdata)";
    private static int sDisplayFormat = 0;

    private HGCallback(String string, MLArrayRef mLArrayRef) {
        this.fCallback = string;
        this.fCallbackObject = mLArrayRef;
    }

    public static void setDisplayFormat(int n) {
        sDisplayFormat = n;
    }

    String getCallbackString(boolean bl) {
        String string = "";
        if (sDisplayFormat == 0) {
            if (this.getCallbackObject() != null) {
                if (this.getCallbackObject().isChar()) {
                    string = this.getCallback();
                } else if (this.isAutoGeneratedCallback()) {
                    if (bl) {
                        string = this.getCallback();
                        int n = string.replaceAll(" ", "").indexOf(sAutoCallbackHeader);
                        if (n == 0) {
                            string = string.replaceAll(" ", "").substring(n + sAutoCallbackHeader.length());
                        }
                    } else {
                        string = this.getCallbackObject().toString() + " " + this.getCallback();
                    }
                } else {
                    string = this.getCallbackObject().toString();
                }
            }
        } else {
            string = this.getCallback();
        }
        return string;
    }

    public String getCallback() {
        return this.fCallback;
    }

    public MLArrayRef getCallbackObject() {
        return this.fCallbackObject;
    }

    public void setCallbackObject(MLArrayRef mLArrayRef) {
        this.fCallbackObject = mLArrayRef;
    }

    public boolean isAutoGeneratedCallback() {
        return HGCallback.isAutoGeneratedCallback(this.fCallback);
    }

    private static boolean isAutoGeneratedCallback(String string) {
        return string != null && string.replaceAll(" ", "").contains(sAutoCallbackSignature);
    }

    public static String presetCallbackString(String string) {
        if (HGCallback.isAutoGeneratedCallback(string) && string.replaceAll(" ", "").indexOf("@") != 0) {
            return sAutoCallbackHeader + string.trim();
        }
        return "'" + string.replaceAll("'", "''") + "'";
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("callback", (Object)this.fCallback).append("callbackObject", (Object)this.fCallbackObject).toString();
    }
}

