/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.TabBackgroundColorChangedNotification;
import com.mathworks.hg.peer.TabEnableChangedNotification;
import com.mathworks.hg.peer.TabForegroundColorChangedNotification;
import com.mathworks.hg.peer.TabTitleChangedNotification;
import com.mathworks.hg.peer.TabTooltipChangedNotification;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.ui.AbstractUIContainerPeer;
import com.mathworks.hg.peer.ui.AbstractUIGroupPeer;
import com.mathworks.hg.peer.ui.TabGroupChild;
import com.mathworks.hg.peer.ui.event.UITabGroupSelectionChangeEvent;
import com.mathworks.hg.peer.ui.event.UITabGroupSelectionChangeListener;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UITabGroupPeer
extends AbstractUIContainerPeer
implements UIComponentParentWithLayout {
    private static final int sFirstMethodIndex = AbstractUIGroupPeer.getLastMethodIndex();
    private static final int sSetTabLocation = sFirstMethodIndex + 1;
    private static final int sSetSelected = sFirstMethodIndex + 2;
    private JTabbedPane fTabgroup = null;
    private FigureNotificationHandlerImpl fNotificationHandler;
    private boolean fSuppressStateChangeEventsEDT;
    private Container fParentContainer;
    private MJPanel fLightPanel;
    private boolean fDisposed = false;

    public UITabGroupPeer() {
        if (this.fTabgroup == null) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UITabGroupPeer.this.createTabbedPane();
                    }
                });
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.fDisposed;
    }

    static Color getDefaultTabBackground() {
        Color color = (Color)UIManager.get("TabbedPane.tabAreaBackground");
        if (color == null) {
            return new MJTabbedPane().getBackground();
        }
        return color;
    }

    static Color getDefaultTabForeground() {
        Color color = (Color)UIManager.get("TabbedPane.foreground");
        if (color == null) {
            return new MJTabbedPane().getForeground();
        }
        return color;
    }

    @Override
    protected Component getTopLevelComponent() {
        assert (this.fTabgroup != null);
        if (this.fParentContainer == null) {
            this.createPeerComponent();
        }
        return this.fParentContainer;
    }

    @Override
    protected void createPeerComponentImpl() {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    UITabGroupPeer.this.doInitializeTabgroup();
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        this.fDisposed = false;
    }

    private void doInitializeTabgroup() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call doInitializeTabgroup on the EDT.";
        assert (this.fLightPanel == null);
        this.fLightPanel = new MJPanel();
        this.fLightPanel.setLayout((LayoutManager)new BorderLayout());
        this.fLightPanel.add((Component)this.getUIComponent());
        this.fParentContainer = HeavyweightLightweightContainerFactory.getUIComponentContainer(PlatformInfo.isMacintosh());
        this.fParentContainer.setLayout(new BorderLayout());
        this.fParentContainer.add((Component)this.fLightPanel);
    }

    @Override
    protected JComponent getUIComponent() {
        assert (this.fTabgroup != null);
        return this.fTabgroup;
    }

    @Override
    public void addComponent(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        this.setNotificationSuccessor(uIComponentParentWithLayout);
        super.addComponent(uIComponentParentWithLayout, n);
    }

    @Override
    public void removeComponent(UIComponentParentWithLayout uIComponentParentWithLayout) {
        this.setNotificationSuccessor(null);
        super.removeComponent(uIComponentParentWithLayout);
    }

    private void addTab(String string, Icon icon, Component component, String string2) {
        assert (EventQueue.isDispatchThread());
        assert (this.fTabgroup != null);
        ((JTabbedPane)this.getUIComponent()).addTab(string, icon, component, string2);
    }

    private void removeTab(Component component) {
        assert (EventQueue.isDispatchThread());
        assert (this.getUIComponent() != null);
        this.getUIComponent().remove(component);
    }

    public void updateUI() {
        if (this.fTabgroup != null) {
            this.fTabgroup.invalidate();
        }
        if (this.fParentContainer != null) {
            this.fParentContainer.repaint();
        }
    }

    public void setTabLocation(final int n) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetTabLocation){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetTabLocation(n);
                UITabGroupPeer.this.updateUI();
            }
        });
    }

    protected void doSetTabLocation(int n) {
        assert (this.fTabgroup != null);
        assert (EventQueue.isDispatchThread());
        this.fTabgroup.setTabPlacement(n);
    }

    public void setSelected(final TabGroupChild tabGroupChild) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetSelected, 7, false){

            @Override
            public void run() {
                UITabGroupPeer.this.doSetSelected(tabGroupChild);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetSelected(TabGroupChild tabGroupChild) {
        assert (tabGroupChild != null);
        assert (this.fTabgroup != null);
        assert (EventQueue.isDispatchThread());
        try {
            this.setSuppressStateChangeEventsEDT(true);
            int n = this.fTabgroup.indexOfComponent(tabGroupChild.getTabComponent());
            if (n != -1) {
                this.fTabgroup.setSelectedIndex(n);
            }
        }
        finally {
            this.setSuppressStateChangeEventsEDT(false);
        }
        this.updateUI();
    }

    private void setSuppressStateChangeEventsEDT(boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.fSuppressStateChangeEventsEDT = bl;
    }

    private boolean isStateChangeSuppressed() {
        return this.fSuppressStateChangeEventsEDT;
    }

    @Override
    public void doSetVisible(boolean bl) {
        assert (this.fTabgroup != null);
        assert (EventQueue.isDispatchThread());
        this.fTabgroup.setVisible(bl);
        this.updateUI();
    }

    @Override
    protected void doSetBackgroundColor(Color color) {
        this.fTabgroup.getParent().setBackground(color);
        Component[] componentArray = this.fTabgroup.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JViewport)) continue;
            ((JViewport)componentArray[i]).getView().setBackground(color);
        }
    }

    private void createTabbedPane() {
        if (this.fTabgroup == null) {
            this.fNotificationHandler = new FigureNotificationHandlerImpl();
            this.fTabgroup = new MJTabbedPane(1);
            this.addJavaEventListeners();
            UITabGroupChangeListener uITabGroupChangeListener = new UITabGroupChangeListener();
            this.fTabgroup.getModel().addChangeListener(uITabGroupChangeListener);
        }
    }

    private void addJavaEventListeners() {
        assert (this.fTabgroup != null);
        TabGroupMouseEventHandler tabGroupMouseEventHandler = new TabGroupMouseEventHandler();
        this.fTabgroup.addMouseListener(tabGroupMouseEventHandler);
        this.fTabgroup.addMouseMotionListener(tabGroupMouseEventHandler);
    }

    public synchronized void removeSelectionChangeListener(UITabGroupSelectionChangeListener uITabGroupSelectionChangeListener) {
        this.fListenerList.remove(UITabGroupSelectionChangeListener.class, uITabGroupSelectionChangeListener);
    }

    public synchronized void addSelectionChangeListener(UITabGroupSelectionChangeListener uITabGroupSelectionChangeListener) {
        this.fListenerList.add(UITabGroupSelectionChangeListener.class, uITabGroupSelectionChangeListener);
    }

    protected void fireSelectionChange(UITabGroupSelectionChangeEvent uITabGroupSelectionChangeEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UITabGroupSelectionChangeListener.class)) {
            ((UITabGroupSelectionChangeListener)eventListener).selectionChanged(uITabGroupSelectionChangeEvent);
        }
    }

    @Override
    public JComponent getPrintableComponent() {
        return this.getUIComponent();
    }

    @Override
    public JComponent getGUIDEView() {
        return this.getUIComponent();
    }

    @Override
    public boolean useLightWeightContainer() {
        return false;
    }

    @Override
    public void doAddPreOperation() {
        this.setSuppressStateChangeEventsEDT(true);
        this.updateUI();
    }

    @Override
    public void doAddPostOperation() {
        this.setSuppressStateChangeEventsEDT(false);
        this.updateUI();
    }

    @Override
    public void doRemovePreOperation() {
        this.setSuppressStateChangeEventsEDT(true);
        this.updateUI();
    }

    @Override
    public void doRemovePostOperation() {
        this.setSuppressStateChangeEventsEDT(false);
        this.updateUI();
    }

    @Override
    public void addUIcontrol(Component component, int n) {
        assert (EventQueue.isDispatchThread());
        component.setBackground(this.fTabgroup.getBackground());
        this.addTab("", null, component, null);
    }

    @Override
    public void removeUIcontrol(Component component) {
        assert (EventQueue.isDispatchThread());
        this.removeTab(component);
    }

    @Override
    public void postProcessAddUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
        assert (false);
    }

    @Override
    public void postProcessRemoveUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
        assert (false);
    }

    @Override
    public void replaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        assert (false);
    }

    @Override
    public void addSceneServerPeer(JavaSceneServerPeer javaSceneServerPeer) {
        assert (false);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        assert (false);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        assert (false);
    }

    @Override
    public Dimension getClientAreaSize() {
        return this.getPositionHandler().getClientAreaSize();
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        if (figureNotification instanceof TabTitleChangedNotification) {
            TabTitleChangedNotification tabTitleChangedNotification = (TabTitleChangedNotification)figureNotification;
            this.handleTitleChangedNotification(tabTitleChangedNotification);
        } else if (figureNotification instanceof TabTooltipChangedNotification) {
            TabTooltipChangedNotification tabTooltipChangedNotification = (TabTooltipChangedNotification)figureNotification;
            this.handleTooltipChangedNotification(tabTooltipChangedNotification);
        } else if (figureNotification instanceof TabEnableChangedNotification) {
            TabEnableChangedNotification tabEnableChangedNotification = (TabEnableChangedNotification)figureNotification;
            this.handleEnableChangedNotification(tabEnableChangedNotification);
        } else if (figureNotification instanceof TabBackgroundColorChangedNotification) {
            TabBackgroundColorChangedNotification tabBackgroundColorChangedNotification = (TabBackgroundColorChangedNotification)figureNotification;
            this.handleBackgroundColorChangedNotification(tabBackgroundColorChangedNotification);
        } else if (figureNotification instanceof TabForegroundColorChangedNotification) {
            TabForegroundColorChangedNotification tabForegroundColorChangedNotification = (TabForegroundColorChangedNotification)figureNotification;
            this.handleForegroundColorChangedNotification(tabForegroundColorChangedNotification);
        }
        this.updateUI();
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    private void handleBackgroundColorChangedNotification(TabBackgroundColorChangedNotification tabBackgroundColorChangedNotification) {
        assert (EventQueue.isDispatchThread());
        int n = this.fTabgroup.indexOfComponent(tabBackgroundColorChangedNotification.getTab());
        this.fTabgroup.setBackgroundAt(n, tabBackgroundColorChangedNotification.getBackgroundColor());
    }

    private void handleForegroundColorChangedNotification(TabForegroundColorChangedNotification tabForegroundColorChangedNotification) {
        assert (EventQueue.isDispatchThread());
        int n = this.fTabgroup.indexOfComponent(tabForegroundColorChangedNotification.getTab());
        this.fTabgroup.setForegroundAt(n, tabForegroundColorChangedNotification.getForegroundColor());
    }

    private void handleEnableChangedNotification(TabEnableChangedNotification tabEnableChangedNotification) {
        assert (EventQueue.isDispatchThread());
        this.fTabgroup.setEnabledAt(this.fTabgroup.indexOfComponent(tabEnableChangedNotification.getTab()), tabEnableChangedNotification.getEnable());
    }

    private void handleTooltipChangedNotification(TabTooltipChangedNotification tabTooltipChangedNotification) {
        assert (EventQueue.isDispatchThread());
        this.fTabgroup.setToolTipTextAt(this.fTabgroup.indexOfComponent(tabTooltipChangedNotification.getTab()), tabTooltipChangedNotification.getTooltipString());
    }

    private void handleTitleChangedNotification(TabTitleChangedNotification tabTitleChangedNotification) {
        assert (EventQueue.isDispatchThread());
        this.fTabgroup.setTitleAt(this.fTabgroup.indexOfComponent(tabTitleChangedNotification.getTab()), tabTitleChangedNotification.getTitle());
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    @Override
    public void validateFigure() {
    }

    private void handleAndDispatchMouseEvents(MouseEvent mouseEvent) {
        int n = this.fTabgroup.getUI().tabForCoordinate(this.fTabgroup, mouseEvent.getX(), mouseEvent.getY());
        if (n == -1) {
            this.fireUicomponentButton(mouseEvent);
        } else {
            Component component = this.fTabgroup.getComponentAt(n);
            component.dispatchEvent(mouseEvent);
        }
    }

    public class UITabGroupChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SingleSelectionModel singleSelectionModel = (SingleSelectionModel)changeEvent.getSource();
            if (!UITabGroupPeer.this.isStateChangeSuppressed()) {
                UITabGroupPeer.this.fireSelectionChange(new UITabGroupSelectionChangeEvent(singleSelectionModel.getSelectedIndex(), UITabGroupPeer.this.fTabgroup));
            }
        }
    }

    private class TabGroupMouseEventHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private TabGroupMouseEventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            UITabGroupPeer.this.handleAndDispatchMouseEvents(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            UITabGroupPeer.this.handleAndDispatchMouseEvents(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            UITabGroupPeer.this.handleAndDispatchMouseEvents(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            UITabGroupPeer.this.handleAndDispatchMouseEvents(mouseEvent);
        }
    }
}

