/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public abstract class PositionData {
    protected Rectangle fOuterBounds;
    protected Insets fInsets;
    public static final int ORIGIN_OFFSET = 1;

    protected PositionData(Rectangle rectangle) {
        this(rectangle, new Insets(0, 0, 0, 0));
    }

    protected PositionData(Rectangle rectangle, Insets insets) {
        if (insets.top < 0 || insets.left < 0 || insets.bottom < 0 || insets.right < 0) {
            throw new IllegalArgumentException("Margins cannot be less than zero.");
        }
        this.fOuterBounds = new Rectangle(rectangle);
        this.fInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    protected PositionData(PositionData positionData) {
        this(positionData.fOuterBounds, positionData.fInsets);
    }

    public static Rectangle getDeviceFromMatlab(Rectangle rectangle, Dimension dimension) {
        return new Rectangle(rectangle.x - 1, dimension.height - (rectangle.y + rectangle.height - 1), rectangle.width, rectangle.height);
    }

    public static Rectangle getMatlabFromDevice(Rectangle rectangle, Dimension dimension) {
        return new Rectangle(rectangle.x + 1, dimension.height - (rectangle.y + rectangle.height - 1), rectangle.width, rectangle.height);
    }

    public Rectangle getOuterBounds() {
        return new Rectangle(this.fOuterBounds);
    }

    public abstract Rectangle getInnerBounds();

    public Insets getInsets() {
        return new Insets(this.fInsets.top, this.fInsets.left, this.fInsets.bottom, this.fInsets.right);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PositionData)) {
            return false;
        }
        PositionData positionData = (PositionData)object;
        Rectangle rectangle = positionData.getOuterBounds();
        if (!this.fOuterBounds.equals(rectangle)) {
            return false;
        }
        Insets insets = positionData.getInsets();
        return this.fInsets.equals(insets);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" {");
        stringBuffer.append(" Outer Bounds: ");
        stringBuffer.append(this.fOuterBounds);
        stringBuffer.append(" Insets: ");
        stringBuffer.append(this.fInsets);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }
}

