/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.UicontrolMouseWheelListener;
import com.mathworks.hg.peer.event.UicontrolEvent;
import com.mathworks.hg.peer.utils.UIScrollPane;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListboxPeer
extends AbstractUicontrolPeer {
    UicontrolList fListbox;
    ListboxUicontrolActionListener fListener;
    boolean fListenersEnabled = false;
    int fSelectionType;
    double[] fValue;
    double fMax;
    double fMin;
    private static final int sFirstMethodIndex;
    protected static final int sSetControlListboxTop;
    protected static final int sGetControlListboxTop;
    private static final int sLastMethodIndex;
    private static final String[] sLogMessages;

    public ListboxPeer() {
        this.fType = 8;
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = n >= sFirstMethodIndex && n <= sLastMethodIndex ? sLogMessages[n - sFirstMethodIndex] : super.getUserMethodDescription(n);
        return string;
    }

    @Override
    protected void createComponent() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fListbox = new UicontrolList();
        this.fComponent = this.fListbox;
    }

    @Override
    protected boolean doPreSetString(String[] stringArray) {
        super.doPreSetString(stringArray);
        return true;
    }

    @Override
    protected void doSetString(String[] stringArray) {
        this.removeUicontrolActionListeners();
        if (null != stringArray) {
            DefaultListModel defaultListModel;
            stringArray = this.deriveUnicodeFromFont(stringArray);
            boolean bl = false;
            if (stringArray.length > 99) {
                defaultListModel = new DefaultListModel();
                bl = true;
            } else {
                defaultListModel = (DefaultListModel)this.fListbox.getModel();
                this.fListbox.clearSelection();
                defaultListModel.removeAllElements();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (null == stringArray[i] || stringArray[i].length() == 0) {
                    stringArray[i] = " ";
                }
                defaultListModel.addElement(stringArray[i]);
            }
            if (bl) {
                this.fListbox.setModel(defaultListModel);
            }
            this.doSetValue(this.fValue, this.fMax, this.fMin);
        }
        if (null != this.fListener) {
            this.addUicontrolActionListeners();
        }
    }

    @Override
    protected void doSetFont(Font font) {
        super.doSetFont(font);
        FontMetrics fontMetrics = this.fListbox.getFontMetrics(font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        if (!font.getName().equalsIgnoreCase("Marlett") && !font.getName().equalsIgnoreCase("MS UI Gothic")) {
            --n;
        }
        this.fListbox.setFixedCellHeight(n);
    }

    @Override
    protected void doSetPosition(double d, double d2, double d3, double d4) {
        this.fListbox.updateScrollPolicy((int)d3, (int)d4);
        super.doSetPosition(d, d2, d3, d4);
    }

    @Override
    protected boolean doPreSetValue(double[] dArray, double d, double d2) {
        this.addLogMessage(11);
        return true;
    }

    @Override
    protected void doSetValue(double[] dArray, double d, double d2) {
        int[] nArray;
        this.removeUicontrolActionListeners();
        this.fValue = dArray;
        this.fMax = d;
        this.fMin = d2;
        boolean bl = false;
        if (dArray != null && dArray.length > 0) {
            int n = 1;
            int n2 = this.fListbox.getModel().getSize();
            if (d - d2 > 1.0) {
                this.fListbox.setSelectionMode(2);
                nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    if ((int)dArray[i] >= n && (int)dArray[i] <= n2) {
                        nArray[i] = (int)dArray[i] - 1;
                        bl = true;
                        continue;
                    }
                    nArray[i] = -1;
                }
            } else {
                this.fListbox.setSelectionMode(0);
                nArray = new int[1];
                if ((int)dArray[0] >= n && (int)dArray[0] <= n2) {
                    nArray[0] = (int)dArray[0] - 1;
                    bl = true;
                }
            }
        } else {
            if (d - d2 > 1.0) {
                this.fListbox.setSelectionMode(2);
            } else {
                this.fListbox.setSelectionMode(0);
            }
            nArray = new int[]{-1};
            bl = true;
        }
        if (bl) {
            this.fListbox.clearSelection();
            this.fListbox.setSelectedIndices(nArray);
        }
        this.fListbox.ensureIndexIsVisible(this.fListbox.getMaxSelectionIndex());
        if (null != this.fListener) {
            this.addUicontrolActionListeners();
        }
    }

    @Override
    protected double[] doGetValue() {
        int[] nArray = this.fListbox.getSelectedIndices();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i] + 1;
        }
        this.fValue = dArray;
        return dArray;
    }

    public final void setControlListboxTop(final int n) {
        if (this.doPreSetListboxTop(n)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sSetControlListboxTop){

                @Override
                public void run() {
                    ListboxPeer.this.doSetListboxTop(n);
                }
            });
        }
    }

    @Override
    protected boolean doPreSetListboxTop(int n) {
        this.addLogMessage(sSetControlListboxTop);
        return true;
    }

    @Override
    protected void doSetListboxTop(int n) {
        DefaultListCellRenderer defaultListCellRenderer;
        if (this.fListbox != null && this.getControlListboxTop() != n && null != (defaultListCellRenderer = (DefaultListCellRenderer)this.fListbox.getCellRenderer())) {
            int n2 = this.fListbox.getFixedCellHeight();
            if (n2 == 0) {
                n2 = defaultListCellRenderer.getPreferredSize().height;
            }
            ((MJScrollPane)this.getComponentPeer()).getVerticalScrollBar().setValue((n - 1) * n2);
        }
    }

    public final int getControlListboxTop() {
        this.addLogMessage(sGetControlListboxTop);
        return this.doGetListboxTop();
    }

    protected int doGetListboxTop() {
        DefaultListCellRenderer defaultListCellRenderer;
        int n = 0;
        if (null != this.fListbox && null != (defaultListCellRenderer = (DefaultListCellRenderer)this.fListbox.getCellRenderer())) {
            int n2 = this.fListbox.getFixedCellHeight();
            if (n2 == 0) {
                n2 = defaultListCellRenderer.getPreferredSize().height;
            }
            int n3 = ((MJScrollPane)this.getComponentPeer()).getVerticalScrollBar().getValue();
            n = n3 / n2;
        }
        return 1 + n;
    }

    @Override
    protected int doGetSelectionType() {
        return this.fSelectionType;
    }

    @Override
    public void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= this.getUserLastMethodID()) {
            if (n < sFirstMethodIndex) {
                super.addLogMessage(n);
            } else {
                DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
            }
        }
    }

    @Override
    public JComponent getComponentPeer() {
        if (null == this.fListbox) {
            return null;
        }
        return this.fListbox.getContainer();
    }

    @Override
    protected void addUicontrolActionListeners() {
        if (this.fListenersEnabled) {
            return;
        }
        if (this.fListener == null) {
            this.fListener = new ListboxUicontrolActionListener();
        }
        this.fListbox.addMouseListener(this.fListener);
        this.fListbox.addListSelectionListener(this.fListener);
        this.fListbox.addKeyListener(this.fListener);
        this.fListenersEnabled = true;
    }

    @Override
    protected void removeUicontrolActionListeners() {
        if (this.fListener == null || !this.fListenersEnabled) {
            return;
        }
        this.fListbox.removeKeyListener(this.fListener);
        this.fListbox.removeListSelectionListener(this.fListener);
        this.fListbox.removeMouseListener(this.fListener);
        this.fListenersEnabled = false;
    }

    static {
        sSetControlListboxTop = sFirstMethodIndex = AbstractUicontrolPeer.getLastMethodIndex() + 1;
        sLastMethodIndex = sGetControlListboxTop = sFirstMethodIndex + 1;
        sLogMessages = new String[]{"setControlListboxTop", "getControlListboxTop"};
    }

    private class UicontrolList
    extends MJList {
        MJScrollPane fScrollPane;
        ScrollbarMouseListener fScrollbarMouseListener;

        public UicontrolList() {
            super(new DefaultListModel());
            this.fScrollPane = null;
            this.fScrollbarMouseListener = null;
            assert (SwingUtilities.isEventDispatchThread());
            this.setSelectionMode(0);
            this.setBackground(Color.lightGray);
            this.fScrollPane = new UIScrollPane((Component)((Object)this));
            this.fScrollbarMouseListener = new ScrollbarMouseListener();
            this.fScrollPane.addMouseMotionListener((MouseMotionListener)this.fScrollbarMouseListener);
            this.fScrollPane.addMouseWheelListener((MouseWheelListener)new UicontrolMouseWheelListener(ListboxPeer.this.fCompParent));
            this.updateScrollPolicy(0, 0);
            this.setDragSelectionEnabled(true);
        }

        private void updateScrollPolicy(int n, int n2) {
            if (n2 >= 35) {
                this.fScrollPane.setHorizontalScrollBarPolicy(30);
            } else {
                this.fScrollPane.setHorizontalScrollBarPolicy(31);
            }
            if (n >= 25) {
                this.fScrollPane.setVerticalScrollBarPolicy(22);
            } else {
                this.fScrollPane.setVerticalScrollBarPolicy(21);
            }
        }

        public MJScrollPane getContainer() {
            return this.fScrollPane;
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            if (bl) {
                this.fScrollPane.removeMouseListener((MouseListener)this.fScrollbarMouseListener);
                this.fScrollPane.setEnabled(true);
            } else {
                this.fScrollPane.setEnabled(false);
                this.fScrollPane.addMouseListener((MouseListener)this.fScrollbarMouseListener);
            }
        }

        public boolean isFocusable() {
            return ListboxPeer.this.fEnable == 1;
        }

        public void processEvent(AWTEvent aWTEvent) {
            if (ListboxPeer.this.fEnable == 1) {
                super.processEvent(aWTEvent);
            } else {
                ListboxPeer.this.doProcessEvent(aWTEvent);
            }
        }

        private class ScrollbarMouseListener
        extends MouseAdapter
        implements MouseMotionListener {
            private ScrollbarMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ListboxPeer.this.doProcessEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ListboxPeer.this.doProcessEvent(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                ListboxPeer.this.doProcessEvent(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ListboxPeer.this.doProcessEvent(mouseEvent);
            }
        }
    }

    private class ListboxUicontrolActionListener
    extends MouseAdapter
    implements ListSelectionListener,
    KeyListener {
        boolean fFireValueChanged = true;
        boolean fResetValue = false;

        private ListboxUicontrolActionListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fFireValueChanged = false;
            if (mouseEvent.isControlDown() && ListboxPeer.this.fListbox.getSelectedIndex() == -1 && ListboxPeer.this.fListbox.getSelectionMode() == 0) {
                ListboxPeer.this.doSetValue(ListboxPeer.this.fValue, ListboxPeer.this.fMax, ListboxPeer.this.fMin);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                ListboxPeer.this.fSelectionType = mouseEvent.getClickCount() % 2 == 0 && mouseEvent.getClickCount() != 0 ? 2 : 1;
                UicontrolEvent uicontrolEvent = new UicontrolEvent(ListboxPeer.this, mouseEvent.getSource());
                ListboxPeer.this.fireUicontrolAction(uicontrolEvent);
                ListboxPeer.this.refreshUicontrol();
            }
            this.fFireValueChanged = true;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 32 && ListboxPeer.this.fListbox.getSelectionMode() == 0) {
                this.fResetValue = true;
            }
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                ListboxPeer.this.fSelectionType = 2;
                UicontrolEvent uicontrolEvent = new UicontrolEvent(ListboxPeer.this, keyEvent.getSource());
                ListboxPeer.this.fireUicontrolAction(uicontrolEvent);
                ListboxPeer.this.refreshUicontrol();
            } else {
                ListboxPeer.this.fSelectionType = 1;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.fResetValue) {
                this.fResetValue = false;
                ListboxPeer.this.doSetValue(ListboxPeer.this.fValue, ListboxPeer.this.fMax, ListboxPeer.this.fMin);
                return;
            }
            if (!listSelectionEvent.getValueIsAdjusting() && this.fFireValueChanged) {
                ListboxPeer.this.fListbox.ensureIndexIsVisible(ListboxPeer.this.fListbox.getMaxSelectionIndex());
                UicontrolEvent uicontrolEvent = new UicontrolEvent(ListboxPeer.this, listSelectionEvent.getSource());
                ListboxPeer.this.fireUicontrolAction(uicontrolEvent);
                ListboxPeer.this.refreshUicontrol();
            }
        }
    }
}

