/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigureComponentNotification;
import com.mathworks.hg.peer.FigureKeyListener;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigurePanel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class FigureComponentProxy
implements FigureNotificationHandler {
    protected FigureComponent fFigureComponent = null;
    protected Component fComponent = null;
    private FigureKeyListener fFigureKeyListener = new FigureKeyListener();
    private boolean fHaveKeyListeners = false;
    private static FigureKeyEventDispatcher sFigureKeyEventDispatcher = null;
    protected FigureNotificationHandlerImpl fNotificationHandler = new FigureNotificationHandlerImpl();

    public FigureComponentProxy() {
        this.fFigureKeyListener.setNotificationSuccessor(this);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void setFigureComponent(FigureComponent figureComponent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setFigureComponent from EDT");
        }
        if (this.fFigureComponent == figureComponent) {
            return;
        }
        if (this.fFigureComponent != null) {
            this.detachListeners();
        }
        this.fComponent = null;
        this.fFigureComponent = figureComponent;
        if (this.fFigureComponent != null) {
            this.fComponent = this.fFigureComponent.getComponent();
            assert (this.fComponent != null);
            this.attachListeners();
        }
    }

    protected void attachListeners() {
        this.addKeyListeners();
    }

    protected void detachListeners() {
        this.removeKeyListeners();
    }

    protected void addKeyListeners() {
        assert (this.fFigureComponent != null);
        if (!this.fHaveKeyListeners) {
            this.fComponent.addKeyListener(this.fFigureKeyListener);
            if (sFigureKeyEventDispatcher == null) {
                sFigureKeyEventDispatcher = new FigureKeyEventDispatcher();
            }
            sFigureKeyEventDispatcher.attach(this);
            this.fHaveKeyListeners = true;
        }
    }

    protected void removeKeyListeners() {
        if (sFigureKeyEventDispatcher != null) {
            sFigureKeyEventDispatcher.detach(this);
        }
        assert (this.fFigureComponent != null);
        assert (this.fComponent != null);
        this.fComponent.removeKeyListener(this.fFigureKeyListener);
        this.fHaveKeyListeners = false;
    }

    public void dispose() {
        this.setNotificationSuccessor(null);
        this.setFigureComponent(null);
    }

    public boolean isLightweight() {
        if (this.fFigureComponent == null) {
            return true;
        }
        return this.fFigureComponent.isComponentLightweight();
    }

    public boolean requestFocus() {
        boolean bl = false;
        if (this.fFigureComponent != null) {
            assert (this.fComponent != null);
            bl = this.fComponent.requestFocusInWindow();
        }
        return bl;
    }

    void setParent(final FigurePanel figurePanel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FigureComponentProxy.this.handleNotification(new FigureComponentNotification(2, FigureComponentProxy.this.fComponent, FigureComponentProxy.this.isLightweight()));
                FigureComponentProxy.this.setNotificationSuccessor(figurePanel);
                if (figurePanel != null && FigureComponentProxy.this.fComponent != null) {
                    FigureComponentProxy.this.handleNotification(new FigureComponentNotification(1, FigureComponentProxy.this.fComponent, FigureComponentProxy.this.isLightweight()));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    void sendJavaEventNotification(AWTEvent aWTEvent) {
        this.fNotificationHandler.sendJavaEventNotification(aWTEvent);
    }

    private static class FigureKeyEventDispatcher
    implements KeyEventDispatcher {
        private Vector proxies = new Vector(10, 5);

        private FigureKeyEventDispatcher() {
        }

        public void attach(FigureComponentProxy figureComponentProxy) {
            this.proxies.add(figureComponentProxy);
            if (this.proxies.size() == 1) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            }
        }

        public void detach(FigureComponentProxy figureComponentProxy) {
            this.proxies.remove(figureComponentProxy);
            if (this.proxies.size() == 0) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            }
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9 && keyEvent.getSource() instanceof FigureComponent) {
                Enumeration enumeration = this.proxies.elements();
                while (enumeration.hasMoreElements()) {
                    FigureComponentProxy figureComponentProxy = (FigureComponentProxy)enumeration.nextElement();
                    if (keyEvent.getSource() != figureComponentProxy.getComponent()) continue;
                    figureComponentProxy.sendJavaEventNotification(keyEvent);
                }
            }
            return false;
        }
    }
}

