/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.BlockedOnPositionState;
import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.PositionEventType;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class BlockOnResizeAndWindowStyleChangeState
implements BlockedOnPositionState,
FigureNotificationHandler {
    private FigureNotificationHandlerImpl fNotificationHandler = new FigureNotificationHandlerImpl();
    private final Object lock = new Object();
    private long fTimeStartResize = 0L;
    private long fTimeGotResize = 0L;
    private boolean fWaiting = false;
    private boolean fChangingWindowStyle = false;
    private PositionEventType fChangeType = PositionEventType.MOVED;
    private boolean fWaitingInTest = false;
    private FigurePeer fFigurePeer;
    private FigureClient fFigureClient;

    public BlockOnResizeAndWindowStyleChangeState(FigurePeer figurePeer, FigureClient figureClient) {
        this.fFigurePeer = figurePeer;
        this.fFigureClient = figureClient;
    }

    private synchronized void startWaiting() {
        this.fTimeStartResize = System.currentTimeMillis();
        this.fWaiting = true;
    }

    @Override
    public synchronized void stopWaiting() {
        this.fTimeGotResize = System.currentTimeMillis();
        this.fWaiting = false;
        this.fChangingWindowStyle = false;
        this.fChangeType = PositionEventType.MOVED;
    }

    @Override
    public synchronized void startWaitForResize(PositionEventType positionEventType) {
        this.startWaiting();
        this.fChangeType = positionEventType;
    }

    @Override
    public synchronized void startWaitingForWindowStyle() {
        this.startWaiting();
        this.fChangingWindowStyle = true;
        this.fChangeType = PositionEventType.RESIZED;
    }

    private void forceClearWaitForResize() throws InvalidStateException {
        Rectangle rectangle;
        Rectangle rectangle2;
        InvalidStateException invalidStateException = null;
        if (this.fFigurePeer.isWindowDocked()) {
            invalidStateException = new InvalidStateException("fDocked should be false.");
        }
        if (!(rectangle2 = this.fFigureClient.getClientRectangle()).equals(rectangle = this.fFigureClient.getCachedClientRectangle())) {
            invalidStateException = new InvalidStateException("bounds should be different");
        }
        this.fFigureClient.setCachedClientRectangle(rectangle2);
        this.handleNotification(new FigureMoveResizeNotification(true));
        if (invalidStateException != null) {
            throw invalidStateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWaitForResize(boolean bl, boolean bl2) {
        InvalidStateException invalidStateException = null;
        if (bl) {
            try {
                this.forceClearWaitForResize();
            }
            catch (InvalidStateException invalidStateException2) {
                invalidStateException = invalidStateException2;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (bl2 || bl) {
                this.stopWaiting();
            } else if (this.fChangeType != PositionEventType.RESIZED) {
                this.stopWaiting();
            }
        }
    }

    @Override
    public void setWaitForResize(boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fWaitingInTest = bl;
        if (bl) {
            this.startWaiting();
        } else {
            this.stopWaiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getWaitForResize() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            bl = this.fTimeGotResize < this.fTimeStartResize || this.fWaiting;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getWaitForWindowStyle() {
        boolean bl = true;
        Object object = this.lock;
        synchronized (object) {
            bl = this.fChangingWindowStyle;
        }
        return bl;
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    private class InvalidStateException
    extends Exception {
        public InvalidStateException(String string) {
            super(string);
        }
    }
}

