/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cache;
import ice.net.CacheManager;
import ice.net.CachedObject;
import ice.net.FileInfo;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.ParseDate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileCache
implements Cache {
    private String C;
    private long J;
    private long OEAB;
    private Hashtable append;
    private Hashtable before;
    private CacheManager clear;
    private int close;
    private String containsKey = "";
    private int delete = 0;
    private int elements = 20;
    private boolean equals = Defs.sysPropertyBoolean((String)"ice.net.debug.filecache", (boolean)false);

    public FileCache(String string) throws ICEException {
        if (this.equals) {
            Debug.trace((String)"Initializing file Cache");
        }
        this.setDirectory(string);
        this.C();
    }

    private void C() {
        this.C = "default file cache";
        this.J = 10000000L;
        this.append = new Hashtable();
        this.before = new Hashtable();
        this.rebuild();
    }

    private void J() throws IOException {
        String string = "testfile";
        File file = new File(this.containsKey + File.separatorChar + string);
        if (this.equals) {
            Debug.trace((String)("Trying to write testfile: " + this.containsKey + File.separatorChar + string));
        }
        FileWriter fileWriter = new FileWriter(file);
        String string2 = "testtesttest";
        fileWriter.write(string2, 0, string2.length());
        fileWriter.close();
        file.delete();
        if (this.equals) {
            Debug.trace((String)"Test file written and deleted successfully.");
        }
    }

    public void setManager(CacheManager cacheManager) {
        this.clear = cacheManager;
    }

    public void submit(CachedObject cachedObject) {
        if (this.has(cachedObject.url)) {
            if (this.isExpired(this.containsKey(cachedObject.url))) {
                if (this.equals) {
                    Debug.trace((String)(cachedObject.url + " was expired and has been replaced."));
                }
                this.clear(cachedObject.url);
                this.before(cachedObject);
            } else if (this.append(cachedObject)) {
                if (this.equals) {
                    Debug.trace((String)(cachedObject.url + " is being refreshed."));
                }
                this.clear(cachedObject.url);
                this.before(cachedObject);
            }
        } else {
            if (this.equals) {
                Debug.trace((String)(cachedObject.url + " added to the file cache for the first time."));
            }
            this.before(cachedObject);
        }
    }

    public boolean has(String string) {
        return this.before.containsKey(string);
    }

    public void delete(String string, boolean bl) {
        if (this.has(string)) {
            CachedObject cachedObject = null;
            if (bl) {
                cachedObject = this.get(string);
            }
            this.clear(string);
            if (this.clear != null && bl) {
                this.clear.wasDeleted(cachedObject, this);
            }
        }
    }

    private String OEAB() {
        String string = new String("CacheFile" + this.close + ".ice");
        ++this.close;
        return string;
    }

    private boolean append(CachedObject cachedObject) {
        FileInfo fileInfo = (FileInfo)this.before.get(cachedObject.url);
        Date date = new Date(fileInfo.lastModified);
        Date date2 = ParseDate.parseDate((String)cachedObject.findHeader("Last-Modified"));
        if (date == null || date2 == null) {
            return false;
        }
        return date.before(date2);
    }

    private void before(CachedObject cachedObject) {
        ++this.delete;
        if (this.delete > this.elements) {
            this.writeDictionary();
            this.delete = 0;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.url = new String(cachedObject.url);
        fileInfo.lastModified = cachedObject.lastModified;
        fileInfo.lastAccessed = cachedObject.lastAccessed;
        fileInfo.recieved = cachedObject.recieved;
        fileInfo.expires = cachedObject.expires;
        fileInfo.maxAge = cachedObject.maxAge;
        try {
            String string = this.OEAB();
            FileOutputStream fileOutputStream = new FileOutputStream(this.containsKey + File.separatorChar + string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(cachedObject);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
            this.append.put(cachedObject.url, string);
            File file = new File(this.containsKey + File.separatorChar + string);
            this.OEAB += file.length();
            this.before.put(cachedObject.url, fileInfo);
            if (this.OEAB > this.J) {
                this.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setDirectory(String string) throws ICEException {
        if (this.equals) {
            Debug.trace((String)("File Cache directory set to be " + string));
        }
        try {
            if (string == null) {
                throw new IOException("dummy");
            }
            if (string.equals("")) {
                throw new IOException("dummy");
            }
            this.containsKey = string;
            this.J();
        }
        catch (IOException iOException) {
            throw new ICEException(2, 1, 18);
        }
    }

    public String getDirectory() {
        return this.containsKey;
    }

    private void clear(String string) {
        String string2 = (String)this.append.get(string);
        if (string2 != null) {
            this.append.remove(string);
            this.before.remove(string);
            File file = new File(this.containsKey + File.separatorChar + string2);
            this.OEAB -= file.length();
            file.delete();
            string2 = null;
        }
    }

    public long getCurrentSize() {
        return this.OEAB;
    }

    protected void finalize() {
        this.clear();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clear() {
        this.before.clear();
        Enumeration enumeration = this.append.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            File file = new File(string);
            file.delete();
        }
        this.OEAB = 0L;
    }

    private void close() {
        while (this.OEAB > this.J) {
            String string = this.getOldest();
            String string2 = (String)this.append.get(string);
            if (this.clear != null) {
                CachedObject cachedObject = this.get(string2);
                this.clear.wasDeleted(cachedObject, this);
            }
            this.clear(string);
        }
        this.writeDictionary();
    }

    public void setMaxSize(long l) {
        this.J = l;
        if (this.OEAB > this.J) {
            this.close();
        }
    }

    public long getMaxSize() {
        return this.J;
    }

    public void setExpires(String string, Date date) {
        FileInfo fileInfo = (FileInfo)this.before.get(string);
        if (fileInfo != null && date != null) {
            fileInfo.expires = date.getTime();
        }
    }

    public void clearExpired() {
        Enumeration enumeration = this.append.elements();
        while (enumeration.hasMoreElements()) {
            FileInfo fileInfo = (FileInfo)enumeration.nextElement();
            if (!this.isExpired(fileInfo)) continue;
            this.clear(fileInfo.url);
        }
    }

    private FileInfo containsKey(String string) {
        return (FileInfo)this.before.get(string);
    }

    public CachedObject get(String string) {
        FileInfo fileInfo;
        if (!this.has(string)) {
            return null;
        }
        ++this.delete;
        if (this.delete > this.elements) {
            this.writeDictionary();
            this.delete = 0;
        }
        if (this.isExpired(fileInfo = (FileInfo)this.before.get(string))) {
            this.clear(string);
            return null;
        }
        CachedObject cachedObject = null;
        try {
            String string2 = (String)this.append.get(string);
            FileInputStream fileInputStream = new FileInputStream(this.containsKey + File.separatorChar + string2);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            cachedObject = (CachedObject)objectInputStream.readObject();
            fileInputStream.close();
            if (this.equals) {
                Debug.trace((String)("Read " + cachedObject.url + " from disk."));
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cachedObject;
    }

    public String getName() {
        return this.C;
    }

    boolean isExpired(FileInfo fileInfo) {
        return this.clear.isExpired(fileInfo.expires, fileInfo.recieved, fileInfo.lastModified, fileInfo.maxAge);
    }

    void writeDictionary() {
        try {
            Object object;
            FileOutputStream fileOutputStream = new FileOutputStream(this.containsKey + File.separatorChar + "dictionary.tmp");
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Enumeration enumeration = this.before.elements();
            dataOutputStream.writeInt(this.before.size());
            while (enumeration.hasMoreElements()) {
                object = (FileInfo)enumeration.nextElement();
                dataOutputStream.writeInt(((FileInfo)object).url.length());
                dataOutputStream.writeChars(((FileInfo)object).url);
                dataOutputStream.writeLong(((FileInfo)object).lastModified);
                dataOutputStream.writeLong(((FileInfo)object).lastAccessed);
                dataOutputStream.writeLong(((FileInfo)object).recieved);
                dataOutputStream.writeLong(((FileInfo)object).expires);
                dataOutputStream.writeLong(((FileInfo)object).maxAge);
            }
            dataOutputStream.close();
            fileOutputStream.close();
            object = new File(this.containsKey + File.separatorChar + "dictionary.tmp");
            File file = new File(this.containsKey + File.separatorChar + "dictionary.ice");
            if (file.exists()) {
                file.delete();
            }
            ((File)object).renameTo(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean readDictionary() {
        Hashtable<String, FileInfo> hashtable = new Hashtable<String, FileInfo>();
        try {
            String string = this.containsKey + File.separatorChar + "dictionary.ice";
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n = dataInputStream.readInt();
            int n2 = 0;
            while (n2 < n) {
                FileInfo fileInfo = new FileInfo();
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = dataInputStream.readInt();
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(dataInputStream.readChar());
                    ++n4;
                }
                fileInfo.url = new String(stringBuffer);
                fileInfo.lastModified = dataInputStream.readLong();
                fileInfo.lastAccessed = dataInputStream.readLong();
                fileInfo.recieved = dataInputStream.readLong();
                fileInfo.expires = dataInputStream.readLong();
                fileInfo.maxAge = dataInputStream.readLong();
                if (this.equals) {
                    Debug.trace((String)("Read info for url " + fileInfo.url + " from dictionary."));
                }
                hashtable.put(fileInfo.url, fileInfo);
                ++n2;
            }
            if (this.before != null) {
                this.before.clear();
            }
            this.before = hashtable;
            if (this.equals) {
                Debug.trace((String)("Read dictionary from file " + string));
            }
            return true;
        }
        catch (IOException iOException) {
            File file = new File(this.containsKey + File.separatorChar + "dictionary.ice");
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }

    void rebuild() {
        Hashtable<String, FileInfo> hashtable = new Hashtable<String, FileInfo>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        File file = new File(this.containsKey);
        if (file.isDirectory()) {
            if (this.equals) {
                Debug.trace((String)("Rebuilding file cache, using directory " + file + " for file cache"));
            }
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.containsKey + File.separatorChar + stringArray[n]);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    CachedObject cachedObject = (CachedObject)objectInputStream.readObject();
                    fileInputStream.close();
                    FileInfo fileInfo = new FileInfo();
                    fileInfo.url = cachedObject.url;
                    fileInfo.lastModified = cachedObject.lastModified;
                    fileInfo.lastAccessed = cachedObject.lastAccessed;
                    fileInfo.recieved = cachedObject.recieved;
                    fileInfo.expires = cachedObject.expires;
                    hashtable.put(fileInfo.url, fileInfo);
                    hashtable2.put(fileInfo.url, stringArray[n]);
                    if (this.equals) {
                        Debug.trace((String)(fileInfo.url + " was read from disk. The data for that object is in " + stringArray[n]));
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n;
            }
            this.before = hashtable;
            this.append = hashtable2;
        } else if (this.equals) {
            Debug.trace((String)("Rebuild of file cache failed: " + file + " should be a directory but is not."));
        }
    }

    String getOldest() {
        Enumeration enumeration = this.before.elements();
        String string = null;
        long l = Long.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            FileInfo fileInfo = (FileInfo)enumeration.nextElement();
            if (fileInfo.lastAccessed >= l) continue;
            l = fileInfo.lastAccessed;
            string = fileInfo.url;
        }
        return string;
    }

    String findHeader(CachedObject cachedObject, String string) {
        int n = 0;
        while (n < cachedObject.headers.length) {
            if (cachedObject.headers[n].equalsIgnoreCase(string)) {
                return cachedObject.headers[n];
            }
            ++n;
        }
        return null;
    }
}

