/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.javacc.lib;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.modules.xml.text.syntax.javacc.lib.CharStream;
import org.netbeans.modules.xml.text.syntax.javacc.lib.SimpleCharStream;

public class StringParserInput
extends SimpleCharStream
implements CharStream {
    private char[] buffer;
    private int pos;
    private int begin;
    private int len;
    private int end;

    public void setString(String string) {
        this.buffer = string.toCharArray();
        this.pos = 0;
        this.begin = 0;
        this.end = this.len = string.length();
    }

    public void setBuffer(char[] cArray, int n, int n2) {
        this.buffer = cArray;
        this.begin = this.pos = n;
        this.len = n2;
        this.end = n + n2;
    }

    @Override
    public char readChar() throws IOException {
        if (this.pos >= this.end) {
            throw new EOFException();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public int getColumn() {
        return 0;
    }

    @Override
    public int getLine() {
        return 0;
    }

    @Override
    public int getEndColumn() {
        return 0;
    }

    @Override
    public int getEndLine() {
        return 0;
    }

    @Override
    public int getBeginColumn() {
        return 0;
    }

    @Override
    public int getBeginLine() {
        return 0;
    }

    @Override
    public void backup(int n) {
        if (this.pos > 1) {
            this.pos -= n;
        }
    }

    @Override
    public char BeginToken() throws IOException {
        this.begin = this.pos;
        return this.readChar();
    }

    @Override
    public String GetImage() {
        return new String(this.buffer, this.begin, this.pos - this.begin);
    }

    public int getLength() {
        return this.pos - this.begin;
    }

    @Override
    public char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.buffer, this.pos - n, cArray, 0, n);
        return cArray;
    }

    @Override
    public void Done() {
    }

    public String toString() {
        return "StringParserInput\n Pos:" + this.pos + " len:" + this.len + " #################\n" + this.buffer;
    }
}

