/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.editor.ext.JavaDocView;

public class HTMLJavaDocView
extends JEditorPane
implements JavaDocView {
    private HTMLEditorKit htmlKit;

    public HTMLJavaDocView(Color color) {
        this.setEditable(false);
        this.setBGColor(color);
        this.setMargin(new Insets(0, 3, 3, 3));
    }

    @Override
    public void setContent(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringReader stringReader = new StringReader("<HTML><BODY>" + string + "</BODY></HTML>");
                try {
                    Document document = HTMLJavaDocView.this.getDocument();
                    document.remove(0, document.getLength());
                    HTMLJavaDocView.this.getEditorKit().read(stringReader, HTMLJavaDocView.this.getDocument(), 0);
                    HTMLJavaDocView.this.setCaretPosition(0);
                    HTMLJavaDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    @Override
    public void setBGColor(Color color) {
        this.setBackground(color);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
            if (this.htmlKit.getStyleSheet().getStyleSheets() != null) {
                return this.htmlKit;
            }
            StyleSheet styleSheet = new StyleSheet();
            Font font = this.getFont();
            styleSheet.addRule(new StringBuffer("body { font-size: ").append(font.getSize()).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet.addStyleSheet(this.htmlKit.getStyleSheet());
            this.htmlKit.setStyleSheet(styleSheet);
        }
        return this.htmlKit;
    }
}

