/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.MWCaret;
import com.mathworks.widgets.text.MWSettingsDefaults;
import com.mathworks.widgets.text.STPBaseModelInterface;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.SettingsDefaults;

public class MWDrawLayerFactory {
    public static final String CARET_LAYER_NAME = "caret-layer";
    static final String HIGHLIGHT_LINES_LAYER_NAME = "highlight-lines-layer";
    static final String BOLD_LINES_LAYER_NAME = "bold-lines-layer";
    static final String DRAW_ABOVE_LINES_LAYER_NAME = "draw-above-lines-layer";
    public static final String INPUT_MODE_LAYER_NAME = "input-mode-layer";
    public static final int CARET_LAYER_VISIBILITY = 10000;

    private MWDrawLayerFactory() {
    }

    static class AboveLinesLayer
    extends DrawLayerFactory.ColorLineLayer {
        private static Coloring sColoring = new Coloring(null, 7, null, null, null, null, null, MWSettingsDefaults.defaultCellBreak_CodeFold_Color);

        AboveLinesLayer() {
            super(MWDrawLayerFactory.DRAW_ABOVE_LINES_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return sColoring;
        }
    }

    static class BoldLinesLayer
    extends DrawLayerFactory.ColorLineLayer {
        private Coloring fColoring = new Coloring(SettingsDefaults.defaultFont.deriveFont(1), 2, null, null);

        BoldLinesLayer() {
            super(MWDrawLayerFactory.BOLD_LINES_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return this.fColoring;
        }

        public boolean extendsEOL() {
            return false;
        }
    }

    static class HighlightLinesLayer
    extends DrawLayerFactory.ColorLineLayer {
        HighlightLinesLayer() {
            super(MWDrawLayerFactory.HIGHLIGHT_LINES_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext drawContext) {
            return drawContext.getEditorUI().getColoring("highlight-lines");
        }
    }

    public static class MCaretLayer
    extends DrawLayerFactory.CaretLayer {
        public void updateContext(DrawContext drawContext) {
            MJPopupMenu mJPopupMenu;
            JTextComponent jTextComponent = drawContext.getEditorUI().getComponent();
            assert (jTextComponent != null);
            boolean bl = false;
            if (jTextComponent instanceof STPBaseModelInterface && (mJPopupMenu = ((STPBaseModelInterface)((Object)jTextComponent)).getContextMenu()) != null && mJPopupMenu.isShowing() && mJPopupMenu.getInvoker() == jTextComponent) {
                bl = true;
            }
            if ((mJPopupMenu = ((MWCaret)((Object)jTextComponent.getCaret())).isInFocus() || bl ? drawContext.getEditorUI().getColoring("mw-selection-in-focus") : drawContext.getEditorUI().getColoring("mw-selection-outof-focus")) != null) {
                mJPopupMenu.apply(drawContext);
            }
        }
    }

    public static class InputModeLayer
    extends DrawLayerFactory.IncSearchLayer {
        public InputModeLayer() {
            super(MWDrawLayerFactory.INPUT_MODE_LAYER_NAME);
        }

        public void updateContext(DrawContext drawContext) {
            this.coloring = new Coloring(null, 0, null, null, null, null, EditorPrefsAccessor.getTextColor());
            this.coloring.apply(drawContext);
        }
    }
}

