/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.util.LineBreak;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.SmartFormatter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;

public class DocumentUtils {
    private DocumentUtils() {
    }

    public static int getRowEndFromLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        return n2 == -1 ? -1 : Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
    }

    public static String getInitialWhitespaceOnLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n3, (int)n2);
        if (n4 == -1) {
            n4 = n2;
        }
        return baseDocument.getText(n3, n4 - n3);
    }

    public static boolean isWithinInitialWhitespace(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)Utilities.getRowStart((BaseDocument)baseDocument, (int)n), (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
        return n2 == -1 || n <= n2;
    }

    public static int getLineStartAfterWhitespace(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n2, (int)Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2));
        return n3 != -1 ? n3 : n2;
    }

    public static LineBreak getLineEndingStyle(Document document) {
        Validate.notNull((Object)document, (String)"Document cannot be null.");
        String string = (String)document.getProperty("__EndOfLine__");
        return string == null ? LineBreak.getPlatformPreferred() : LineBreak.lookup((String)string);
    }

    public static void setLineEndingStyle(Document document, LineBreak lineBreak) {
        Validate.notNull((Object)document, (String)"Document cannot be null.");
        Validate.notNull((Object)lineBreak, (String)"LineBreak cannot be null.");
        document.putProperty("__EndOfLine__", lineBreak.getLineBreakString());
    }

    public static int getLineNumberFromPosition(BaseDocument baseDocument, int n) {
        try {
            return Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String indentText(BaseDocument baseDocument, Formatter formatter, int n, int n2) {
        Validate.isTrue((boolean)(formatter instanceof SmartFormatter), (String)("Supplied formatter is not a SmartFormatter: " + formatter));
        Validate.isTrue((n >= 0 && n < baseDocument.getLength() ? 1 : 0) != 0, (String)("Start index is out of range:" + n));
        Validate.isTrue((n2 >= n ? 1 : 0) != 0, (String)"Start index is less than end index.");
        Validate.isTrue((n2 >= 0 && n2 <= baseDocument.getLength() ? 1 : 0) != 0, (String)("End index is out of range:" + n2));
        IndentingStyle indentingStyle = ((SmartFormatter)formatter).getFormattingType();
        StringWriter stringWriter = new StringWriter();
        try {
            ((SmartFormatter)formatter).setFormattingType(IndentingStyle.SMART);
            formatter.reformat(baseDocument, n, n2);
            baseDocument.write((Writer)stringWriter, 0, baseDocument.getLength());
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            ((SmartFormatter)formatter).setFormattingType(indentingStyle);
        }
        return ((Object)stringWriter).toString();
    }
}

