/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.widgets.recordlist.IRecordIconProvider;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

public class CustomIconListCellRenderer
extends DefaultListCellRenderer {
    protected IRecordIconProvider fIconSource = null;
    protected boolean fShowIcons = false;
    protected Icon fLastSelectedIcon = null;

    CustomIconListCellRenderer(IRecordIconProvider iRecordIconProvider) {
        this(iRecordIconProvider, true);
    }

    CustomIconListCellRenderer(IRecordIconProvider iRecordIconProvider, boolean bl) {
        this.fIconSource = iRecordIconProvider;
        this.fShowIcons = bl;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (this.fShowIcons) {
            Icon icon = this.getIconForIndex(n);
            try {
                jLabel.setIcon(icon);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return jLabel;
    }

    public void setIconVisibility(boolean bl) {
        this.fShowIcons = bl;
    }

    public boolean getIconVisibility() {
        return this.fShowIcons;
    }

    public void setLastSelectedIndex(int n) {
        if (n > -1) {
            this.fLastSelectedIcon = this.getIconForIndex(n);
        }
    }

    protected Icon getIconForIndex(int n) {
        Icon icon = null;
        if (n == -1) {
            icon = this.fLastSelectedIcon;
        } else if (this.fIconSource != null) {
            icon = this.fIconSource.getRecordIcon(n);
        }
        return icon;
    }
}

