/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.services.Prefs;
import com.mathworks.widgets.login.LoginPersistenceStrategy;

public class DefaultPersistenceStrategy
implements LoginPersistenceStrategy {
    private static final String BASE_KEY = "com.mathworks.widgets.login.LoginProperties";
    private static final String MWA_USER_NAME_KEY = "com.mathworks.widgets.login.LoginProperties.mwa";
    private static final String REMEMBER_LOGIN_KEY = "com.mathworks.widgets.login.LoginProperties.rememberLogin";
    private static final String WS_LOGIN_TOKEN_KEY = "com.mathworks.widgets.login.LoginProperties.loginWsToken";
    private final boolean fRememberLoginDefault;

    public DefaultPersistenceStrategy() {
        this(false);
    }

    public DefaultPersistenceStrategy(boolean bl) {
        this.fRememberLoginDefault = bl;
    }

    @Override
    public boolean readRememberLogin() {
        return DefaultPersistenceStrategy.getBoolean(REMEMBER_LOGIN_KEY, this.fRememberLoginDefault);
    }

    @Override
    public void writeRememberLogin(boolean bl) {
        DefaultPersistenceStrategy.setBoolean(REMEMBER_LOGIN_KEY, bl);
    }

    @Override
    public String readLoginToken() {
        return DefaultPersistenceStrategy.getString(WS_LOGIN_TOKEN_KEY, "");
    }

    @Override
    public void writeLoginToken(String string) {
        DefaultPersistenceStrategy.setString(WS_LOGIN_TOKEN_KEY, string);
    }

    @Override
    public String readMwaUserName() {
        return DefaultPersistenceStrategy.getString(MWA_USER_NAME_KEY, "");
    }

    @Override
    public void writeMwaUserName(String string) {
        DefaultPersistenceStrategy.setString(MWA_USER_NAME_KEY, string);
    }

    private static boolean getBoolean(String string, boolean bl) {
        return Prefs.getBooleanPref((String)string, (boolean)bl);
    }

    private static void setBoolean(String string, boolean bl) {
        Prefs.setBooleanPref((String)string, (boolean)bl);
    }

    private static String getString(String string, String string2) {
        return Prefs.getStringPref((String)string, (String)string2);
    }

    private static void setString(String string, String string2) {
        Prefs.setStringPref((String)string, (String)string2);
    }
}

