/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.internal.loginws.client.v2.LoginServiceClient;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.AuthenticationResponse;
import com.mathworks.widgets.login.DefaultPersistenceStrategy;
import com.mathworks.widgets.login.LoginPersistenceStrategy;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.Validate;
import com.mathworks.widgets.login.ValidationListener;
import com.mathworks.widgets.login.ValidationStrategy;

public abstract class AbstractValidationStrategy
implements ValidationStrategy {
    private String fWsEndpoint = null;
    private LoginServiceClient fLoginService = null;

    @Override
    public void doAuthentication(AuthenticationListener authenticationListener) {
        this.getUniversalLoginHandler().invokeLogin(authenticationListener, this.getLoginPersistenceStrategy(), this.fWsEndpoint, this.fLoginService, UniversalLoginComponent.LoginDisplayType.LOGIN_AND_BENEFITS);
    }

    @Override
    public void doValidation(AuthenticationResponse authenticationResponse, ValidationListener validationListener) {
        if (this.fLoginService != null) {
            Validate.validateToken(authenticationResponse, validationListener, this.getValidationCriteria(), this.getClientString(), this.fLoginService);
        } else {
            Validate.validateToken(authenticationResponse, validationListener, this.getValidationCriteria(), this.getClientString(), this.getProxySettings());
        }
    }

    @Override
    public LoginPersistenceStrategy getLoginPersistenceStrategy() {
        return new DefaultPersistenceStrategy();
    }

    protected void setWsEndpoint(String string) {
        this.fWsEndpoint = string;
    }

    protected void setLoginServiceClient(LoginServiceClient loginServiceClient) {
        this.fLoginService = loginServiceClient;
    }

    protected String getWsEndpoint() {
        return this.fWsEndpoint;
    }
}

