/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class RowListTransactionTarget<T>
implements GroupingTableTransaction.Target<T> {
    private final Adapter<T> fAdapter;
    private List<GroupingTableRow<T>> fRowList;
    private Map<T, Integer> fItemMap;
    private int fOriginalSize;

    RowListTransactionTarget(Adapter<T> adapter) {
        this.fAdapter = adapter;
    }

    @Override
    public synchronized void startTransaction() {
        this.fRowList = this.fAdapter.start();
        this.fItemMap = new HashMap<T, Integer>(this.fRowList.size());
        for (int i = 0; i < this.fRowList.size(); ++i) {
            GroupingTableRow<T> groupingTableRow = this.fRowList.get(i);
            if (groupingTableRow.getItem() == null) continue;
            this.fItemMap.put(groupingTableRow.getItem(), i);
        }
        this.fOriginalSize = this.fRowList.size();
    }

    @Override
    public synchronized GroupingTableTransaction.UpdateResult update(T t) {
        Integer n = this.fItemMap.get(t);
        if (n == null || n < 0 || n >= this.fRowList.size()) {
            return GroupingTableTransaction.UpdateResult.DOES_NOT_EXIST;
        }
        GroupingTableRow<T> groupingTableRow = this.fRowList.get(n);
        return groupingTableRow.updateItem(t);
    }

    @Override
    public synchronized boolean add(T t) {
        Integer n = this.fItemMap.get(t);
        if (n != null && n >= 0 && n < this.fRowList.size()) {
            return false;
        }
        GroupingTableRow<T> groupingTableRow = this.fAdapter.createRow(t);
        this.fRowList.add(groupingTableRow);
        this.fItemMap.put(t, this.fRowList.size() - 1);
        return true;
    }

    @Override
    public synchronized boolean remove(T t) {
        Integer n = this.fItemMap.get(t);
        if (n == null || n < 0 || n >= this.fRowList.size()) {
            return false;
        }
        GroupingTableRow<T> groupingTableRow = this.fRowList.get(n);
        groupingTableRow.dispose();
        this.fRowList.remove(n);
        this.fItemMap.remove(t);
        for (Map.Entry<T, Integer> entry : this.fItemMap.entrySet()) {
            if (entry.getValue() <= n) continue;
            entry.setValue(entry.getValue() - 1);
        }
        return true;
    }

    @Override
    public synchronized void clear() {
        for (GroupingTableRow<T> groupingTableRow : this.fRowList) {
            groupingTableRow.dispose();
        }
        this.fRowList.clear();
        this.fItemMap.clear();
    }

    @Override
    public synchronized void finishTransaction(boolean bl, boolean bl2) {
        if (this.fAdapter.inOverflowState() || this.fAdapter.detectOverflow(this.fRowList.size() - this.fOriginalSize)) {
            this.fRowList = null;
            this.fItemMap = null;
            return;
        }
        if (bl && this.fAdapter.getConfiguration().getSortColumn() != null) {
            GroupingTableUtils.sortNonRecursively(this.fRowList, this.fAdapter.getConfiguration().getAscendingSortComparator(), this.fAdapter.getConfiguration().isSortedDescending());
            this.fItemMap.clear();
            for (int i = 0; i < this.fRowList.size(); ++i) {
                this.fItemMap.put(this.fRowList.get(i).getItem(), i);
            }
        }
        this.fAdapter.commitRows(this.fRowList, this.fItemMap, bl2);
        this.fRowList = null;
        this.fItemMap = null;
    }

    public static interface Adapter<T> {
        public List<GroupingTableRow<T>> start();

        public void commitRows(List<GroupingTableRow<T>> var1, Map<T, Integer> var2, boolean var3);

        public boolean detectOverflow(int var1);

        public boolean inOverflowState();

        public GroupingTableRow<T> createRow(T var1);

        public GroupingTableConfiguration<T> getConfiguration();
    }
}

