/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ContrastingIcon;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTChildAction;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class DTUtilities {
    private static volatile JFrame sTemporaryFrame = null;
    private static volatile Boolean sMenuBarRefreshEnabled = true;

    private DTUtilities() {
    }

    static String constrainTitle(String string, int n) {
        if (string.length() > n) {
            string = n >= 3 ? string.substring(0, n - 3) : "";
            string = string + "...";
        }
        return string;
    }

    static String constrainTitle(String string) {
        return DTUtilities.constrainTitle(string, 24);
    }

    public static String exciseEllipsis(String string) {
        return string.replace("...", "");
    }

    static void blockKeyboardInputs(JComponent jComponent, KeyStroke[] keyStrokeArray) {
        InputMap inputMap = jComponent.getInputMap(1);
        InputMap inputMap2 = null;
        for (KeyStroke keyStroke : keyStrokeArray) {
            Object object = inputMap.get(keyStroke);
            if (object == null) continue;
            if (inputMap2 == null) {
                inputMap2 = new InputMap();
            }
            inputMap2.put(keyStroke, "do nothing");
        }
        if (inputMap2 != null) {
            inputMap2.setParent(inputMap);
            jComponent.setInputMap(1, inputMap2);
        }
    }

    public static String getTempDirectory() {
        String string = PlatformInfo.isWindows() ? System.getProperties().getProperty("java.io.tmpdir") : System.getProperties().getProperty("user.home");
        char c = System.getProperties().getProperty("file.separator").charAt(0);
        if (string.charAt(string.length() - 1) != c) {
            string = string + c;
        }
        return string;
    }

    public static boolean hasHeavyNonWindowAncestor(Component component) {
        boolean bl = false;
        while (component != null && !(component instanceof Window) && !bl) {
            bl = !component.isLightweight();
            component = component.getParent();
        }
        return bl;
    }

    static void drawGradientBackground(Graphics2D graphics2D, Rectangle rectangle, Color color, Axis axis, Curvature curvature) {
        GradientPaint gradientPaint;
        Paint paint;
        Color color2 = DTUtilities.getGradientLight(color);
        Color color3 = DTUtilities.getGradientDark(color);
        if (axis == Axis.Y_AXIS) {
            paint = curvature == Curvature.CONVEX ? color2 : color3;
            Color color4 = curvature == Curvature.CONVEX ? color3 : color2;
            gradientPaint = new GradientPaint(0.0f, rectangle.y, (Color)paint, 0.0f, rectangle.y + rectangle.height, color4, true);
        } else {
            paint = curvature == Curvature.CONVEX ? color2 : color3;
            Color color5 = curvature == Curvature.CONVEX ? color3 : color2;
            gradientPaint = new GradientPaint(rectangle.x, 0.0f, (Color)paint, rectangle.x + rectangle.width, 0.0f, color5, true);
        }
        paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setPaint(paint);
    }

    static void drawEnds(Graphics graphics, Rectangle rectangle, Axis axis) {
        graphics.setColor(new Color(255, 255, 255, 127));
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        if (axis == Axis.Y_AXIS) {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n2);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y, n, rectangle.y);
        }
        graphics.setColor(new Color(0, 0, 0, 47));
        if (axis == Axis.Y_AXIS) {
            graphics.drawLine(n - 1, rectangle.y, n - 1, n2);
        } else {
            graphics.drawLine(rectangle.x, n2 - 1, n, n2 - 1);
        }
    }

    static Color getGradientLight(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (fArray[1] > 0.5f || fArray[2] < 0.65f) {
            return ColorUtils.fade((Color)color);
        }
        fArray[2] = 1.25f * fArray[2];
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
    }

    static Color getGradientDark(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (fArray[1] < 0.2f) {
            fArray[2] = 0.85f * fArray[2];
            return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
        return fArray[1] > 0.5f || fArray[2] < 0.65f ? color : ColorUtils.intensify((Color)color);
    }

    static Icon createContrastingIcon(ImageIcon imageIcon) {
        return new ContrastingIcon((Icon)IconUtils.changeIconColor((ImageIcon)imageIcon, (Color)Color.white), (Icon)imageIcon);
    }

    public static boolean usingMacScreenMenus() {
        return PlatformInfo.isMacintosh() && "true".equalsIgnoreCase(System.getProperty("apple.laf.useScreenMenuBar"));
    }

    public static void refreshMenuBar() {
        if (DTUtilities.usingMacScreenMenus() && sMenuBarRefreshEnabled.booleanValue() && sTemporaryFrame == null) {
            sMenuBarRefreshEnabled = false;
            sTemporaryFrame = new JFrame();
            sTemporaryFrame.setUndecorated(true);
            sTemporaryFrame.setLocation(Short.MIN_VALUE, Short.MIN_VALUE);
            sTemporaryFrame.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sTemporaryFrame != null) {
                        sTemporaryFrame.dispose();
                        sTemporaryFrame = null;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                sMenuBarRefreshEnabled = true;
                            }
                        });
                    }
                }
            });
        }
    }

    public static void applicationWillResignActive() {
        sMenuBarRefreshEnabled = false;
    }

    public static void applicationWillBecomeActive() {
        sMenuBarRefreshEnabled = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DTUtilities.refreshMenuBar();
            }
        });
    }

    public static DTChildAction createDTChildAction(DTMenuMergeTag dTMenuMergeTag, String string, String string2, KeyBindingManager keyBindingManager) {
        DTChildAction dTChildAction = new DTChildAction(dTMenuMergeTag);
        keyBindingManager.addKeyBindingAndActionInfo(string, string2, (ExtendedAction)dTChildAction);
        dTChildAction.setName(null);
        return dTChildAction;
    }

    static enum Axis {
        X_AXIS,
        Y_AXIS;

    }

    static enum Curvature {
        CONVEX,
        CONCAVE;

    }
}

